/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Timer;
import org.monte.media.ilbm.ColorCycle;

public class ColorCyclingMemoryImageSource
extends MemoryImageSource {
    private int width;
    private int height;
    private ColorModel model;
    private Object pixels;
    private int pixeloffset;
    private int pixelscan;
    private Hashtable<?, ?> properties;
    private ArrayList<ColorCycle> colorCycles = new ArrayList();
    private Timer timer;
    private HashSet<ImageConsumer> consumers = new HashSet();
    private boolean isColorCyclingAvailable;
    private boolean isStarted;
    private boolean isBlendedColorCycling;
    private volatile ColorModel cycledModel;

    public ColorCyclingMemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        super(w, h, cm, pix, off, scan);
        this.initialize(w, h, cm, pix, off, scan, new Hashtable());
    }

    public ColorCyclingMemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable<?, ?> props) {
        super(w, h, cm, pix, off, scan, props);
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    public ColorCyclingMemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        super(w, h, cm, pix, off, scan);
        this.initialize(w, h, cm, pix, off, scan, null);
    }

    public ColorCyclingMemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        super(w, h, cm, pix, off, scan, props);
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    private void initialize(int w, int h, ColorModel cm, Object pix, int off, int scan, Hashtable<?, ?> props) {
        this.width = w;
        this.height = h;
        this.model = cm;
        this.pixels = pix;
        this.pixeloffset = off;
        this.pixelscan = scan;
        this.properties = props == null ? new Hashtable() : props;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Hashtable<?, ?> getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        super.newPixels(newpix, this.cycledModel == null ? newmodel : this.cycledModel, offset, scansize);
    }

    @Override
    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        super.newPixels(newpix, this.cycledModel == null ? newmodel : this.cycledModel, offset, scansize);
    }

    public void addColorCycle(ColorCycle cc) {
        this.colorCycles.add(cc);
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        super.addConsumer(ic);
        this.consumers.add(ic);
        if (this.isStarted && !this.consumers.isEmpty()) {
            this.startAnimationTimer();
        }
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        super.removeConsumer(ic);
        this.consumers.remove(ic);
        if (this.isStarted && this.consumers.isEmpty()) {
            this.stopAnimationTimer();
        }
    }

    @Override
    public void setAnimated(boolean b) {
        super.setAnimated(b);
        this.isColorCyclingAvailable = b;
        if (this.isColorCyclingAvailable && !this.consumers.isEmpty() && this.isStarted) {
            this.startAnimationTimer();
        } else {
            this.stopAnimationTimer();
        }
    }

    public void setColorCyclingStarted(boolean b) {
        this.isStarted = b;
        if (this.isColorCyclingAvailable && !this.consumers.isEmpty() && this.isStarted) {
            this.startAnimationTimer();
        } else {
            this.stopAnimationTimer();
        }
    }

    public boolean isColorCyclingStarted() {
        return this.isStarted;
    }

    public void start() {
        this.setColorCyclingStarted(true);
    }

    public void stop() {
        this.setColorCyclingStarted(false);
    }

    public boolean isStarted() {
        return this.isColorCyclingStarted();
    }

    private synchronized void startAnimationTimer() {
        if (this.timer != null) {
            return;
        }
        if (this.model instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.model;
            final int[] rgbs = new int[icm.getMapSize()];
            icm.getRGBs(rgbs);
            int delay = 1000;
            boolean i = false;
            if (this.isBlendedColorCycling) {
                for (ColorCycle cc : this.colorCycles) {
                    int ccDelay;
                    if (!cc.isActive() || (ccDelay = 250 * cc.getTimeScale() / cc.getRate()) >= delay) continue;
                    delay = Math.max(1, ccDelay);
                }
                delay = Math.max(delay, 16);
            } else {
                for (ColorCycle cc : this.colorCycles) {
                    int ccDelay;
                    if (!cc.isActive() || (ccDelay = 500 * cc.getTimeScale() / cc.getRate()) >= delay) continue;
                    delay = Math.max(1, ccDelay);
                }
            }
            this.timer = new Timer(delay, new ActionListener(){
                private int[] previousCycled;
                private int[] cycled;
                long startTime;
                final /* synthetic */ ColorCyclingMemoryImageSource this$0;
                {
                    this.this$0 = this$0;
                    this.previousCycled = new int[rgbs.length];
                    this.cycled = new int[rgbs.length];
                    this.startTime = System.currentTimeMillis();
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    long now = System.currentTimeMillis();
                    System.arraycopy(rgbs, 0, this.cycled, 0, rgbs.length);
                    for (ColorCycle cc : this.this$0.colorCycles) {
                        cc.doCycle(this.cycled, now - this.startTime);
                    }
                    if (!Arrays.equals(this.previousCycled, this.cycled)) {
                        this.this$0.cycledModel = new IndexColorModel(8, this.cycled.length, this.cycled, 0, false, -1, 0);
                        ColorCyclingMemoryImageSource.super.newPixels((byte[])this.this$0.pixels, this.this$0.cycledModel, this.this$0.pixeloffset, this.this$0.pixelscan);
                    }
                    int[] tmp = this.previousCycled;
                    this.previousCycled = this.cycled;
                    this.cycled = tmp;
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private synchronized void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            this.cycledModel = null;
            ColorCyclingMemoryImageSource.super.newPixels((byte[])this.pixels, this.model, this.pixeloffset, this.pixelscan);
        }
    }

    public BufferedImage toBufferedImage() {
        DataBuffer buf = this.pixels instanceof byte[] ? new DataBufferByte((byte[])this.pixels, this.pixelscan * this.height, this.pixeloffset) : new DataBufferInt((int[])this.pixels, this.pixelscan * this.height, this.pixeloffset);
        SampleModel sm = this.model.createCompatibleSampleModel(this.width, this.height);
        WritableRaster raster = Raster.createWritableRaster(sm, buf, new Point());
        return new BufferedImage(this.model, raster, false, this.properties);
    }

    public boolean isColorCyclingAvailable() {
        return this.isColorCyclingAvailable;
    }

    public void putProperties(Map<?, ?> props) {
        this.properties.putAll(props);
    }

    public void setBlendedColorCycling(boolean newValue) {
        this.isBlendedColorCycling = newValue;
        for (ColorCycle cc : this.colorCycles) {
            cc.setBlended(newValue);
        }
        if (this.isStarted()) {
            this.stop();
            this.start();
        }
    }

    public boolean isBlendedColorCycling() {
        return this.isBlendedColorCycling;
    }
}

