/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.monte.media.seq.SEQDeltaFrame;
import org.monte.media.seq.SEQMovieTrack;

public class SEQDecoder {
    private ImageInputStream in;
    private int nFrames;
    private int speed;
    private long[] offsets;
    private int resolution = -1;
    private int nColors = -1;
    private SEQMovieTrack track;
    private boolean enforce8BitColorModel = true;

    public SEQDecoder(InputStream in) {
        this.in = new MemoryCacheImageInputStream(in);
        this.in.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public SEQDecoder(ImageInputStream in) {
        this.in = in;
        this.in.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public void produce(SEQMovieTrack track, boolean loadAudio) throws IOException {
        this.track = track;
        this.readHeader();
        this.readOffsets();
        this.readFrames();
    }

    public void setEnforce8BitColorModel(boolean b) {
        this.enforce8BitColorModel = b;
    }

    private void readHeader() throws IOException {
        int magic = this.in.readUnsignedShort();
        if (magic != 65243 && magic != 65244) {
            throw new IOException("SEQ Header: Invalid magic number 0x" + Integer.toHexString(magic) + ", expected 0xfedb or 0xfedc.");
        }
        int version = this.in.readUnsignedShort();
        if (version != 0) {
            throw new IOException("SEQ Header: Invalid version " + version + ", expected 0.");
        }
        long numberOfFrames = this.in.readUnsignedInt();
        if (numberOfFrames > Integer.MAX_VALUE) {
            throw new IOException("SEQ Header: Too many frames " + numberOfFrames + ", expected 0.");
        }
        this.nFrames = (int)numberOfFrames;
        this.speed = this.in.readUnsignedShort();
        this.track.setJiffies(6000);
        int skipped = this.in.skipBytes(118);
        if (skipped != 118) {
            throw new IOException("SEQ Header: Unexpected EOF.");
        }
    }

    private void readOffsets() throws IOException {
        this.offsets = new long[this.nFrames];
        for (int i = 0; i < this.nFrames; ++i) {
            this.offsets[i] = this.in.readUnsignedInt();
        }
    }

    private void readFrames() throws IOException {
        for (int i = 0; i < this.nFrames; ++i) {
            this.readFrame(i);
        }
    }

    private void readFrame(int i) throws IOException {
        int type = this.in.readUnsignedShort();
        if (type != 65535) {
            throw new IOException("Frame Header " + i + ": Invalid type " + type + ", expected 0xffff.");
        }
        int res = this.in.readUnsignedShort();
        if (res > 2) {
            throw new IOException("Frame Header " + i + ": Illegal resolution " + res + ", expected range [0,2].");
        }
        if (this.resolution == -1) {
            this.resolution = res;
            switch (res) {
                case 0: {
                    this.track.setWidth(320);
                    this.track.setHeight(200);
                    this.track.setNbPlanes(4);
                    this.nColors = 16;
                    break;
                }
                case 1: {
                    this.track.setWidth(640);
                    this.track.setHeight(200);
                    this.track.setNbPlanes(2);
                    this.nColors = 4;
                    break;
                }
                case 2: {
                    this.track.setWidth(640);
                    this.track.setHeight(400);
                    this.track.setNbPlanes(1);
                    this.nColors = 2;
                }
            }
        }
        if (res != this.resolution) {
            throw new IOException("Frame Header " + i + ": Illegal resolution change " + res + ", expected " + this.resolution + ".");
        }
        byte[] r = new byte[this.nColors];
        byte[] g = new byte[this.nColors];
        byte[] b = new byte[this.nColors];
        for (int j = 0; j < this.nColors; ++j) {
            int clr = this.in.readUnsignedShort();
            int red = (clr & 0x700) >> 8;
            int green = (clr & 0x70) >> 4;
            int blue = clr & 7;
            r[j] = (byte)(red << 5 | red << 2 | red >>> 1);
            g[j] = (byte)(green << 5 | green << 2 | green >>> 1);
            b[j] = (byte)(blue << 5 | blue << 2 | blue >>> 1);
        }
        IndexColorModel cm = new IndexColorModel(this.enforce8BitColorModel ? 8 : 4, this.nColors, r, g, b);
        if (this.in.skipBytes(12) != 12) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in filename.");
        }
        if (this.in.skipBytes(1) != 1) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in color animation flag.");
        }
        if (this.in.skipBytes(1) != 1) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in color animation range.");
        }
        if (this.in.skipBytes(1) != 1) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in color animation activation flag.");
        }
        if (this.in.skipBytes(1) != 1) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in color animation speeddir.");
        }
        if (this.in.skipBytes(2) != 2) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in color animation steps.");
        }
        int xOffset = this.in.readUnsignedShort();
        int yOffset = this.in.readUnsignedShort();
        int width = this.in.readUnsignedShort();
        int height = this.in.readUnsignedShort();
        int operation = this.in.readUnsignedByte();
        if (operation > 1) {
            throw new IOException("Frame Header " + i + ": Unexpected operation " + operation + ", expected range [0,1|.");
        }
        int storageMethod = this.in.readUnsignedByte();
        if (storageMethod > 1) {
            throw new IOException("Frame Header " + i + ": Unexpected storage method " + storageMethod + ", expected range [0,1|.");
        }
        long nData = this.in.readUnsignedInt();
        if (nData > Integer.MAX_VALUE) {
            throw new IOException("Frame Header " + i + ": Too much data " + nData + ", expected range [0,2147483647|.");
        }
        if (this.in.skipBytes(60) != 60) {
            throw new IOException("Frame Header " + i + ": Unexpected EOF in reserved fields.");
        }
        byte[] data = new byte[(int)nData];
        this.in.readFully(data);
        SEQDeltaFrame f = new SEQDeltaFrame();
        f.setBounds(xOffset, yOffset, width, height);
        f.setOperation(operation);
        f.setStorageMethod(storageMethod);
        f.setData(data);
        f.setColorModel(cm);
        f.setRelTime(this.speed);
        f.setInterleave(1);
        this.track.addFrame(f);
    }
}

