/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Track;
import org.monte.media.math.Rational;
import org.monte.media.seq.SEQDemultiplexer;

public class SEQTrack
implements Track {
    private SEQDemultiplexer demux;
    private long position;
    private Format outputFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"});

    public SEQTrack(SEQDemultiplexer demux) {
        this.demux = demux;
    }

    public long getSampleCount() {
        return this.demux.getFrameCount();
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public long getPosition() {
        return this.position;
    }

    public void read(Buffer buf) {
        if (this.position < (long)this.demux.getFrameCount()) {
            buf.setFlagsTo(new BufferFlag[]{BufferFlag.KEYFRAME});
            if (!(buf.data instanceof AmigaBitmapImage)) {
                buf.data = this.demux.createCompatibleBitmap();
            }
            this.demux.readFrame((int)this.position, (AmigaBitmapImage)buf.data);
            buf.sampleDuration = new Rational((long)this.demux.getDuration((int)this.position), (long)this.demux.getJiffies());
            buf.format = this.outputFormat;
            ++this.position;
        } else {
            buf.setFlagsTo(new BufferFlag[]{BufferFlag.DISCARD});
        }
    }

    public Format getFormat() {
        return this.outputFormat;
    }
}

