/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.animconverter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.amigabitmap.codec.video.AmigaBitmapCodec;
import org.monte.media.anim.ANIMDemultiplexer;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieResources;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.CodecChain;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Track;
import org.monte.media.av.codec.video.PNGCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.iff.MC68000InputStream;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeMultiplexer;

public class AnimToQuickTimeConverter {
    private AmigaBitmapImage bitmapEven;
    private AmigaBitmapImage bitmapOdd;
    private ColorCyclingMemoryImageSource memoryImage;
    private boolean setSwapLeftRightChannels;
    private Integer xAspect;
    private Integer yAspect;
    private Integer frameDuration;

    public void convert(String animFile, String quickTimeFile) throws IOException {
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path inputPath = userDir.resolve(Paths.get(animFile, new String[0]));
        Path quickTimePath = userDir.resolve(Paths.get(quickTimeFile, new String[0]));
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new IOException("Input file does not exist: " + String.valueOf(inputPath));
        }
        if (Files.isDirectory(quickTimePath, new LinkOption[0])) {
            throw new IOException("Output file must not be a directory: " + String.valueOf(quickTimePath));
        }
        if (Files.isDirectory(inputPath, new LinkOption[0])) {
            Files.walk(inputPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().forEach(f -> {
                block11: {
                    try {
                        String fName = f.getFileName().toString();
                        String fNameWithoutExtension = this.getFilenameWithoutExtension(fName);
                        if (fName.endsWith(".zip")) {
                            this.convertZipFile((Path)f);
                            break block11;
                        }
                        if (!this.isANIM((Path)f)) break block11;
                        ANIMDemultiplexer demux = this.createDemux((Path)f);
                        if (!demux.getResources().getColorCycles().isEmpty()) {
                            System.out.println("CC: " + String.valueOf(f));
                        }
                        Path quickTimePath2 = f.getParent().resolve(fNameWithoutExtension + ".mov");
                        Path mp4Path = f.getParent().resolve(fNameWithoutExtension + ".mp4");
                        if (!Files.exists(quickTimePath2, new LinkOption[0])) {
                            try (QuickTimeMultiplexer mux = new QuickTimeMultiplexer(quickTimePath2.toFile());){
                                mux.setMovieTimeScale((long)demux.getTimeBase());
                                this.convertToQuickTime(demux, mux, fName);
                            }
                        }
                        if (!Files.exists(mp4Path, new LinkOption[0])) {
                            this.convertToMP4(demux, quickTimePath2, mp4Path);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (animFile.endsWith(".zip")) {
            this.convertZipFile(inputPath);
        } else {
            ANIMDemultiplexer demux = this.createDemux(inputPath);
            if (!Files.exists(quickTimePath, new LinkOption[0])) {
                QuickTimeMultiplexer mux = new QuickTimeMultiplexer(quickTimePath.toFile());
                mux.setMovieTimeScale((long)demux.getTimeBase());
                this.convertToQuickTime(demux, mux, inputPath.toString());
            }
            String fileNameWoEx = this.getFilenameWithoutExtension(inputPath.getFileName().toString());
            Path mp4Path = inputPath.getParent().resolve(fileNameWoEx + ".mp4");
            if (!Files.exists(mp4Path, new LinkOption[0])) {
                this.convertToMP4(demux, quickTimePath, mp4Path);
            }
        }
    }

    private ANIMDemultiplexer createDemux(Path f) throws IOException {
        ANIMDemultiplexer demux = new ANIMDemultiplexer(f.toFile());
        this.initDemux(demux);
        return demux;
    }

    private ANIMDemultiplexer createDemux(BufferedInputStream bin) throws IOException {
        ANIMDemultiplexer demux = new ANIMDemultiplexer((InputStream)bin);
        this.initDemux(demux);
        return demux;
    }

    private void initDemux(ANIMDemultiplexer demux) {
        if (this.frameDuration != null && this.frameDuration > 0) {
            long newRelTime = this.frameDuration.intValue();
            ANIMMovieResources res = demux.getResources();
            int n = res.getFrameCount();
            for (int i = 0; i < n; ++i) {
                ANIMFrame frame = res.getFrame(i);
                frame.setRelTime(newRelTime);
            }
        }
    }

    private void convertZipFile(Path zipFile) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    int separatorIndex;
                    String name = entry.getName();
                    int pendIndex = name.lastIndexOf(46);
                    if (pendIndex < (separatorIndex = name.lastIndexOf(47))) {
                        pendIndex = -1;
                    }
                    String nameWithoutExtension = pendIndex == -1 ? name : name.substring(0, pendIndex);
                    Path quickTimeFile = zipFile.getParent().resolve(nameWithoutExtension + ".mov");
                    Path mp4File = zipFile.getParent().resolve(nameWithoutExtension + ".mp4");
                    if (!Files.exists(quickTimeFile, new LinkOption[0]) || !Files.exists(mp4File, new LinkOption[0])) {
                        BufferedInputStream bin = new BufferedInputStream(zin){

                            @Override
                            public void close() {
                            }
                        };
                        bin.mark(20);
                        boolean anim = this.isANIM(bin);
                        if (anim) {
                            bin.reset();
                            System.out.println(String.valueOf(zipFile) + "!" + entry.getName());
                            ANIMDemultiplexer demux = this.createDemux(bin);
                            if (!demux.getResources().getColorCycles().isEmpty()) {
                                System.out.println("CC: " + String.valueOf(zipFile) + "!" + name);
                            } else {
                                if (!Files.exists(quickTimeFile, new LinkOption[0])) {
                                    try (QuickTimeMultiplexer mux = new QuickTimeMultiplexer(quickTimeFile.toFile());){
                                        this.convertToQuickTime(demux, mux, String.valueOf(zipFile) + "!" + name);
                                    }
                                }
                                if (!Files.exists(mp4File, new LinkOption[0])) {
                                    this.convertToMP4(demux, quickTimeFile, mp4File);
                                }
                            }
                        }
                    }
                }
                entry = zin.getNextEntry();
            }
        }
    }

    public void convertToQuickTime(ANIMDemultiplexer demux, QuickTimeMultiplexer mux, String animFile) throws IOException {
        Rational nextAudioBufferTime;
        if (!demux.getResources().getColorCycles().isEmpty()) {
            System.out.println(animFile + " has color cycles.");
            return;
        }
        Track videoTrack = null;
        Track audioTrack = null;
        Codec videoCodecChain = null;
        int videoTrackId = -1;
        int audioTrackId = -1;
        block4: for (Track track : demux.getTracks()) {
            switch ((FormatKeys.MediaType)track.getFormat().get(FormatKeys.MediaTypeKey)) {
                case VIDEO: {
                    videoTrack = track;
                    Format inputVideoFormat = track.getFormat();
                    AmigaBitmapCodec amigaBitmapCodec = new AmigaBitmapCodec();
                    PNGCodec pngCodec = new PNGCodec();
                    pngCodec.setOutputFormat(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class}).append(inputVideoFormat));
                    amigaBitmapCodec.setOutputFormat(new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}).append(inputVideoFormat));
                    videoCodecChain = CodecChain.createCodecChain((Codec[])new Codec[]{amigaBitmapCodec, pngCodec});
                    videoTrackId = mux.addTrack(videoCodecChain.getOutputFormat());
                    continue block4;
                }
                case AUDIO: {
                    if (audioTrackId != -1) continue block4;
                    audioTrack = track;
                    audioTrackId = mux.addTrack(audioTrack.getFormat());
                }
            }
        }
        Buffer videoInBuf = new Buffer();
        Buffer videoOutBuf = new Buffer();
        Buffer audioBuf = new Buffer();
        if (audioTrack != null) {
            audioTrack.read(audioBuf);
            mux.write(audioTrackId, audioBuf);
            nextAudioBufferTime = !audioBuf.isFlag(BufferFlag.DISCARD) ? audioBuf.timeStamp.add(audioBuf.sampleDuration.multiply((long)audioBuf.sampleCount)) : Rational.ZERO;
        } else {
            nextAudioBufferTime = Rational.ZERO;
        }
        if (videoTrack != null) {
            do {
                int process;
                videoTrack.read(videoInBuf);
                do {
                    process = videoCodecChain.process(videoInBuf, videoOutBuf);
                    if (audioTrack != null && !videoOutBuf.isFlag(BufferFlag.DISCARD) && nextAudioBufferTime.compareTo(videoOutBuf.timeStamp) <= 0) {
                        audioTrack.read(audioBuf);
                        if (!audioBuf.isFlag(BufferFlag.DISCARD)) {
                            mux.write(audioTrackId, audioBuf);
                            nextAudioBufferTime = audioBuf.timeStamp.add(audioBuf.sampleDuration.multiply((long)audioBuf.sampleCount));
                        }
                    }
                    mux.write(videoTrackId, videoOutBuf);
                } while ((process & 2) == 2);
            } while (!videoOutBuf.isFlag(BufferFlag.END_OF_MEDIA));
        }
        if (audioTrack != null) {
            while (!audioBuf.isFlag(BufferFlag.END_OF_MEDIA)) {
                audioTrack.read(audioBuf);
                mux.write(audioTrackId, audioBuf);
            }
        }
    }

    private void convertToMP4(ANIMDemultiplexer demux, Path quickTimeFile, Path mp4File) throws IOException {
        if (!Files.exists(mp4File, new LinkOption[0])) {
            int maxWidth = 1920;
            int maxHeight = 1080;
            int xAspect = this.xAspect == null ? demux.getResources().getXAspect() : this.xAspect.intValue();
            int yAspect = this.yAspect == null ? demux.getResources().getYAspect() : this.yAspect.intValue();
            int width = demux.getWidth();
            int height = demux.getHeight();
            System.out.println("  w=" + width + " h=" + height + " xa=" + xAspect + " ya=" + yAspect);
            int adjustedWidth = xAspect * width;
            int adjustedHeight = yAspect * height;
            double maxWidthFactor = (double)maxWidth / (double)adjustedWidth;
            double maxHeightFactor = (double)maxHeight / (double)adjustedHeight;
            double maxFactor = Math.min(maxWidthFactor, maxHeightFactor);
            int targetWidth = (int)Math.round((double)adjustedWidth * maxFactor);
            int targetHeight = (int)Math.round((double)adjustedHeight * maxFactor);
            targetWidth += targetWidth % 2;
            targetHeight += targetHeight % 2;
            System.out.println("  tw=" + targetWidth + " th=" + targetHeight);
            System.out.println(String.valueOf(quickTimeFile) + "  converting to " + String.valueOf(mp4File));
            String[] args = new String[]{"ffmpeg", "-i", quickTimeFile.toAbsolutePath().toString(), "-vf", "scale=" + targetWidth + ":" + targetHeight, "-sws_flags", "neighbor", "-vcodec", "h264", "-pix_fmt", "yuv420p", "-profile:v", "baseline", "-level", "3", "-preset:v", "slow", "-max_muxing_queue_size", "9999", "-n", mp4File.toAbsolutePath().toString()};
            StringBuilder buf = new StringBuilder();
            for (String arg : args) {
                if (buf.length() != 0) {
                    buf.append(" ");
                }
                buf.append(arg);
            }
            System.out.println(buf);
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            new Thread(() -> {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));){
                    String line = r.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = r.readLine();
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
                finally {
                    System.out.println("Reader finished.");
                }
            }).start();
        }
    }

    public void setSwapLeftRightChannels(boolean value) {
        this.setSwapLeftRightChannels = value;
    }

    private boolean isANIM(Path file) {
        boolean bl;
        block8: {
            InputStream in = Files.newInputStream(file, new OpenOption[0]);
            try {
                bl = this.isANIM(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private boolean isANIM(InputStream in) throws IOException {
        MC68000InputStream mc = new MC68000InputStream(in);
        int form = (int)mc.readULONG();
        long size = mc.readULONG();
        if (size == 0L) {
            size = mc.readINT64();
        }
        int type = mc.readLONG();
        return form == 1179603533 && type == 1095649613;
    }

    private String getFilenameWithoutExtension(String filename) {
        String fName = filename;
        int endIndex = fName.lastIndexOf(46);
        String fNameWithoutExtension = endIndex == -1 ? fName : fName.substring(0, endIndex);
        return fNameWithoutExtension;
    }

    public void setXAspect(Integer xAspect) {
        this.xAspect = xAspect;
    }

    public void setYAspect(Integer yAspect) {
        this.yAspect = yAspect;
    }

    public void setFrameDuration(Integer frameDuration) {
        this.frameDuration = frameDuration;
    }
}

