/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.animconverter;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monte.media.animconverter.AnimToQuickTimeConverter;

public class Main {
    private static final String HELP_KEY = "-h";
    private static final String X_ASPECT = "-xaspect";
    private static final String Y_ASPECT = "-yaspect";
    private static final String FRAME_DURATION = "-frameduration";
    private static final String SWAP_LEFT_RIGHT_CHANNELS = "--swap-left-right-channels";
    private static final String INPUTFILE_KEY = "-i";
    private static final String OUTPUTFILE_KEY = "-o";

    public static void main(String ... args) throws IOException {
        Map<String, String> options = Main.parseArgs(args);
        if (options.containsKey(HELP_KEY) || !options.containsKey(INPUTFILE_KEY)) {
            String version = Main.class.getPackage().getImplementationVersion();
            System.out.println("ANIMConverter" + (String)(version == null ? "" : " " + version));
            System.out.println("Converts an Amiga IFF Cell Animation into a QuickTime movie.");
            System.out.println("Copyright \u00a9 Werner Randelshofer, Switzerland.");
            System.out.println("License: MIT License");
            System.out.println("");
            System.out.println("Usage:");
            System.out.println("ANIMConverter [options] inputfile [outputfile]");
            System.out.println("  -h          show help");
            System.out.println("  -?          show help");
            System.out.println("  -help       show help");
            System.out.println("  --help      show help");
            System.out.println("  --swap-left-right-channels       swaps the left and right audio channel");
            System.out.println("  -xaspect    int   pixel x-aspect ratio, >= 1");
            System.out.println("  -yaspect    int   pixel y-aspect ratio, >= 1");
            System.out.println("  -frameduration    int   duration of a frame in jiffies, >= 1");
            System.out.println("  inputfile   Amiga IFF Cell Animation file, zip file or directory");
            System.out.println("  outputfile  QuickTime movie file");
            System.out.println("              If this argument is omitted, then the output filename ");
            System.out.println("              is the input filename with \".mov\" appended. ");
            System.exit(0);
        }
        if (!options.containsKey(OUTPUTFILE_KEY)) {
            options.put(OUTPUTFILE_KEY, options.get(INPUTFILE_KEY) + ".mov");
        }
        AnimToQuickTimeConverter converter = new AnimToQuickTimeConverter();
        converter.setXAspect(Main.parseInteger(options.get(X_ASPECT)));
        converter.setYAspect(Main.parseInteger(options.get(Y_ASPECT)));
        converter.setFrameDuration(Main.parseInteger(options.get(FRAME_DURATION)));
        converter.setSwapLeftRightChannels(options.containsKey(SWAP_LEFT_RIGHT_CHANNELS));
        converter.convert(options.get(INPUTFILE_KEY), options.get(OUTPUTFILE_KEY));
    }

    private static Integer parseInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    private static Map<String, String> parseArgs(String[] args) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        block15: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-h": 
                case "-?": 
                case "-help": 
                case "--help": {
                    options.put(HELP_KEY, args[i]);
                    continue block15;
                }
                case "--swap-left-right-channels": {
                    options.put(SWAP_LEFT_RIGHT_CHANNELS, args[i]);
                    continue block15;
                }
                case "-xaspect": 
                case "-yaspect": 
                case "-frameduration": {
                    if (i < args.length - 1) {
                        options.put(args[i], args[++i]);
                        continue block15;
                    }
                    System.err.println("Argument required after \"" + args[i] + "\".");
                    continue block15;
                }
                default: {
                    if (args[i].startsWith("-")) {
                        System.err.println("Unrecognized option \"" + args[i] + "\".");
                        System.exit(10);
                    }
                    if (!options.containsKey(INPUTFILE_KEY)) {
                        options.put(INPUTFILE_KEY, args[i]);
                        continue block15;
                    }
                    if (!options.containsKey(OUTPUTFILE_KEY)) {
                        options.put(OUTPUTFILE_KEY, args[i]);
                        continue block15;
                    }
                    System.err.println("Unrecognized argument \"" + args[i] + "\".");
                    System.exit(10);
                }
            }
        }
        return options;
    }
}

