/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.javafx;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;

public class FXImages {
    public static WritableImage toFXImage(BufferedImage bimg, WritableImage wimg) {
        int[] p;
        int w = bimg.getWidth();
        int h = bimg.getHeight();
        if (wimg == null || wimg.getWidth() != (double)w || wimg.getHeight() != (double)h) {
            wimg = new WritableImage(bimg.getWidth(), bimg.getHeight());
        }
        if (bimg.getSampleModel() instanceof SinglePixelPackedSampleModel && bimg.getRaster().getDataBuffer() instanceof DataBufferInt && (p = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData()).length == w * h) {
            switch (bimg.getType()) {
                case 1: {
                    int[] o = new int[p.length];
                    for (int i = 0; i < o.length; ++i) {
                        o[i] = p[i] | 0xFF000000;
                    }
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), o, 0, bimg.getWidth());
                    return wimg;
                }
                case 2: {
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), p, 0, bimg.getWidth());
                    return wimg;
                }
                case 3: {
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbPreInstance(), p, 0, bimg.getWidth());
                    return wimg;
                }
            }
        }
        return SwingFXUtils.toFXImage((BufferedImage)bimg, (WritableImage)wimg);
    }

    private FXImages() {
    }
}

