/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jmf.codec.video;

import com.sun.media.format.AviVideoFormat;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import org.monte.media.av.codec.video.TechSmithCodecCore;
import org.monte.media.io.SeekableByteArrayOutputStream;
import org.monte.media.jmf.codec.video.AbstractVideoDecoder;

public class TSCCCodec
extends AbstractVideoDecoder {
    protected static final int bMask = 255;
    protected static final int gMask = 65280;
    protected static final int rMask = 0xFF0000;
    private Object pixels;
    private Object previousPixels;
    private long previousSequenceNumber;
    private int frameCounter;
    private TechSmithCodecCore state;

    public TSCCCodec() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("tscc"), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, -1, -1, 0, -1), new IndexedColorFormat(null, -1, Format.byteArray, -1.0f, -1, 256, null, null, null)};
        this.defaultOutputFormats = new VideoFormat[]{new VideoFormat("tscc"), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, -1, -1, 0, -1), new IndexedColorFormat(null, -1, Format.byteArray, -1.0f, -1, 256, null, null, null)};
        this.pluginName = "TechSmith Screen-Capture Codec";
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format input) {
        Format[] formats = null;
        if (new VideoFormat("tscc").matches(input)) {
            VideoFormat inf = (VideoFormat)input;
            Dimension s = inf.getSize();
            RGBFormat outf = new RGBFormat(s, s.width < 0 || s.height < 0 ? -1 : s.width * s.height, Format.intArray, inf.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, s.width, 0, 0);
            formats = new Format[]{outf};
        } else if (new RGBFormat().matches(input)) {
            VideoFormat inf = (VideoFormat)input;
            Dimension s = inf.getSize();
            VideoFormat outf = new VideoFormat("tscc", s, -1, Format.byteArray, inf.getFrameRate());
            formats = new Format[]{outf};
        } else if (new IndexedColorFormat(null, -1, Format.byteArray, -1.0f, -1, 256, null, null, null).matches(input)) {
            VideoFormat inf = (VideoFormat)input;
            Dimension s = inf.getSize();
            VideoFormat outf = new VideoFormat("tscc", s, -1, Format.byteArray, inf.getFrameRate());
            formats = new Format[]{outf};
        }
        if (formats == null) {
            formats = new Format[]{};
        }
        return formats;
    }

    @Override
    public void reset() {
        this.previousSequenceNumber = 0L;
        this.frameCounter = 0;
        this.state = null;
    }

    public int process(Buffer input, Buffer output) {
        if (this.state == null) {
            this.state = new TechSmithCodecCore();
        }
        if (this.outputFormat.getEncoding().equals("tscc")) {
            return this.encode(input, output);
        }
        return this.decode(input, output);
    }

    protected void copyMetaTo(Buffer in, Buffer out) {
        out.setTimeStamp(in.getTimeStamp());
        out.setDuration(in.getDuration());
        out.setSequenceNumber(in.getSequenceNumber());
        out.setFlags(in.getFlags());
    }

    protected int encode(Buffer in, Buffer out) {
        int pixelStride;
        int scanlineStride;
        int inputDepth;
        if (in.isDiscard()) {
            out.setDiscard(true);
            return 0;
        }
        this.copyMetaTo(in, out);
        out.setFormat((Format)this.outputFormat);
        SeekableByteArrayOutputStream tmp = out.getData() instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.getData()) : new SeekableByteArrayOutputStream();
        VideoFormat outvf = this.outputFormat;
        boolean isKeyframe = TSCCCodec.isSet(in, 16) || this.frameCounter % (int)outvf.getFrameRate() == 0;
        ++this.frameCounter;
        VideoFormat invf = this.inputFormat;
        int width = invf.getSize().width;
        int height = invf.getSize().height;
        int offset = in.getOffset();
        if (invf instanceof RGBFormat) {
            RGBFormat inrgbf = (RGBFormat)this.inputFormat;
            inputDepth = inrgbf.getBitsPerPixel();
            scanlineStride = inrgbf.getLineStride();
            pixelStride = inrgbf.getPixelStride();
            if (inrgbf.getFlipped() == 1) {
                offset += (height - 1) * scanlineStride;
                scanlineStride = -scanlineStride;
            }
        } else if (invf instanceof AviVideoFormat) {
            inicvf = (IndexedColorFormat)this.inputFormat;
            inputDepth = ((AviVideoFormat)invf).getBitsPerPixel();
            scanlineStride = inicvf.getLineStride();
            pixelStride = 1;
        } else {
            inicvf = (IndexedColorFormat)this.inputFormat;
            inputDepth = 8;
            scanlineStride = inicvf.getLineStride();
            pixelStride = 1;
            this.state.setPalette(inicvf.getRedValues(), inicvf.getGreenValues(), inicvf.getBlueValues());
        }
        if (pixelStride != 1) {
            return 1;
        }
        try {
            switch (inputDepth) {
                case 8: {
                    Object[] pixels = (byte[])in.getData();
                    if (pixels == null) {
                        TSCCCodec.setFlag(out, 2, true);
                        return 1;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey8to24((OutputStream)tmp, pixels, width, height, offset, scanlineStride);
                    } else {
                        this.state.encodeDelta8to24((OutputStream)tmp, pixels, (byte[])this.previousPixels, width, height, offset, scanlineStride);
                    }
                    TSCCCodec.setFlag(out, 16, isKeyframe);
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (byte[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = (short[])in.getData();
                    if (pixels == null) {
                        TSCCCodec.setFlag(out, 2, true);
                        return 1;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey16((OutputStream)tmp, (short[])pixels, width, height, offset, scanlineStride);
                    } else {
                        this.state.encodeDelta16((OutputStream)tmp, (short[])pixels, (short[])this.previousPixels, width, height, offset, scanlineStride);
                    }
                    TSCCCodec.setFlag(out, 16, isKeyframe);
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (short[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: 
                case 32: {
                    Object[] pixels = (int[])in.getData();
                    if (pixels == null) {
                        TSCCCodec.setFlag(out, 2, true);
                        return 1;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey24((OutputStream)tmp, (int[])pixels, width, height, offset, scanlineStride);
                    } else {
                        this.state.encodeDelta24((OutputStream)tmp, (int[])pixels, (int[])this.previousPixels, width, height, offset, scanlineStride);
                    }
                    TSCCCodec.setFlag(out, 16, isKeyframe);
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (int[])this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    TSCCCodec.setFlag(out, 2, true);
                    return 1;
                }
            }
            out.setFormat((Format)this.outputFormat);
            out.setData((Object)tmp.getBuffer());
            out.setOffset(0);
            out.setLength(tmp.size());
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            TSCCCodec.setFlag(out, 2, true);
            return 1;
        }
    }

    protected int decode(Buffer in, Buffer out) {
        boolean isKeyframe;
        boolean framesWereSkipped;
        long sequenceNumber;
        block26: {
            int header;
            int inputDepth;
            if (in.isDiscard()) {
                out.setDiscard(true);
                return 0;
            }
            this.copyMetaTo(in, out);
            out.setDiscard(false);
            out.setFormat((Format)this.outputFormat);
            VideoFormat invf = this.inputFormat;
            VideoFormat ooutvf = this.outputFormat;
            int width = invf.getSize().width;
            int height = invf.getSize().height;
            int offset = in.getOffset();
            if (invf instanceof RGBFormat) {
                RGBFormat inrgbf = (RGBFormat)this.outputFormat;
                inputDepth = 24;
                int scanlineStride = inrgbf.getLineStride();
                int pixelStride = inrgbf.getPixelStride();
                if (inrgbf.getFlipped() == 1) {
                    offset += (height - 1) * scanlineStride;
                    scanlineStride = -scanlineStride;
                }
            } else if (invf instanceof AviVideoFormat) {
                AviVideoFormat inavivf = (AviVideoFormat)invf;
                inputDepth = inavivf.getBitsPerPixel();
                int scanlineStride = width;
                boolean pixelStride = true;
            } else if (invf instanceof VideoFormat) {
                int pixelStride;
                VideoFormat vf = invf;
                inputDepth = 24;
                int scanlineStride = pixelStride = vf.getSize().width * 3;
            } else {
                IndexedColorFormat inicvf = (IndexedColorFormat)invf;
                inputDepth = 8;
                int scanlineStride = inicvf.getLineStride();
                boolean pixelStride = true;
            }
            int outputDepth = inputDepth;
            if (this.outputFormat instanceof RGBFormat) {
                outputDepth = ((RGBFormat)this.outputFormat).getBitsPerPixel();
            }
            if (256 == ((header = in.getHeader() instanceof Integer ? (Integer)in.getHeader() : 0) & 0x100)) {
                try {
                    this.state.decodePalette((byte[])in.getData(), in.getOffset(), in.getLength());
                    out.setFlags(2);
                    return 4;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    out.setDiscard(true);
                    return 1;
                }
            }
            if (inputDepth == 8 && outputDepth == 8) {
                if (!(this.pixels instanceof byte[]) || ((byte[])this.pixels).length < width * height) {
                    this.pixels = new byte[width * height];
                }
            } else if (inputDepth == 16 && outputDepth == 16) {
                if (!(this.pixels instanceof short[]) || ((short[])this.pixels).length < width * height) {
                    this.pixels = new int[width * height];
                }
            } else if (!(this.pixels instanceof int[]) || ((int[])this.pixels).length < width * height) {
                this.pixels = new int[width * height];
            }
            out.setData(this.pixels);
            out.setOffset(0);
            out.setLength(width * height);
            byte[] inDat = (byte[])in.getData();
            sequenceNumber = in.getSequenceNumber();
            framesWereSkipped = sequenceNumber != this.previousSequenceNumber + 1L;
            try {
                if (inputDepth == 8) {
                    isKeyframe = outputDepth == 8 ? this.state.decode8(inDat, in.getOffset(), in.getLength(), (byte[])this.pixels, (byte[])this.pixels, this.outputFormat.getSize().width, this.outputFormat.getSize().height, framesWereSkipped) : this.state.decode8(inDat, in.getOffset(), in.getLength(), (int[])this.pixels, (int[])this.pixels, this.outputFormat.getSize().width, this.outputFormat.getSize().height, framesWereSkipped);
                    break block26;
                }
                if (inputDepth == 16) {
                    isKeyframe = this.state.decode16(inDat, in.getOffset(), in.getLength(), (int[])this.pixels, (int[])this.pixels, this.outputFormat.getSize().width, this.outputFormat.getSize().height, framesWereSkipped);
                    break block26;
                }
                if (inputDepth == 24) {
                    isKeyframe = this.state.decode24(inDat, in.getOffset(), in.getLength(), (int[])this.pixels, (int[])this.pixels, this.outputFormat.getSize().width, this.outputFormat.getSize().height, framesWereSkipped);
                    break block26;
                }
                out.setDiscard(true);
                return 1;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                out.setDiscard(true);
                return 1;
            }
        }
        if (framesWereSkipped && !isKeyframe) {
            out.setDiscard(true);
        } else {
            this.previousSequenceNumber = sequenceNumber;
        }
        TSCCCodec.setFlag(out, 16, isKeyframe);
        return 0;
    }

    @Override
    public void close() {
        this.pixels = null;
        this.state = null;
    }

    @Override
    public void open() throws ResourceUnavailableException {
        this.state = new TechSmithCodecCore();
    }

    public static void registerWithJMF() {
        TSCCCodec codec = new TSCCCodec();
        PlugInManager.addPlugIn((String)TSCCCodec.class.getName(), (Format[])codec.supportedInputFormats, (Format[])codec.defaultOutputFormats, (int)2);
    }
}

