/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.screenrecorder;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.image.Images;
import org.monte.media.math.Rational;
import org.monte.media.screenrecorder.JAudioMonitor;
import org.monte.media.screenrecorder.JRecordingAreaFrame;
import org.monte.media.screenrecorder.ScreenRecorder;
import org.monte.media.screenrecorder.State;
import org.monte.media.swing.BackgroundTask;
import org.monte.media.swing.JLabelHyperlinkHandler;
import org.monte.media.swing.datatransfer.DropFileTransferHandler;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Handler handler = new Handler();
    private ScreenRecorder screenRecorder;
    private int depth;
    private int format;
    private int cursor;
    private int audioRate;
    private int channels;
    private int area;
    private int fps;
    private int audioSource;
    private File movieFolder;
    private Rectangle customAreaRect;
    private Timer timer;
    private String infoLabelText;
    private JRadioButtonMenuItem areaCustomItem;
    private ButtonGroup areaGroup;
    private JRadioButtonMenuItem areaScreenItem;
    private JRadioButtonMenuItem audio22kHzItem;
    private JRadioButtonMenuItem audio44kHzItem;
    private JMenu audioMenu;
    private JAudioMonitor audioMonitor;
    private ButtonGroup audioRateGroup;
    private ButtonGroup audioSourceGroup;
    private ButtonGroup channelsGroup;
    private ButtonGroup colorGroup;
    private JRadioButtonMenuItem colorMillionsItem;
    private JRadioButtonMenuItem colorThousandsItem;
    private JRadioButtonMenuItem colorHundredsItem;
    private JRadioButtonMenuItem cursoYellowItem;
    private JRadioButtonMenuItem cursorBlackItem;
    private ButtonGroup cursorGroup;
    private JRadioButtonMenuItem cursorNoneItem;
    private JRadioButtonMenuItem cursorWhiteItem;
    private JRadioButtonMenuItem formatAviItem;
    private ButtonGroup formatGroup;
    private JRadioButtonMenuItem formatQuicktimeItem;
    private JRadioButtonMenuItem fps10Item;
    private JRadioButtonMenuItem fps20Item;
    private ButtonGroup fpsGroup;
    private JLabel infoLabel;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JRadioButtonMenuItem monoItem;
    private JButton optionsButton;
    private JPopupMenu optionsMenu;
    private JToggleButton startStopButton;
    private JRadioButtonMenuItem stereoItem;
    private JLabel timeLabel;
    private JMenu videoMenu;

    private void setSelectedIndex(ButtonGroup group, int index) {
        Enumeration<AbstractButton> e = group.getElements();
        AbstractButton b = null;
        for (int i = 0; i <= index; ++i) {
            if (!e.hasMoreElements()) continue;
            b = e.nextElement();
        }
        group.setSelected(b.getModel(), true);
    }

    private int getSelectedIndex(ButtonGroup group) {
        AbstractButton b;
        int index = 0;
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements() && !(b = e.nextElement()).isSelected()) {
            ++index;
        }
        return index;
    }

    private AbstractButton getSelectedItem(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            return b;
        }
        return null;
    }

    private void buildAudioSourceMenu() {
        Preferences prefs = Preferences.userNodeForPackage(Main.class);
        this.audioSource = prefs.getInt("ScreenRecording.audioSource", 0);
        Vector<AudioSourceItem> items = Main.getAudioSources();
        this.audioSource = Math.max(0, Math.min(items.size() - 1, this.audioSource));
        int i = 0;
        for (AudioSourceItem item : items) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(item.title);
            mi.putClientProperty("AudioSourceItem", item);
            this.audioSourceGroup.add(mi);
            if (i == this.audioSource) {
                mi.setSelected(true);
            }
            this.audioMenu.insert(mi, i);
            ++i;
        }
    }

    public Main() {
        this.setContentPane(new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics gr) {
                Graphics2D g = (Graphics2D)gr;
                g.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getHeight(), new float[]{0.0f, 0.499f, 0.5f, 1.0f}, new Color[]{new Color(0x404040), new Color(0x2F2F2F), new Color(0x1E1E1E), new Color(0x151515)}));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        });
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(1, 2, 2, 2));
        this.setMinimumSize(new Dimension(Math.max(240, this.getPreferredSize().width), this.getPreferredSize().height));
        this.initComponents();
        String version = Main.class.getPackage().getImplementationVersion();
        if (version != null) {
            int p = version.indexOf(32);
            this.setTitle(this.getTitle() + " " + version.substring(0, p == -1 ? version.length() : p));
        }
        final Preferences prefs = Preferences.userNodeForPackage(Main.class);
        this.movieFolder = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new File(System.getProperty("user.home") + File.separator + "Videos") : new File(System.getProperty("user.home") + File.separator + "Movies");
        this.movieFolder = new File(prefs.get("ScreenRecorder.movieFolder", this.movieFolder.toString()));
        Image img = Images.createImage(Main.class, (String)"images/Recorder.StartStop.png");
        BufferedImage[] imgs = Images.split((Image)img, (int)4, (boolean)true);
        this.startStopButton.setUI((ButtonUI)BasicButtonUI.createUI(this.startStopButton));
        this.startStopButton.setIcon(new ImageIcon(imgs[0]));
        this.startStopButton.setDisabledIcon(new ImageIcon(imgs[1]));
        this.startStopButton.setSelectedIcon(new ImageIcon(imgs[2]));
        this.startStopButton.setPressedIcon(new ImageIcon(imgs[3]));
        this.startStopButton.setText(null);
        this.startStopButton.setBorderPainted(false);
        this.startStopButton.setOpaque(false);
        this.startStopButton.setMargin(new Insets(0, 0, 0, 0));
        this.startStopButton.setBorder(new EmptyBorder(2, 2, 2, 2));
        img = Images.createImage(Main.class, (String)"images/Recorder.Options.png");
        imgs = Images.split((Image)img, (int)2, (boolean)true);
        this.optionsButton.setUI((ButtonUI)BasicButtonUI.createUI(this.startStopButton));
        this.optionsButton.setIcon(new ImageIcon(imgs[0]));
        this.optionsButton.setDisabledIcon(new ImageIcon(imgs[1]));
        this.optionsButton.setText(null);
        this.optionsButton.setBorderPainted(false);
        this.optionsButton.setOpaque(false);
        this.optionsButton.setMargin(new Insets(0, 0, 0, 0));
        this.optionsButton.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.infoLabelText = this.infoLabel.getText();
        this.updateInfoLabel();
        new JLabelHyperlinkHandler(this.infoLabel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File f = new File(new URI(e.getActionCommand()));
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    Desktop.getDesktop().open(f);
                }
                catch (URISyntaxException ex) {
                    System.err.println("ScreenRecorderMain bad href " + e.getActionCommand() + ", " + String.valueOf(ex));
                }
                catch (IOException ex) {
                    System.err.println("ScreenRecorderMain io exception: " + String.valueOf(ex));
                }
            }
        });
        this.infoLabel.setTransferHandler((TransferHandler)new DropFileTransferHandler(1, null, new ActionListener(){
            final /* synthetic */ Main this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.movieFolder = new File(e.getActionCommand());
                prefs.put("ScreenRecorder.movieFolder", this.this$0.movieFolder.toString());
                this.this$0.updateInfoLabel();
            }
        }));
        this.depth = Math.min(Math.max(0, prefs.getInt("ScreenRecording.colorDepth", 3)), this.colorGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.colorGroup, this.depth);
        this.format = Math.min(Math.max(0, prefs.getInt("ScreenRecording.format", 1)), this.formatGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.formatGroup, this.format);
        this.cursor = Math.min(Math.max(0, prefs.getInt("ScreenRecording.cursor", 1)), this.cursorGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.cursorGroup, this.cursor);
        this.fps = Math.min(Math.max(0, prefs.getInt("ScreenRecording.fps", 1)), this.fpsGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.fpsGroup, this.fps);
        this.audioRate = Math.min(Math.max(0, prefs.getInt("ScreenRecording.audioRate", 1)), this.audioRateGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.audioRateGroup, this.audioRate);
        this.channels = Math.min(Math.max(0, prefs.getInt("ScreenRecording.channels", 0)), this.channelsGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.channelsGroup, this.channels);
        Dimension customDim = new Dimension(prefs.getInt("ScreenRecording.customAreaWidth", 1024), prefs.getInt("ScreenRecording.customAreaHeight", 768));
        Point customLoc = new Point(prefs.getInt("ScreenRecording.customAreaX", 100), prefs.getInt("ScreenRecording.customAreaY", 100));
        this.customAreaRect = new Rectangle(customLoc.x, customLoc.y, customDim.width, customDim.height);
        this.area = Math.min(Math.max(0, prefs.getInt("ScreenRecording.area", 0)), this.areaGroup.getButtonCount() - 1);
        this.setSelectedIndex(this.areaGroup, this.area);
        this.buildAudioSourceMenu();
        this.pack();
    }

    private void updateInfoLabel() {
        Object name = this.movieFolder.getName();
        if (((String)name).length() > 16) {
            name = ((String)name).substring(0, 14) + "...";
        }
        this.infoLabel.setText(this.infoLabelText.replaceAll("\"Movies\"", "<a href=\"" + String.valueOf(this.movieFolder.toURI()) + "\">" + (String)name + "</a>"));
    }

    private void initComponents() {
        this.optionsMenu = new JPopupMenu();
        this.formatAviItem = new JRadioButtonMenuItem();
        this.formatQuicktimeItem = new JRadioButtonMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.areaScreenItem = new JRadioButtonMenuItem();
        this.areaCustomItem = new JRadioButtonMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.videoMenu = new JMenu();
        this.colorMillionsItem = new JRadioButtonMenuItem();
        this.colorThousandsItem = new JRadioButtonMenuItem();
        this.colorHundredsItem = new JRadioButtonMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.fps20Item = new JRadioButtonMenuItem();
        this.fps10Item = new JRadioButtonMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.cursorBlackItem = new JRadioButtonMenuItem();
        this.cursorWhiteItem = new JRadioButtonMenuItem();
        this.cursoYellowItem = new JRadioButtonMenuItem();
        this.cursorNoneItem = new JRadioButtonMenuItem();
        this.audioMenu = new JMenu();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.audio44kHzItem = new JRadioButtonMenuItem();
        this.audio22kHzItem = new JRadioButtonMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.monoItem = new JRadioButtonMenuItem();
        this.stereoItem = new JRadioButtonMenuItem();
        this.formatGroup = new ButtonGroup();
        this.areaGroup = new ButtonGroup();
        this.colorGroup = new ButtonGroup();
        this.audioRateGroup = new ButtonGroup();
        this.cursorGroup = new ButtonGroup();
        this.fpsGroup = new ButtonGroup();
        this.channelsGroup = new ButtonGroup();
        this.audioSourceGroup = new ButtonGroup();
        this.startStopButton = new JToggleButton();
        this.timeLabel = new JLabel();
        this.audioMonitor = new JAudioMonitor();
        this.infoLabel = new JLabel();
        this.optionsButton = new JButton();
        FormListener formListener = new FormListener();
        this.formatGroup.add(this.formatAviItem);
        this.formatAviItem.setText("AVI");
        this.optionsMenu.add(this.formatAviItem);
        this.formatGroup.add(this.formatQuicktimeItem);
        this.formatQuicktimeItem.setSelected(true);
        this.formatQuicktimeItem.setText("QuickTime");
        this.optionsMenu.add(this.formatQuicktimeItem);
        this.optionsMenu.add(this.jSeparator4);
        this.areaGroup.add(this.areaScreenItem);
        this.areaScreenItem.setSelected(true);
        this.areaScreenItem.setText("Entire Screen");
        this.areaScreenItem.setActionCommand("Screen");
        this.optionsMenu.add(this.areaScreenItem);
        this.areaGroup.add(this.areaCustomItem);
        this.areaCustomItem.setText("Custom Area...");
        this.areaCustomItem.setActionCommand("Custom");
        this.areaCustomItem.addActionListener(formListener);
        this.optionsMenu.add(this.areaCustomItem);
        this.optionsMenu.add(this.jSeparator1);
        this.videoMenu.setText("Video");
        this.colorGroup.add(this.colorMillionsItem);
        this.colorMillionsItem.setSelected(true);
        this.colorMillionsItem.setText("Millions of Colors");
        this.colorMillionsItem.setActionCommand("Millions");
        this.videoMenu.add(this.colorMillionsItem);
        this.colorGroup.add(this.colorThousandsItem);
        this.colorThousandsItem.setText("Thousands of Colors");
        this.colorThousandsItem.setActionCommand("Thousands");
        this.videoMenu.add(this.colorThousandsItem);
        this.colorGroup.add(this.colorHundredsItem);
        this.colorHundredsItem.setText("Hundreds of Colors");
        this.colorHundredsItem.setActionCommand("Hundreds");
        this.videoMenu.add(this.colorHundredsItem);
        this.videoMenu.add(this.jSeparator5);
        this.fpsGroup.add(this.fps20Item);
        this.fps20Item.setSelected(true);
        this.fps20Item.setText("20 FPS");
        this.fps20Item.setActionCommand("20");
        this.videoMenu.add(this.fps20Item);
        this.fpsGroup.add(this.fps10Item);
        this.fps10Item.setText("10 FPS");
        this.fps10Item.setActionCommand("10");
        this.videoMenu.add(this.fps10Item);
        this.videoMenu.add(this.jSeparator3);
        this.cursorGroup.add(this.cursorBlackItem);
        this.cursorBlackItem.setSelected(true);
        this.cursorBlackItem.setText("Black Cursor");
        this.cursorBlackItem.setActionCommand("Black");
        this.videoMenu.add(this.cursorBlackItem);
        this.cursorGroup.add(this.cursorWhiteItem);
        this.cursorWhiteItem.setText("White Cursor");
        this.cursorWhiteItem.setActionCommand("White");
        this.videoMenu.add(this.cursorWhiteItem);
        this.cursorGroup.add(this.cursoYellowItem);
        this.cursoYellowItem.setText("Yellow Cursor");
        this.cursoYellowItem.setActionCommand("White");
        this.videoMenu.add(this.cursoYellowItem);
        this.cursorGroup.add(this.cursorNoneItem);
        this.cursorNoneItem.setText("No Cursor");
        this.cursorNoneItem.setActionCommand("None");
        this.videoMenu.add(this.cursorNoneItem);
        this.optionsMenu.add(this.videoMenu);
        this.audioMenu.setText("Audio");
        this.audioMenu.add(this.jSeparator2);
        this.audioRateGroup.add(this.audio44kHzItem);
        this.audio44kHzItem.setSelected(true);
        this.audio44kHzItem.setText("44.100 Hz Audio");
        this.audio44kHzItem.setActionCommand("44100");
        this.audioMenu.add(this.audio44kHzItem);
        this.audioRateGroup.add(this.audio22kHzItem);
        this.audio22kHzItem.setText("22.050 Hz Audio");
        this.audio22kHzItem.setActionCommand("22050");
        this.audioMenu.add(this.audio22kHzItem);
        this.audioMenu.add(this.jSeparator6);
        this.channelsGroup.add(this.monoItem);
        this.monoItem.setSelected(true);
        this.monoItem.setText("Mono");
        this.monoItem.setActionCommand("44100");
        this.audioMenu.add(this.monoItem);
        this.channelsGroup.add(this.stereoItem);
        this.stereoItem.setText("Stereo");
        this.stereoItem.setActionCommand("22050");
        this.audioMenu.add(this.stereoItem);
        this.optionsMenu.add(this.audioMenu);
        this.setDefaultCloseOperation(0);
        this.setTitle("MonteMedia");
        this.setResizable(false);
        this.addWindowListener(formListener);
        this.getContentPane().setLayout(new GridBagLayout());
        this.startStopButton.setText("Start");
        this.startStopButton.setToolTipText("<html><font size=\"9px\">Starts/Stops a screen recording.<br>\nThis window will be minimized before the recording starts.<br>\nTo stop the recording, restore this window, and press this button again.");
        this.startStopButton.addActionListener(formListener);
        this.getContentPane().add((Component)this.startStopButton, new GridBagConstraints());
        this.timeLabel.setFont(new Font("Dialog", 0, 11));
        this.timeLabel.setForeground(new Color(255, 255, 255));
        this.timeLabel.setText("<html>--:--");
        this.timeLabel.setToolTipText("<html><font size=\"9px\">Recording time.<br>\nShows recorded minutes and seconds when the recorder is running.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.getContentPane().add((Component)this.timeLabel, gridBagConstraints);
        this.audioMonitor.setForeground(new Color(255, 255, 255));
        this.audioMonitor.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.audioMonitor, gridBagConstraints);
        this.infoLabel.setFont(new Font("Dialog", 0, 11));
        this.infoLabel.setHorizontalAlignment(11);
        this.infoLabel.setText("<html><font color=\"ffffff\">Into \"Movies\"</font>");
        this.infoLabel.setToolTipText("<html><font size=\"9px\">Storage location of the screen recordings.<br>\nTo view the recorded files, click on the link.<br>\nTo change the storage location, drop a folder on the link.\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.infoLabel, gridBagConstraints);
        this.optionsButton.setText("Options");
        this.optionsButton.addActionListener(formListener);
        this.getContentPane().add((Component)this.optionsButton, new GridBagConstraints());
        this.pack();
    }

    private void updateValues() {
        Preferences prefs = Preferences.userNodeForPackage(Main.class);
        this.format = this.getSelectedIndex(this.formatGroup);
        prefs.putInt("ScreenRecording.format", this.format);
        this.depth = this.getSelectedIndex(this.colorGroup);
        prefs.putInt("ScreenRecording.colorDepth", this.depth);
        this.cursor = this.getSelectedIndex(this.cursorGroup);
        prefs.putInt("ScreenRecording.cursor", this.cursor);
        this.audioRate = this.getSelectedIndex(this.audioRateGroup);
        prefs.putInt("ScreenRecording.audioRate", this.audioRate);
        this.audioSource = this.getSelectedIndex(this.audioSourceGroup);
        prefs.putInt("ScreenRecording.audioSource", this.audioSource);
        this.channels = this.getSelectedIndex(this.channelsGroup);
        prefs.putInt("ScreenRecording.channels", this.channels);
        this.area = this.getSelectedIndex(this.areaGroup);
        prefs.putInt("ScreenRecording.area", this.area);
        this.fps = this.getSelectedIndex(this.fpsGroup);
        prefs.putInt("ScreenRecording.fps", this.fps);
        prefs.putInt("ScreenRecording.customAreaX", this.customAreaRect.x);
        prefs.putInt("ScreenRecording.customAreaY", this.customAreaRect.y);
        prefs.putInt("ScreenRecording.customAreaWidth", this.customAreaRect.width);
        prefs.putInt("ScreenRecording.customAreaHeight", this.customAreaRect.height);
    }

    private void start() throws IOException, AWTException {
        this.updateValues();
        if (this.screenRecorder == null) {
            String crsr;
            int audioRate;
            String videoFormatName;
            String mimeType;
            this.setSettingsEnabled(false);
            float quality = 1.0f;
            int bitDepth = switch (this.depth) {
                default -> 24;
                case 1 -> 16;
                case 2 -> 8;
            };
            String compressorName = switch (this.format) {
                default -> {
                    mimeType = "video/avi";
                    videoFormatName = "tscc";
                    yield "Techsmith Screen Capture";
                }
                case 1 -> {
                    mimeType = "video/quicktime";
                    videoFormatName = "tscc";
                    yield "Techsmith Screen Capture";
                }
            };
            AudioSourceItem asi = (AudioSourceItem)this.getSelectedItem(this.audioSourceGroup).getClientProperty("AudioSourceItem");
            int audioBitsPerSample = switch (this.audioRate) {
                default -> {
                    audioRate = 44100;
                    yield 16;
                }
                case 1 -> {
                    audioRate = 22050;
                    yield 8;
                }
                case 2 -> {
                    audioRate = 0;
                    yield 0;
                }
            };
            int audioChannels = switch (this.channels) {
                default -> 1;
                case 1 -> 2;
            };
            int mouseRate = switch (this.cursor) {
                default -> {
                    crsr = null;
                    yield 0;
                }
                case 0 -> {
                    crsr = "black";
                    yield 30;
                }
                case 1 -> {
                    crsr = "white";
                    yield 30;
                }
                case 2 -> {
                    crsr = "yellow";
                    yield 30;
                }
            };
            GraphicsConfiguration cfg = this.getGraphicsConfiguration();
            Rectangle areaRect = null;
            Dimension outputDimension = null;
            switch (this.area) {
                default: {
                    areaRect = cfg.getBounds();
                    break;
                }
                case 1: {
                    areaRect = this.customAreaRect.getBounds();
                }
            }
            outputDimension = areaRect.getSize();
            this.screenRecorder = new ScreenRecorder(cfg, areaRect, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, mimeType}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, videoFormatName, VideoFormatKeys.CompressorNameKey, compressorName, VideoFormatKeys.WidthKey, outputDimension.width, VideoFormatKeys.HeightKey, outputDimension.height, VideoFormatKeys.DepthKey, bitDepth, FormatKeys.FrameRateKey, Rational.valueOf((double)(switch (this.fps) {
                default -> 20;
                case 1 -> 10;
            })), VideoFormatKeys.QualityKey, Float.valueOf(quality), FormatKeys.KeyFrameIntervalKey, (switch (this.fps) {
                default -> 20;
                case 1 -> 10;
            }) * 60}), crsr == null ? null : new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, crsr, FormatKeys.FrameRateKey, Rational.valueOf((double)mouseRate)}), !asi.isEnabled ? null : new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, Rational.valueOf((double)audioRate), AudioFormatKeys.SampleSizeInBitsKey, audioBitsPerSample, AudioFormatKeys.ChannelsKey, audioChannels}), this.movieFolder);
            this.screenRecorder.setAudioMixer(asi.mixerInfo == null ? null : AudioSystem.getMixer(asi.mixerInfo));
            if (this.timer == null) {
                this.timer = new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Main.this.updateTimeLabel();
                    }
                });
                this.timer.setRepeats(true);
                this.timer.start();
            }
            this.screenRecorder.addChangeListener(this.handler);
            this.screenRecorder.start();
            this.audioMonitor.setScreenRecorder(this.screenRecorder);
            this.audioMonitor.start();
        }
    }

    private void updateTimeLabel() {
        if (this.screenRecorder != null) {
            long t = System.currentTimeMillis() - this.screenRecorder.getStartTime();
            long h = t / 3600000L;
            long m = t / 60000L - h * 60L;
            long s = t / 1000L - (h * 3600L + m * 60L);
            this.timeLabel.setText((String)(h == 0L ? "" : String.valueOf(h < 10L ? "0" + h : Long.valueOf(h)) + ":") + String.valueOf(m < 10L ? "0" + m : Long.valueOf(m)) + ":" + String.valueOf(s < 10L ? "0" + s : Long.valueOf(s)));
        }
    }

    public void setSettingsEnabled(boolean b) {
        for (MenuElement c : this.optionsMenu.getSubElements()) {
            if (!(c instanceof JComponent)) continue;
            ((JComponent)((Object)c)).setEnabled(b);
        }
    }

    private void stop() {
        if (this.screenRecorder != null) {
            this.audioMonitor.setScreenRecorder(null);
            this.audioMonitor.stop();
            final ScreenRecorder r = this.screenRecorder;
            this.startStopButton.setEnabled(false);
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.timeLabel.setText("Stopping...");
            this.screenRecorder = null;
            new BackgroundTask(this){
                final /* synthetic */ Main this$0;
                {
                    this.this$0 = this$0;
                }

                protected void construct() throws Exception {
                    r.stop();
                }

                protected void finished() {
                    this.this$0.setSettingsEnabled(true);
                    this.this$0.startStopButton.setEnabled(true);
                    this.this$0.timeLabel.setText("--:--");
                }
            }.start();
        }
    }

    private void recordingFailed(Throwable msg) {
        if (this.screenRecorder != null) {
            this.screenRecorder = null;
            this.startStopButton.setEnabled(true);
            this.timeLabel.setText("Failed");
            this.setExtendedState(0);
            JOptionPane.showMessageDialog(this, "<html><b>Sorry. Screen Recording failed.</b><br>" + msg.getMessage().replace("\n", "<br>"), "Screen Recorder", 0);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stop();
        this.setVisible(false);
        System.exit(0);
    }

    private void formWindowDeiconified(WindowEvent evt) {
    }

    private void selectAreaPerformed(ActionEvent evt) {
        final JRecordingAreaFrame f = new JRecordingAreaFrame();
        Rectangle r = this.customAreaRect;
        f.setBounds(r);
        f.updateLabel();
        f.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ Main this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.customAreaRect = f.getBounds();
                f.setVisible(false);
                f.dispose();
                this.this$0.setVisible(true);
                f.removeWindowListener(this);
                Preferences prefs = Preferences.userNodeForPackage(Main.class);
                prefs.putInt("ScreenRecorder.customAreaX", this.this$0.customAreaRect.x);
                prefs.putInt("ScreenRecorder.customAreaY", this.this$0.customAreaRect.y);
                prefs.putInt("ScreenRecorder.customAreaWidth", this.this$0.customAreaRect.width);
                prefs.putInt("ScreenRecorder.customAreaHeight", this.this$0.customAreaRect.height);
                ((JComponent)this.this$0.getContentPane()).invalidate();
                ((JComponent)this.this$0.getContentPane()).revalidate();
            }
        });
        this.setVisible(false);
        f.setVisible(true);
    }

    private void optionsPerformed(ActionEvent evt) {
        this.optionsMenu.show(this.optionsButton, 0, this.optionsButton.getHeight());
    }

    private void startStopPerformed(ActionEvent evt) {
        if (this.screenRecorder == null) {
            this.setExtendedState(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Main.this.start();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Main.this.setExtendedState(0);
                        JOptionPane.showMessageDialog(Main.this, "<html><b>Sorry. Screen Recording failed.</b><br>" + t.getMessage(), "Screen Recorder", 0);
                        Main.this.stop();
                    }
                }
            });
        } else {
            this.stop();
        }
    }

    private static void checkRegistry() throws IOException {
        Registry r = Registry.getInstance();
        List writerFormats = r.getWriterFormats();
        block0: for (String mimeType : new String[]{"video/avi", "video/quicktime"}) {
            Format requiredFileFormat = new Format(new Object[]{FormatKeys.MimeTypeKey, mimeType, FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE});
            for (Format availableFileFormat : writerFormats) {
                if (!availableFileFormat.matches(requiredFileFormat)) continue;
                continue block0;
            }
            throw new IOException("No writer found for file format: " + String.valueOf(requiredFileFormat));
        }
        Format requiredVideoFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc"});
        Codec availableVideoCodec = r.getCodec(null, requiredVideoFormat);
        if (availableVideoCodec == null) {
            throw new IOException("No video codec found for format: " + String.valueOf(requiredVideoFormat));
        }
        Format requiredAudioFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, Rational.valueOf((double)44100.0), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ChannelsKey, 1});
        Codec availableAudioCodec = r.getCodec(null, requiredAudioFormat);
        if (availableAudioCodec == null) {
            throw new IOException("No audio codec found for format: " + String.valueOf(requiredAudioFormat));
        }
    }

    private static Vector<AudioSourceItem> getAudioSources() {
        Vector<AudioSourceItem> l = new Vector<AudioSourceItem>();
        l.add(new AudioSourceItem("None", null, false));
        l.add(new AudioSourceItem("Default Input", null, true));
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        DataLine.Info lineInfo = new DataLine.Info(TargetDataLine.class, new AudioFormat(44100.0f, 16, 2, true, true));
        for (Mixer.Info info : mixers) {
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo)) continue;
            l.add(new AudioSourceItem(info.getName(), info));
        }
        return l;
    }

    public static void main(String[] args) {
        try {
            Main.checkRegistry();
        }
        catch (IOException ex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String msg = ex.getMessage();
                    JOptionPane.showMessageDialog(null, "<html><b>Sorry. Could not load required audio/video services.</b><br>" + msg.replace("\n", "<br>"), "Screen Recorder", 0);
                    System.exit(10);
                }
            });
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    ToolTipManager.sharedInstance().setDismissDelay(20000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new Main().setVisible(true);
            }
        });
    }

    private static class AudioSourceItem {
        private String title;
        private Mixer.Info mixerInfo;
        private boolean isEnabled;

        public AudioSourceItem(String title, Mixer.Info mixerInfo) {
            this(title, mixerInfo, true);
        }

        public AudioSourceItem(String title, Mixer.Info mixerInfo, boolean isEnabled) {
            this.title = title;
            this.mixerInfo = mixerInfo;
            this.isEnabled = isEnabled;
        }

        public String toString() {
            return this.title;
        }
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScreenRecorder r = Main.this.screenRecorder;
            if (r != null && r.getState() == State.FAILED) {
                Main.this.recordingFailed(r.getStateMessage());
            }
        }
    }

    private class FormListener
    implements ActionListener,
    WindowListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == Main.this.startStopButton) {
                Main.this.startStopPerformed(evt);
            } else if (evt.getSource() == Main.this.optionsButton) {
                Main.this.optionsPerformed(evt);
            } else if (evt.getSource() == Main.this.areaCustomItem) {
                Main.this.selectAreaPerformed(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == Main.this) {
                Main.this.formWindowClosing(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            if (evt.getSource() == Main.this) {
                Main.this.formWindowDeiconified(evt);
            }
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }
    }
}

