/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.screenrecorder;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import org.monte.media.av.Buffer;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.color.Colors;
import org.monte.media.math.Rational;
import org.monte.media.screenrecorder.ScreenRecorder;

class ScreenGrabber
implements Runnable,
AutoCloseable {
    private final Point prevDrawnMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private volatile long stopTime = Long.MAX_VALUE;
    private boolean prevMousePressed;
    private BufferedImage screenCapture;
    private final ScreenRecorder recorder;
    private final Robot robot;
    private final Rectangle captureArea;
    private final BufferedImage videoImg;
    private final Graphics2D videoGraphics;
    private final Format mouseFormat;
    private final ArrayBlockingQueue<Buffer> mouseCaptures;
    private Rational prevScreenCaptureTime;
    private final BufferedImage cursorImg;
    private final BufferedImage cursorImgPressed;
    private final Point cursorOffset;
    private final int videoTrack;
    private final long startTime;
    private ScheduledFuture<?> future;
    private long sequenceNumber;

    public ScreenGrabber(ScreenRecorder recorder, long startTime) throws AWTException, IOException {
        this.recorder = recorder;
        this.captureArea = recorder.getCaptureArea();
        this.robot = new Robot(recorder.getCaptureDevice());
        this.mouseFormat = recorder.mouseFormat;
        this.mouseCaptures = recorder.getMouseCaptures();
        this.cursorImg = recorder.getCursorImg();
        this.cursorImgPressed = recorder.getCursorImgPressed();
        this.cursorOffset = recorder.getCursorOffset();
        this.videoTrack = recorder.videoTrackId;
        this.prevScreenCaptureTime = new Rational(startTime, 1000L);
        this.startTime = startTime;
        Format screenFormat = recorder.getScreenFormat();
        this.videoImg = this.createVideoImage(screenFormat);
        this.videoGraphics = this.initializeVideoGraphics();
    }

    private BufferedImage createVideoImage(Format screenFormat) throws IOException {
        int depth = (Integer)screenFormat.get(VideoFormatKeys.DepthKey, (Object)24);
        return switch (depth) {
            case 24 -> new BufferedImage(this.captureArea.width, this.captureArea.height, 1);
            case 16 -> new BufferedImage(this.captureArea.width, this.captureArea.height, 9);
            case 8 -> new BufferedImage(this.captureArea.width, this.captureArea.height, 13, Colors.createMacColors());
            default -> throw new IOException("Unsupported color depth: " + depth);
        };
    }

    private Graphics2D initializeVideoGraphics() {
        Graphics2D graphics = this.videoImg.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return graphics;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public void setStopTime(long newValue) {
        this.stopTime = newValue;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    @Override
    public void run() {
        try {
            this.grabScreen();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.recorder.recordingFailed(ex);
        }
    }

    private void grabScreen() throws IOException, InterruptedException {
        BufferedImage previousScreenCapture = this.screenCapture;
        long timeBeforeCapture = System.currentTimeMillis();
        try {
            this.screenCapture = this.robot.createScreenCapture(this.captureArea);
        }
        catch (IllegalMonitorStateException e) {
            System.err.println("Screen capture failed: " + e.getMessage());
            return;
        }
        long timeAfterCapture = System.currentTimeMillis();
        previousScreenCapture = previousScreenCapture == null ? this.screenCapture : previousScreenCapture;
        this.videoGraphics.drawImage((Image)previousScreenCapture, 0, 0, null);
        this.processMouseCaptures(timeBeforeCapture, timeAfterCapture, previousScreenCapture);
        if (timeBeforeCapture > this.getStopTime()) {
            this.future.cancel(false);
        }
    }

    private void processMouseCaptures(long timeBeforeCapture, long timeAfterCapture, BufferedImage previousScreenCapture) throws IOException, InterruptedException {
        Buffer buf = new Buffer();
        buf.format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "image"});
        boolean hasMouseCapture = this.processMouseCapturesWithCursor(timeBeforeCapture, timeAfterCapture, previousScreenCapture, buf);
        if (!hasMouseCapture && this.shouldCaptureFrame(timeAfterCapture)) {
            this.captureFrameWithoutMouseMovement(timeAfterCapture, buf);
        }
    }

    private boolean processMouseCapturesWithCursor(long timeBeforeCapture, long timeAfterCapture, BufferedImage previousScreenCapture, Buffer buf) throws IOException, InterruptedException {
        boolean hasMouseCapture = false;
        if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(FormatKeys.FrameRateKey)).intValue() > 0) {
            while (!this.mouseCaptures.isEmpty() && this.shouldProcessMouseCapture(timeAfterCapture)) {
                Buffer mouseCapture = this.mouseCaptures.poll();
                if (!this.isValidMouseCapture(mouseCapture, timeBeforeCapture)) continue;
                hasMouseCapture = true;
                this.processMouseCapture(Objects.requireNonNull(mouseCapture), previousScreenCapture, buf);
            }
        }
        return hasMouseCapture;
    }

    private boolean shouldProcessMouseCapture(long timeAfterCapture) {
        return Objects.requireNonNull(this.mouseCaptures.peek()).timeStamp.compareTo(new Rational(timeAfterCapture, 1000L)) < 0;
    }

    private boolean isValidMouseCapture(Buffer mouseCapture, long timeBeforeCapture) {
        return Objects.requireNonNull(mouseCapture).timeStamp.compareTo(this.prevScreenCaptureTime) > 0 && mouseCapture.timeStamp.compareTo(new Rational(timeBeforeCapture, 1000L)) < 0 && mouseCapture.timeStamp.compareTo(new Rational(this.getStopTime(), 1000L)) <= 0;
    }

    private void processMouseCapture(Buffer mouseCapture, BufferedImage previousScreenCapture, Buffer buf) throws IOException, InterruptedException {
        Point mcp = (Point)mouseCapture.data;
        this.prevMousePressed = (Boolean)mouseCapture.header;
        this.prevDrawnMouseLocation.setLocation(mcp.x - this.captureArea.x, mcp.y - this.captureArea.y);
        Point p = this.prevDrawnMouseLocation;
        this.drawCursor(p);
        this.writeBuffer(buf, mouseCapture.timeStamp, p);
        this.eraseCursor(p, previousScreenCapture);
    }

    private void drawCursor(Point p) {
        BufferedImage cursorToDraw = this.prevMousePressed ? this.cursorImgPressed : this.cursorImg;
        this.videoGraphics.drawImage((Image)cursorToDraw, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
    }

    private void writeBuffer(Buffer buf, Rational timestamp, Point p) throws IOException, InterruptedException {
        buf.clearFlags();
        buf.data = this.videoImg;
        buf.sampleDuration = timestamp.subtract(this.prevScreenCaptureTime);
        buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
        buf.track = this.videoTrack;
        buf.sequenceNumber = this.sequenceNumber++;
        buf.header = p.x == Integer.MAX_VALUE ? null : p;
        this.recorder.write(buf);
        this.prevScreenCaptureTime = timestamp;
    }

    private void eraseCursor(Point p, BufferedImage previousScreenCapture) {
        this.videoGraphics.drawImage(previousScreenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
    }

    private boolean shouldCaptureFrame(long timeAfterCapture) {
        return this.prevScreenCaptureTime.compareTo(new Rational(this.getStopTime(), 1000L)) < 0;
    }

    private void captureFrameWithoutMouseMovement(long timeAfterCapture, Buffer buf) throws IOException, InterruptedException {
        Point p = this.prevDrawnMouseLocation;
        this.drawCursor(p);
        buf.data = this.videoImg;
        buf.sampleDuration = new Rational(timeAfterCapture, 1000L).subtract(this.prevScreenCaptureTime);
        buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
        buf.track = this.videoTrack;
        buf.sequenceNumber = this.sequenceNumber++;
        buf.header = p.x == Integer.MAX_VALUE ? null : p;
        this.recorder.write(buf);
        this.prevScreenCaptureTime = new Rational(timeAfterCapture, 1000L);
        this.eraseCursor(p, this.screenCapture);
    }

    @Override
    public void close() {
        this.videoGraphics.dispose();
        this.videoImg.flush();
    }
}

