/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.screenrecorder;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.SwingUtilities;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.CodecChain;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKey;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.ScaleImageCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.avi.AVIWriter;
import org.monte.media.beans.AbstractStateModel;
import org.monte.media.color.Colors;
import org.monte.media.image.Images;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeWriter;
import org.monte.media.screenrecorder.AudioGrabber;
import org.monte.media.screenrecorder.MouseGrabber;
import org.monte.media.screenrecorder.ScreenGrabber;
import org.monte.media.screenrecorder.State;

public class ScreenRecorder
extends AbstractStateModel {
    private State state = State.DONE;
    private Throwable stateMessage = null;
    private final Format fileCodecFormat;
    protected Format mouseFormat;
    private final Format screenFormat;
    private final Format audioFormat;
    private final Rectangle captureArea;
    private MovieWriter w;
    protected long recordingStartTime;
    protected volatile long recordingStopTime;
    private long fileStartTime;
    private ArrayBlockingQueue<Buffer> mouseCaptures;
    private ScheduledThreadPoolExecutor screenCaptureTimer;
    protected ScheduledThreadPoolExecutor mouseCaptureTimer;
    private ScheduledThreadPoolExecutor audioCaptureTimer;
    private volatile Thread writerThread;
    private BufferedImage cursorImg;
    private BufferedImage cursorImgPressed;
    private Point cursorOffset;
    private ArrayBlockingQueue<Buffer> writerQueue;
    private Codec frameEncoder;
    private Rational outputTime;
    private Rational ffrDuration;
    private final ArrayList<File> recordedFiles = new ArrayList();
    protected int videoTrackId = 0;
    protected int audioTrackId = 1;
    private final GraphicsDevice captureDevice;
    private AudioGrabber audioGrabber;
    private ScreenGrabber screenGrabber;
    protected MouseGrabber mouseGrabber;
    private ScheduledFuture<?> audioFuture;
    private ScheduledFuture<?> screenFuture;
    protected ScheduledFuture<?> mouseFuture;
    protected File movieFolder;
    private AWTEventListener awtEventListener;
    private long maxRecordingTime = 3600000L;
    private long maxFileSize = Long.MAX_VALUE;
    private Mixer mixer;
    long counter = 0L;

    public ScreenRecorder(GraphicsConfiguration cfg) throws IOException, AWTException {
        this(cfg, null, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "Animation", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, new Rational(15L, 1L)}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, new Rational(30L, 1L)}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.EncodingKey, "twos", FormatKeys.FrameRateKey, new Rational(48000L, 1L), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ChannelsKey, 2, AudioFormatKeys.SampleRateKey, new Rational(48000L, 1L), AudioFormatKeys.SignedKey, true, AudioFormatKeys.ByteOrderKey, ByteOrder.BIG_ENDIAN}));
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Format fileCodecFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this(cfg, null, fileCodecFormat, screenFormat, mouseFormat, audioFormat);
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Rectangle captureArea, Format fileCodecFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this(cfg, captureArea, fileCodecFormat, screenFormat, mouseFormat, audioFormat, null);
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Rectangle captureArea, Format fileCodecFormat, Format screenFormat, Format mouseFormat, Format audioFormat, File movieFolder) throws IOException, AWTException {
        this.fileCodecFormat = fileCodecFormat;
        this.screenFormat = screenFormat;
        this.mouseFormat = mouseFormat != null ? mouseFormat : new Format(new Object[]{FormatKeys.FrameRateKey, new Rational(0L, 0L), FormatKeys.EncodingKey, "black"});
        this.audioFormat = audioFormat;
        this.captureDevice = cfg.getDevice();
        this.captureArea = captureArea != null ? captureArea : cfg.getBounds();
        this.initializeMouseCapture(mouseFormat);
        this.movieFolder = this.initializeMovieFolder(movieFolder);
    }

    private void initializeMouseCapture(Format mouseFormat) throws IOException {
        if (mouseFormat != null && ((Rational)mouseFormat.get(FormatKeys.FrameRateKey)).intValue() > 0) {
            this.mouseCaptures = new ArrayBlockingQueue(((Rational)mouseFormat.get(FormatKeys.FrameRateKey)).intValue() * 2);
            switch ((String)mouseFormat.get(FormatKeys.EncodingKey)) {
                case "black": {
                    this.cursorImg = this.loadCursorImage("Cursor.black.png");
                    this.cursorImgPressed = this.loadCursorImage("Cursor.black.pressed.png");
                    break;
                }
                case "yellow": {
                    this.cursorImg = this.loadCursorImage("Cursor.yellow.png");
                    this.cursorImgPressed = this.loadCursorImage("Cursor.yellow.pressed.png");
                    break;
                }
                default: {
                    this.cursorImg = this.loadCursorImage("Cursor.white.png");
                    this.cursorImgPressed = this.loadCursorImage("Cursor.white.pressed.png");
                }
            }
            this.cursorOffset = new Point(this.cursorImg.getWidth() / -2, this.cursorImg.getHeight() / -2);
        }
    }

    public Format getScreenFormat() {
        return this.screenFormat;
    }

    public Point getCursorOffset() {
        return this.cursorOffset;
    }

    public BufferedImage getCursorImgPressed() {
        return this.cursorImgPressed;
    }

    public BufferedImage getCursorImg() {
        return this.cursorImg;
    }

    public ArrayBlockingQueue<Buffer> getMouseCaptures() {
        return this.mouseCaptures;
    }

    public GraphicsDevice getCaptureDevice() {
        return this.captureDevice;
    }

    public Rectangle getCaptureArea() {
        return this.captureArea;
    }

    private BufferedImage loadCursorImage(String imagePath) throws IOException {
        return Images.toBufferedImage((Image)Images.createImage(ScreenRecorder.class, (String)("images/" + imagePath)));
    }

    private File initializeMovieFolder(File movieFolder) {
        if (movieFolder != null) {
            return movieFolder;
        }
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name").toLowerCase();
        String folderName = osName.startsWith("windows") ? "Videos" : "Movies";
        return new File(userHome + File.separator + folderName);
    }

    protected MovieWriter createMovieWriter() throws IOException {
        Codec encoder;
        File f = this.createMovieFile(this.fileCodecFormat);
        this.recordedFiles.add(f);
        MovieWriter mw = this.w = Registry.getInstance().getWriter(this.fileCodecFormat, f);
        if (this.w == null) {
            throw new IOException("Error no writer found for file format: " + String.valueOf(this.fileCodecFormat) + ".");
        }
        Rational videoRate = Rational.max((Rational)((Rational)this.screenFormat.get(FormatKeys.FrameRateKey)), (Rational)((Rational)this.mouseFormat.get(FormatKeys.FrameRateKey)));
        this.ffrDuration = videoRate.inverse();
        Format videoInputFormat = this.screenFormat.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "image", VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height, FormatKeys.FrameRateKey, videoRate});
        Format videoOutputFormat = this.screenFormat.prepend(new Object[]{FormatKeys.FrameRateKey, videoRate, FormatKeys.MimeTypeKey, this.fileCodecFormat.get(FormatKeys.MimeTypeKey)}).append(new Object[]{VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height});
        this.videoTrackId = this.w.addTrack(videoOutputFormat);
        if (this.audioFormat != null) {
            this.audioTrackId = this.w.addTrack(this.audioFormat);
        }
        if ((encoder = Registry.getInstance().getEncoder(this.w.getFormat(this.videoTrackId))) == null) {
            throw new IOException("No encoder for format " + String.valueOf(this.w.getFormat(this.videoTrackId)));
        }
        this.frameEncoder = encoder;
        this.frameEncoder.setInputFormat(videoInputFormat);
        this.frameEncoder.setOutputFormat(videoOutputFormat);
        if (this.frameEncoder.getOutputFormat() == null) {
            throw new IOException("Unable to encode video frames in this output format:\n" + String.valueOf(videoOutputFormat));
        }
        if (!videoInputFormat.intersectKeys(new FormatKey[]{VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey}).matches(videoOutputFormat.intersectKeys(new FormatKey[]{VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey}))) {
            ScaleImageCodec sic = new ScaleImageCodec();
            sic.setInputFormat(videoInputFormat);
            sic.setOutputFormat(videoOutputFormat.intersectKeys(new FormatKey[]{VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey}).append(videoInputFormat));
            this.frameEncoder = new CodecChain((Codec)sic, this.frameEncoder);
        }
        if ((Integer)this.screenFormat.get(VideoFormatKeys.DepthKey) == 8) {
            if (this.w instanceof AVIWriter) {
                AVIWriter aviw = (AVIWriter)this.w;
                aviw.setPalette(this.videoTrackId, (ColorModel)Colors.createMacColors());
            } else if (this.w instanceof QuickTimeWriter) {
                QuickTimeWriter quickTimeWriter = (QuickTimeWriter)this.w;
            }
        }
        this.fileStartTime = System.currentTimeMillis();
        return mw;
    }

    public List<File> getCreatedMovieFiles() {
        return Collections.unmodifiableList(this.recordedFiles);
    }

    protected File createMovieFile(Format fileFormat) throws IOException {
        if (!this.movieFolder.exists()) {
            this.movieFolder.mkdirs();
        } else if (!this.movieFolder.isDirectory()) {
            throw new IOException("\"" + String.valueOf(this.movieFolder) + "\" is not a directory.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
        return new File(this.movieFolder, "ScreenRecording " + dateFormat.format(new Date()) + "." + Registry.getInstance().getExtension(fileFormat));
    }

    public State getState() {
        return this.state;
    }

    public Throwable getStateMessage() {
        return this.stateMessage;
    }

    private void setState(State newValue, Throwable msg) {
        this.state = newValue;
        this.stateMessage = msg;
        this.fireStateChanged();
    }

    public long getStartTime() {
        return this.recordingStartTime;
    }

    public void start() throws IOException {
        this.stop();
        this.recordedFiles.clear();
        this.createMovieWriter();
        try {
            this.recordingStartTime = System.currentTimeMillis();
            this.recordingStopTime = Long.MAX_VALUE;
            this.outputTime = new Rational(0L, 0L);
            this.startWriter();
            try {
                this.startScreenCapture();
            }
            catch (AWTException e) {
                IOException ioe = new IOException("Start screen capture failed");
                ioe.initCause(e);
                this.stop();
                throw ioe;
            }
            catch (IOException ioe) {
                this.stop();
                throw ioe;
            }
            if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(FormatKeys.FrameRateKey)).intValue() > 0) {
                this.startMouseCapture();
            }
            if (this.audioFormat != null) {
                try {
                    this.startAudioCapture();
                }
                catch (LineUnavailableException e) {
                    IOException ioe = new IOException("Start audio capture failed");
                    ioe.initCause(e);
                    this.stop();
                    throw ioe;
                }
            }
            this.setState(State.RECORDING, null);
        }
        catch (IOException e) {
            this.setState(State.FAILING, e);
            this.stop();
            throw e;
        }
        catch (Throwable t) {
            this.setState(State.FAILING, t);
            this.stop();
            throw new IOException(t);
        }
    }

    private void startScreenCapture() throws AWTException, IOException {
        this.screenCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.screenFormat.get(FormatKeys.FrameRateKey)).doubleValue()));
        this.screenGrabber = new ScreenGrabber(this, this.recordingStartTime);
        this.screenFuture = this.screenCaptureTimer.scheduleAtFixedRate(this.screenGrabber, delay, delay, TimeUnit.MILLISECONDS);
        this.screenGrabber.setFuture(this.screenFuture);
    }

    private void stopScreenCapture() {
        if (this.screenCaptureTimer != null) {
            this.screenGrabber.setStopTime(this.recordingStopTime);
        }
    }

    private void abortScreenCapture() {
        if (this.screenCaptureTimer != null) {
            this.screenGrabber.setStopTime(this.recordingStopTime);
            this.screenCaptureTimer.shutdownNow();
        }
    }

    protected void startMouseCapture() throws IOException {
        this.mouseCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.mouseFormat.get(FormatKeys.FrameRateKey)).doubleValue()));
        this.mouseGrabber = new MouseGrabber(this, this.recordingStartTime, this.mouseCaptureTimer);
        this.mouseFuture = this.mouseCaptureTimer.scheduleAtFixedRate(this.mouseGrabber, delay, delay, TimeUnit.MILLISECONDS);
        final MouseGrabber mouseGrabberF = this.mouseGrabber;
        this.awtEventListener = new AWTEventListener(){
            final /* synthetic */ ScreenRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 501) {
                    mouseGrabberF.setMousePressed(true);
                } else if (event.getID() == 502) {
                    mouseGrabberF.setMousePressed(false);
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 16L);
        this.mouseGrabber.setFuture(this.mouseFuture);
    }

    protected void stopMouseCapture() {
        if (this.mouseCaptureTimer != null) {
            this.mouseGrabber.setStopTime(this.recordingStopTime);
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
            this.awtEventListener = null;
        }
    }

    private void abortMouseCapture() {
        if (this.mouseCaptureTimer != null) {
            this.mouseGrabber.setStopTime(this.recordingStopTime);
            this.mouseCaptureTimer.shutdownNow();
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
            this.awtEventListener = null;
        }
    }

    protected void waitUntilMouseCaptureStopped() throws InterruptedException {
        if (this.mouseCaptureTimer != null) {
            try {
                this.mouseFuture.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException exception) {
                // empty catch block
            }
            this.mouseCaptureTimer.shutdown();
            this.mouseCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.mouseCaptureTimer = null;
            this.mouseGrabber.close();
            this.mouseGrabber = null;
        }
    }

    private void startAudioCapture() throws LineUnavailableException {
        this.audioCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = 500;
        this.audioGrabber = new AudioGrabber(this.mixer, this.audioFormat, this.audioTrackId, this.recordingStartTime, this.writerQueue);
        this.audioFuture = this.audioCaptureTimer.scheduleWithFixedDelay(this.audioGrabber, 0L, 10L, TimeUnit.MILLISECONDS);
        this.audioGrabber.setFuture(this.audioFuture);
    }

    private void stopAudioCapture() {
        if (this.audioCaptureTimer != null) {
            this.audioGrabber.setStopTime(this.recordingStopTime);
        }
    }

    private void abortAudioCapture() {
        if (this.audioCaptureTimer != null) {
            this.audioGrabber.setStopTime(this.recordingStopTime);
            this.audioCaptureTimer.shutdownNow();
        }
    }

    public float getAudioLevelLeft() {
        AudioGrabber ag = this.audioGrabber;
        if (ag != null) {
            return ag.getAudioLevelLeft();
        }
        return -1.0f;
    }

    public float getAudioLevelRight() {
        AudioGrabber ag = this.audioGrabber;
        if (ag != null) {
            return ag.getAudioLevelRight();
        }
        return -1.0f;
    }

    private void startWriter() {
        this.writerQueue = new ArrayBlockingQueue(Math.max(((Rational)this.screenFormat.get(FormatKeys.FrameRateKey)).intValue(), ((Rational)this.mouseFormat.get(FormatKeys.FrameRateKey)).intValue()) + 1);
        this.writerThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (ScreenRecorder.this.writerThread == this || !ScreenRecorder.this.writerQueue.isEmpty()) {
                        try {
                            Buffer buf = ScreenRecorder.this.writerQueue.take();
                            ScreenRecorder.this.doWrite(buf);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    ScreenRecorder.this.recordingFailed(e);
                }
            }
        };
        this.writerThread.start();
    }

    public void recordingFailed(Throwable msg) {
        SwingUtilities.invokeLater(() -> {
            try {
                this.stop();
                this.setState(State.FAILED, msg);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        });
    }

    public void stop() throws IOException {
        if (this.state == State.RECORDING || this.state == State.FAILING) {
            block12: {
                this.recordingStopTime = System.currentTimeMillis();
                this.stopMouseCapture();
                this.stopScreenCapture();
                this.stopAudioCapture();
                try {
                    this.waitUntilMouseCaptureStopped();
                    if (this.screenCaptureTimer != null) {
                        try {
                            this.screenFuture.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        this.screenCaptureTimer.shutdown();
                        this.screenCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                        this.screenCaptureTimer = null;
                        this.screenGrabber.close();
                        this.screenGrabber = null;
                    }
                    if (this.audioCaptureTimer == null) break block12;
                    try {
                        this.audioFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.audioCaptureTimer.shutdown();
                    this.audioCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    this.audioCaptureTimer = null;
                    this.audioGrabber.close();
                    this.audioGrabber = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopWriter();
            this.setState(this.state == State.FAILING ? State.FAILED : State.DONE, this.getStateMessage());
        }
    }

    private void stopWriter() throws IOException {
        Thread pendingWriterThread = this.writerThread;
        this.writerThread = null;
        try {
            if (pendingWriterThread != null) {
                pendingWriterThread.interrupt();
                pendingWriterThread.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (this.w != null) {
            this.w.close();
            this.w = null;
        }
    }

    public void abort() throws IOException {
        if (this.state == State.RECORDING || this.state == State.FAILING) {
            this.setState(State.FAILING, null);
            this.recordingStopTime = this.recordingStartTime;
            this.abortMouseCapture();
            this.abortScreenCapture();
            this.abortAudioCapture();
            this.stopWriter();
            this.setState(this.state == State.FAILING ? State.FAILED : State.DONE, this.getStateMessage());
        }
    }

    protected void write(Buffer buf) throws IOException, InterruptedException {
        MovieWriter writer = this.w;
        if (writer == null) {
            return;
        }
        if (buf.track == this.videoTrackId) {
            if (!((Boolean)writer.getFormat(this.videoTrackId).get(VideoFormatKeys.FixedFrameRateKey, (Object)false)).booleanValue()) {
                Buffer wbuf = new Buffer();
                this.frameEncoder.process(buf, wbuf);
                this.writerQueue.put(wbuf);
            } else {
                Rational inputTime = buf.timeStamp.add(buf.sampleDuration);
                boolean isFirst = true;
                while (this.outputTime.compareTo(inputTime) < 0) {
                    buf.timeStamp = this.outputTime;
                    buf.sampleDuration = this.ffrDuration;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.setFlag(BufferFlag.SAME_DATA);
                    }
                    Buffer wbuf = new Buffer();
                    if (this.frameEncoder.process(buf, wbuf) != 0) {
                        throw new IOException("Codec failed or could not process frame in a single step.");
                    }
                    this.writerQueue.put(wbuf);
                    this.outputTime = this.outputTime.add(this.ffrDuration);
                }
            }
        } else {
            Buffer wbuf = new Buffer();
            wbuf.setMetaTo(buf);
            wbuf.data = ((byte[])buf.data).clone();
            wbuf.length = buf.length;
            wbuf.offset = buf.offset;
            this.writerQueue.put(wbuf);
        }
    }

    private void doWrite(Buffer buf) throws IOException {
        MovieWriter mw = this.w;
        long now = System.currentTimeMillis();
        if (buf.track == this.videoTrackId && buf.isFlag(BufferFlag.KEYFRAME) && (mw.isDataLimitReached() || now - this.fileStartTime > this.maxRecordingTime)) {
            final MovieWriter closingWriter = mw;
            new Thread(this){
                final /* synthetic */ ScreenRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        closingWriter.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }.start();
            mw = this.createMovieWriter();
        }
        mw.write(buf.track, buf);
    }

    public long getMaxRecordingTime() {
        return this.maxRecordingTime;
    }

    public void setMaxRecordingTime(long maxRecordingTime) {
        this.maxRecordingTime = maxRecordingTime;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Mixer getAudioMixer() {
        return this.mixer;
    }

    public void setAudioMixer(Mixer mixer) {
        this.mixer = mixer;
    }
}

