/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.screenrecorder;

import java.awt.GraphicsDevice;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.monte.media.av.Buffer;
import org.monte.media.av.Format;
import org.monte.media.math.Rational;
import org.monte.media.screenrecorder.ScreenRecorder;

class MouseGrabber
implements Runnable,
AutoCloseable {
    private final Point prevCapturedMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final ScheduledThreadPoolExecutor timer;
    private final ScreenRecorder recorder;
    private final GraphicsDevice captureDevice;
    private final Rectangle captureArea;
    private final BlockingQueue<Buffer> mouseCaptures;
    private volatile long stopTime = Long.MAX_VALUE;
    private final long startTime;
    private final Format format;
    private ScheduledFuture<?> future;
    private volatile boolean mousePressed;
    private volatile boolean mouseWasPressed;
    private volatile boolean mousePressedRecorded;
    private final Rectangle cursorImageArea;
    private final Point cursorOffset;

    public MouseGrabber(ScreenRecorder recorder, long startTime, ScheduledThreadPoolExecutor timer) {
        this.timer = timer;
        this.recorder = recorder;
        this.format = recorder.mouseFormat;
        this.startTime = startTime;
        this.captureDevice = recorder.getCaptureDevice();
        this.captureArea = recorder.getCaptureArea();
        this.mouseCaptures = recorder.getMouseCaptures();
        this.cursorImageArea = new Rectangle(0, 0, recorder.getCursorImg().getWidth(), recorder.getCursorImg().getHeight());
        this.cursorOffset = recorder.getCursorOffset();
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public void setMousePressed(boolean newValue) {
        if (newValue) {
            this.mouseWasPressed = true;
        }
        this.mousePressed = newValue;
    }

    @Override
    public void run() {
        try {
            this.grabMouse();
        }
        catch (Throwable ex) {
            this.timer.shutdown();
            this.recorder.recordingFailed(ex);
        }
    }

    public void setStopTime(long newValue) {
        this.stopTime = newValue;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    private void grabMouse() throws InterruptedException {
        long now = System.currentTimeMillis();
        if (now > this.getStopTime()) {
            this.future.cancel(false);
            return;
        }
        PointerInfo info = MouseInfo.getPointerInfo();
        Point currentMouseLocation = this.getCursorPosition(info);
        if (this.hasMouseStateChanged(currentMouseLocation)) {
            this.enqueueMouse(currentMouseLocation, now);
            this.updatePreviousState(currentMouseLocation);
        }
        this.mouseWasPressed = this.mousePressed;
    }

    private Point getCursorPosition(PointerInfo info) {
        Point p = info.getLocation();
        this.cursorImageArea.setLocation(p.x + this.cursorOffset.x, p.y + this.cursorOffset.y);
        if (this.isCursorOutsideCaptureArea(info)) {
            p.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return p;
    }

    private boolean isCursorOutsideCaptureArea(PointerInfo info) {
        return !info.getDevice().equals(this.captureDevice) || !this.captureArea.intersects(this.cursorImageArea);
    }

    private boolean hasMouseStateChanged(Point currentMouseLocation) {
        return !currentMouseLocation.equals(this.prevCapturedMouseLocation) || this.mouseWasPressed != this.mousePressedRecorded;
    }

    private void enqueueMouse(Point currentMouseLocation, long timestamp) throws InterruptedException {
        Buffer buf = new Buffer();
        buf.format = this.format;
        buf.timeStamp = new Rational(timestamp, 1000L);
        buf.data = currentMouseLocation;
        buf.header = this.mouseWasPressed;
        this.mouseCaptures.put(buf);
    }

    private void updatePreviousState(Point currentMouseLocation) {
        this.prevCapturedMouseLocation.setLocation(currentMouseLocation);
        this.mousePressedRecorded = this.mouseWasPressed;
    }

    @Override
    public void close() {
    }
}

