/*
 * @(#)Main.java
 * Copyright © 2023 Werner Randelshofer, Switzerland. MIT License.
 */
package org.monte.media.screenrecorder;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * JAudioMonitor.
 *
 * @author Werner Randelshofer
 */
public class JAudioMonitor extends javax.swing.JPanel {
    private final static long serialVersionUID = 1L;
    private Timer timer;
    private Color semiTransparent = new Color(0x40ffffff, true);

    private class Handler implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            repaint();
        }
    }

    private Handler handler = new Handler();
    private ScreenRecorder recorder;

    /**
     * Creates new form JAudioMonitor
     */
    public JAudioMonitor() {
        initComponents();
        setOpaque(false);
        setPreferredSize(new Dimension(7, 16));
        setMinimumSize(new Dimension(7, 16));
    }

    public ScreenRecorder getScreenRecorder() {
        return recorder;
    }

    public void setScreenRecorder(ScreenRecorder recorder) {
        this.recorder = recorder;
    }

    public void start() {
        if (timer == null) {
            timer = new Timer(250, handler);

            timer.start();
        }
    }

    public void stop() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = getWidth();
        int h = getHeight();
        if (recorder != null) {
            float level = recorder.getAudioLevelLeft();
            if (level != -1) {
                int levelHeight = Math.min(h, (int) (h * 7 * level));
                g.setColor(semiTransparent);
                g.fillRect(0, 0, 3, h - levelHeight);
                g.setColor(Color.WHITE);
                g.fillRect(0, h - levelHeight, 3, levelHeight);
            }
            level = recorder.getAudioLevelRight();
            if (level != -1) {
                int levelHeight = Math.min(h, (int) (h * 7 * level));
                g.setColor(semiTransparent);
                g.fillRect(4, 0, 3, h - levelHeight);
                g.setColor(Color.WHITE);
                g.fillRect(4, h - levelHeight, 3, levelHeight);
            }
        }
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
