/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.swing;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class BackgroundTask
implements Runnable {
    private Throwable error;

    @Override
    public final void run() {
        try {
            this.construct();
        }
        catch (Throwable e) {
            this.setError(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BackgroundTask.this.failed(BackgroundTask.this.getError());
                    BackgroundTask.this.finished();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BackgroundTask.this.done();
                }
                finally {
                    BackgroundTask.this.finished();
                }
            }
        });
    }

    protected abstract void construct() throws Exception;

    protected void done() {
    }

    protected void failed(Throwable error) {
        JOptionPane.showMessageDialog(null, error.getMessage() == null ? error.toString() : error.getMessage(), "Error", 0);
        error.printStackTrace();
    }

    protected void finished() {
    }

    protected synchronized Throwable getError() {
        return this.error;
    }

    private synchronized void setError(Throwable x) {
        this.error = x;
    }

    public void start() {
        new Thread(this).start();
    }
}

