/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.swing.movie;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import org.monte.media.av.Movie;
import org.monte.media.image.Images;
import org.monte.media.math.Rational;
import org.monte.media.swing.border.ImageBevelBorder;
import org.monte.media.swing.movie.JTimelineEditor;

public class JMovieControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LabelMode labelMode = LabelMode.TIME;
    private Handler handler = new Handler();
    private Border backgroundBorder;
    private JLabel timeLabel;
    private JTimelineEditor timelineEditor;

    public JMovieControlPanel() {
        this.initComponents();
        this.putClientProperty("style", "textured");
        this.timelineEditor.putClientProperty("style", "textured");
        this.timeLabel.setOpaque(false);
        this.timeLabel.setMinimumSize(this.timeLabel.getPreferredSize());
        this.timeLabel.setPreferredSize(this.timeLabel.getPreferredSize());
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        this.timelineEditor.setTransferHandler(newHandler);
        this.timeLabel.setTransferHandler(newHandler);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getBackgroundBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
    }

    protected Border getBackgroundBorder() {
        if (this.backgroundBorder == null) {
            this.backgroundBorder = this.readBorders("images/TimelineEditor.background.png", 1, false, new Insets(3, 3, 3, 3))[0];
        }
        return this.backgroundBorder;
    }

    protected Border[] readBorders(String resource, int count, boolean isHorizontal, Insets insets) {
        resource = ((String)resource).substring(0, ((String)resource).length() - 4) + this.getStyleSuffix() + ".png";
        try {
            BufferedImage[] imgs = Images.split((Image)ImageIO.read(JTimelineEditor.class.getResource((String)resource)), (int)count, (boolean)false);
            Border[] borders = new Border[count];
            for (int i = 0; i < count; ++i) {
                borders[i] = new ImageBevelBorder(imgs[i], new Insets(1, 3, 1, 3));
            }
            return borders;
        }
        catch (Throwable ex) {
            throw new InternalError("JMovieControlPanel image not found:" + (String)resource);
        }
    }

    public Movie getMovie() {
        return this.timelineEditor.getMovie();
    }

    protected void updateTimeLabel() {
        Rational time;
        Movie movie = this.getMovie();
        Rational rational = time = movie == null ? new Rational(0L, 1L) : movie.getInsertionPoint();
        if (time == null) {
            time = Rational.ZERO;
        }
        int hours = (int)time.floor(1L).getNumerator() / 3600;
        int minutes = (int)(time.floor(1L).getNumerator() / 60L) % 60;
        int seconds = (int)(time.floor(1L).getNumerator() % 60L);
        int frame = movie == null ? 0 : (int)(movie.timeToSample(0, time) - movie.timeToSample(0, time.floor(1L)));
        switch (this.labelMode.ordinal()) {
            case 0: {
                this.timeLabel.setText(String.valueOf(hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + String.valueOf(minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + String.valueOf(seconds < 10 ? "0" + seconds : Integer.valueOf(seconds)) + "." + String.valueOf(frame < 10 ? "0" + frame : Integer.valueOf(frame)));
                break;
            }
            case 1: {
                this.timeLabel.setText(Long.toString(movie.timeToSample(0, movie.getInsertionPoint())));
            }
        }
    }

    protected String getStyleSuffix() {
        String style = (String)this.getClientProperty("style");
        return style == null ? "" : "." + style;
    }

    private void initComponents() {
        this.timeLabel = new JLabel();
        this.timelineEditor = new JTimelineEditor();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.timeLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.timeLabel.setText("00:00:00.00");
        this.timeLabel.addMouseListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.timeLabel, gridBagConstraints);
        GroupLayout timelineEditorLayout = new GroupLayout(this.timelineEditor);
        this.timelineEditor.setLayout(timelineEditorLayout);
        timelineEditorLayout.setHorizontalGroup(timelineEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 327, Short.MAX_VALUE));
        timelineEditorLayout.setVerticalGroup(timelineEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.timelineEditor, gridBagConstraints);
    }

    private void timeLabelMouseClicked(MouseEvent evt) {
        this.labelMode = this.labelMode == LabelMode.TIME ? LabelMode.FRAME : LabelMode.TIME;
        this.updateTimeLabel();
    }

    public void setMovie(Movie movie) {
        Movie oldValue = this.timelineEditor.getMovie();
        if (oldValue != null) {
            oldValue.removePropertyChangeListener((PropertyChangeListener)this.handler);
        }
        this.timelineEditor.setMovie(movie);
        if (movie != null) {
            movie.addPropertyChangeListener((PropertyChangeListener)this.handler);
        }
        this.updateTimeLabel();
    }

    private static enum LabelMode {
        TIME,
        FRAME;

    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JMovieControlPanel.this.updateTimeLabel();
        }
    }

    private class FormListener
    implements MouseListener {
        FormListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == JMovieControlPanel.this.timeLabel) {
                JMovieControlPanel.this.timeLabelMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }
    }
}

