/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.swing.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DropFileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private boolean shouldRemove;
    private int p0;
    private int p1;
    private int fileSelectionMode;
    private FileFilter fileFilter;
    private ActionListener actionListener;

    public DropFileTransferHandler() {
        this(0);
    }

    public DropFileTransferHandler(int fileSelectionMode) {
        this(fileSelectionMode, null);
    }

    public DropFileTransferHandler(int fileSelectionMode, FileFilter filter) {
        this(fileSelectionMode, filter, null);
    }

    public DropFileTransferHandler(int fileSelectionMode, FileFilter filter, ActionListener l) {
        this.fileFilter = filter;
        if (fileSelectionMode != 2 && fileSelectionMode != 0 && fileSelectionMode != 1) {
            throw new IllegalArgumentException("illegal file selection mode:" + fileSelectionMode);
        }
        this.fileSelectionMode = fileSelectionMode;
        this.setActionListener(l);
    }

    public void setActionListener(ActionListener l) {
        this.actionListener = l;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean imported = false;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            InputContext ic = c.getInputContext();
            if (ic != null) {
                ic.endComposition();
            }
            try {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (!list.isEmpty()) {
                    File file = (File)list.get(0);
                    switch (this.fileSelectionMode) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            if (!file.isDirectory()) break;
                            return false;
                        }
                        case 1: {
                            if (file.isDirectory()) break;
                            return false;
                        }
                    }
                    if (this.fileFilter != null && !this.fileFilter.accept(file)) {
                        return false;
                    }
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, file.getPath()));
                }
                imported = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        return null;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (!comp.isEnabled()) {
            return false;
        }
        for (DataFlavor flavor : transferFlavors) {
            if (!flavor.isFlavorJavaFileListType() && !flavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor getImportFlavor(DataFlavor[] flavors, JComponent c) {
        Object plainFlavor = null;
        DataFlavor refFlavor = null;
        DataFlavor stringFlavor = null;
        for (int i = 0; i < flavors.length; ++i) {
            String mime = flavors[i].getMimeType();
            if (mime.startsWith("text/plain")) {
                return flavors[i];
            }
            if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                refFlavor = flavors[i];
                continue;
            }
            if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
            stringFlavor = flavors[i];
        }
        if (refFlavor != null) {
            return refFlavor;
        }
        if (stringFlavor != null) {
            return stringFlavor;
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 0;
    }

    @Override
    protected void exportDone(JComponent comp, Transferable data, int action) {
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }
}

