/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.audio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.audio.AbstractAudioCodec;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ByteArrayImageOutputStream;

public abstract class AbstractPCMAudioCodec
extends AbstractAudioCodec {
    private static final int UNSIGNED_BASE = 128;

    public AbstractPCMAudioCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED, FormatKeys.MimeTypeKey, "Java", AudioFormatKeys.SignedKey, true}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_UNSIGNED, FormatKeys.MimeTypeKey, "Java", AudioFormatKeys.SignedKey, false})});
        this.name = "PCM Codec";
    }

    protected AbstractPCMAudioCodec(Format[] supportedInputFormats, Format[] supportedOutputFormats) {
        super(supportedInputFormats, supportedOutputFormats);
    }

    protected AbstractPCMAudioCodec(Format[] supportedInputAndOutputFormats) {
        super(supportedInputAndOutputFormats, supportedInputAndOutputFormats);
    }

    @Override
    public int process(Buffer in, Buffer out) {
        byte[] outData;
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        Format inFormat = in.format;
        Format outFormat = this.outputFormat;
        if (inFormat.get(AudioFormatKeys.SampleRateKey) == null || !inFormat.get(AudioFormatKeys.SampleRateKey).equals(outFormat.get(AudioFormatKeys.SampleRateKey))) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        if (inFormat.get(AudioFormatKeys.ChannelsKey) != outFormat.get(AudioFormatKeys.ChannelsKey)) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        String inEnc = inFormat.get(FormatKeys.EncodingKey);
        String outEnc = outFormat.get(FormatKeys.EncodingKey);
        boolean fixSilenceBug = inFormat.get(AudioFormatKeys.SilenceBugKey, false);
        byte[] inData = (byte[])in.data;
        byte[] byArray = outData = out.data instanceof byte[] ? (byte[])out.data : new byte[inData.length];
        if (outData.length < inData.length * outFormat.get(AudioFormatKeys.FrameSizeKey) / inFormat.get(AudioFormatKeys.FrameSizeKey)) {
            outData = new byte[inData.length * outFormat.get(AudioFormatKeys.FrameSizeKey) / inFormat.get(AudioFormatKeys.FrameSizeKey)];
        }
        if (AudioFormatKeys.toAudioFormat(inFormat).matches(AudioFormatKeys.toAudioFormat(outFormat))) {
            System.arraycopy(inData, in.offset, outData, 0, in.length);
        } else {
            ByteOrder inOrder = inFormat.get(AudioFormatKeys.ByteOrderKey);
            boolean inSigned = inFormat.get(AudioFormatKeys.SignedKey);
            ByteArrayImageInputStream inStream = new ByteArrayImageInputStream(inData, in.offset, in.length, inOrder);
            ByteOrder outOrder = outFormat.get(AudioFormatKeys.ByteOrderKey);
            boolean outSigned = outFormat.get(AudioFormatKeys.SignedKey);
            ByteArrayImageOutputStream outStream = new ByteArrayImageOutputStream(outData, outOrder);
            try {
                int inSS = inFormat.get(AudioFormatKeys.SampleSizeInBitsKey);
                int outSS = outFormat.get(AudioFormatKeys.SampleSizeInBitsKey);
                switch (inSS << 16 | outSS) {
                    case 0x100010: {
                        if (inSigned == outSigned) {
                            this.write16To16(inStream, outStream);
                            break;
                        }
                        if (inSigned) {
                            this.write16STo16U(inStream, outStream);
                            break;
                        }
                        this.write16UTo16S(inStream, outStream);
                        break;
                    }
                    case 0x100008: {
                        if (inSigned == outSigned) {
                            throw new UnsupportedOperationException("Unsupported sample size. in:" + String.valueOf(inFormat) + ", out:" + String.valueOf(outFormat));
                        }
                        if (inSigned) {
                            this.write16STo8U(inStream, outStream);
                            break;
                        }
                        throw new UnsupportedOperationException("Unsupported sample size. in:" + String.valueOf(inFormat) + ", out:" + String.valueOf(outFormat));
                    }
                    case 524296: {
                        if (inSigned == outSigned) {
                            this.write8STo8S(inStream, outStream, fixSilenceBug);
                            break;
                        }
                        if (inSigned) {
                            this.write8STo8U(inStream, outStream, fixSilenceBug);
                            break;
                        }
                        if (outSigned) {
                            this.write8UTo8S(inStream, outStream, fixSilenceBug);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported sample size. in:" + String.valueOf(inFormat) + ", out:" + String.valueOf(outFormat));
                    }
                }
            }
            catch (IOException ex) {
                out.flags.add(BufferFlag.DISCARD);
                return 1;
            }
        }
        out.flags.add(BufferFlag.KEYFRAME);
        out.format = outFormat;
        out.data = outData;
        out.offset = 0;
        out.length = in.length;
        return 0;
    }

    protected void write16To16(ImageInputStream in, ImageOutputStream out) throws IOException {
        try {
            while (true) {
                out.writeShort(in.readShort());
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    protected void write16UTo16S(ImageInputStream in, ImageOutputStream out) throws IOException {
        try {
            while (true) {
                out.writeShort((in.readShort() & 0xFFFF) - 32768);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    protected void write16STo16U(ImageInputStream in, ImageOutputStream out) throws IOException {
        try {
            while (true) {
                out.writeShort(in.readShort() + 32768);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    protected void write16STo8U(ImageInputStream in, ImageOutputStream out) throws IOException {
        try {
            while (true) {
                out.writeByte((in.readShort() >> 8) + 128);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    protected void write8To8(ImageInputStream in, ImageOutputStream out) throws IOException {
        try {
            int count;
            byte[] buf = new byte[512];
            while ((count = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, count);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    protected void write8UTo8S(ImageInputStream in, ImageOutputStream out, boolean fixSilenceBug) throws IOException {
        try {
            int count;
            byte[] buf = new byte[512];
            while ((count = in.read(buf, 0, buf.length)) != -1) {
                if (fixSilenceBug) {
                    for (i = 0; i < count; ++i) {
                        if (buf[i] == 0) {
                            buf[i] = -128;
                        }
                        buf[i] = (byte)((buf[i] & 0xFF) - 128);
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        buf[i] = (byte)((buf[i] & 0xFF) - 128);
                    }
                }
                out.write(buf, 0, count);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    protected void write8STo8U(ImageInputStream in, ImageOutputStream out, boolean fixSilenceBug) throws IOException {
        try {
            int count;
            byte[] buf = new byte[512];
            while ((count = in.read(buf, 0, buf.length)) != -1) {
                if (fixSilenceBug) {
                    for (i = 0; i < count; ++i) {
                        buf[i] = (byte)(buf[i] == -128 ? -128 : buf[i] + 128);
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        buf[i] = (byte)(buf[i] + 128);
                    }
                }
                out.write(buf, 0, count);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    protected void write8STo8S(ImageInputStream in, ImageOutputStream out, boolean fixSilenceBug) throws IOException {
        try {
            int count;
            byte[] buf = new byte[512];
            while ((count = in.read(buf, 0, buf.length)) != -1) {
                if (fixSilenceBug) {
                    for (int i = 0; i < count; ++i) {
                        buf[i] = buf[i] == -128 ? (byte)0 : buf[i];
                    }
                }
                out.write(buf, 0, count);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

