/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.video;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.codec.video.AbstractVideoCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;

public class FFRtoVFRConverter
extends AbstractVideoCodec {
    private Rational timeStamp;
    private Rational duration;
    private int[] inputColors;
    private int[] previousColors;
    private Object previousPixels;

    public FFRtoVFRConverter() {
        super(new Format[]{new Format(VideoFormatKeys.DataClassKey, BufferedImage.class)}, new Format[]{new Format(VideoFormatKeys.DataClassKey, BufferedImage.class, VideoFormatKeys.FixedFrameRateKey, false)});
        this.name = "FFR to VFR";
    }

    @Override
    public Format[] getOutputFormats(Format input) {
        Format forceVFR = new Format(VideoFormatKeys.FixedFrameRateKey, false);
        ArrayList<Format> of = new ArrayList<Format>(this.outputFormats.length);
        for (Format f : this.outputFormats) {
            of.add(forceVFR.append(f.append(input)));
        }
        return of.toArray(new Format[of.size()]);
    }

    @Override
    public Format setOutputFormat(Format f) {
        Format forceFFR = new Format(VideoFormatKeys.FixedFrameRateKey, true);
        Format forceVFR = new Format(VideoFormatKeys.FixedFrameRateKey, false);
        for (Format sf : this.getOutputFormats(f)) {
            if (!sf.matches(f) && !forceFFR.append(sf).matches(f) && !forceVFR.append(sf).matches(f)) continue;
            this.outputFormat = forceVFR.append(f);
            return sf;
        }
        this.outputFormat = null;
        return null;
    }

    @Override
    public void reset() {
        this.timeStamp = null;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        Format vf = this.inputFormat;
        if (!in.isFlag(BufferFlag.KEYFRAME)) {
            return 1;
        }
        if (in.isFlag(BufferFlag.END_OF_MEDIA) && in.isFlag(BufferFlag.DISCARD)) {
            out.setFlag(BufferFlag.END_OF_MEDIA, true);
            if (this.duration.isZero()) {
                out.setFlag(BufferFlag.DISCARD, true);
            } else {
                out.setFlag(BufferFlag.END_OF_MEDIA, false);
                out.setFlag(BufferFlag.DISCARD, false);
                IndexColorModel newColorModel = new IndexColorModel(8, 256, this.previousColors, 0, false, -1, 0);
                WritableRaster newRaster = Raster.createInterleavedRaster(0, vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), 1, null);
                byte[] newPixels = ((DataBufferByte)newRaster.getDataBuffer()).getData();
                System.arraycopy(this.previousPixels, 0, newPixels, 0, newPixels.length);
                out.data = new BufferedImage(newColorModel, newRaster, false, null);
                out.sampleDuration = this.duration;
                out.timeStamp = this.timeStamp;
                this.duration = new Rational(0L, 1L);
            }
            return 0;
        }
        if (in.isFlag(BufferFlag.DISCARD)) {
            out.setFlag(BufferFlag.DISCARD, true);
            return 0;
        }
        BufferedImage inputImage = (BufferedImage)in.data;
        byte[] inputPixels = ((DataBufferByte)inputImage.getRaster().getDataBuffer()).getData();
        IndexColorModel inputColorModel = (IndexColorModel)inputImage.getColorModel();
        if (this.inputColors == null) {
            this.inputColors = new int[256];
        }
        inputColorModel.getRGBs(this.inputColors);
        if (this.previousPixels == null) {
            this.previousPixels = inputPixels.clone();
            this.previousColors = (int[])this.inputColors.clone();
            this.duration = in.sampleDuration;
            this.timeStamp = in.timeStamp;
            out.setFlag(BufferFlag.DISCARD, true);
        } else if (Arrays.equals((byte[])this.previousPixels, inputPixels) && Arrays.equals(this.previousColors, this.inputColors)) {
            this.duration = this.duration.add(in.sampleDuration);
            out.setFlag(BufferFlag.DISCARD, true);
        } else {
            IndexColorModel newColorModel = new IndexColorModel(8, 256, this.previousColors, 0, false, -1, 0);
            WritableRaster newRaster = Raster.createInterleavedRaster(0, vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), 1, null);
            byte[] newPixels = ((DataBufferByte)newRaster.getDataBuffer()).getData();
            System.arraycopy(this.previousPixels, 0, newPixels, 0, newPixels.length);
            out.data = new BufferedImage(newColorModel, newRaster, false, null);
            out.sampleDuration = this.duration;
            out.timeStamp = this.timeStamp;
            this.duration = in.sampleDuration;
            this.timeStamp = in.timeStamp;
            System.arraycopy(inputPixels, 0, this.previousPixels, 0, inputPixels.length);
            System.arraycopy(this.inputColors, 0, this.previousColors, 0, this.inputColors.length);
        }
        return 0;
    }
}

