/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.monte.media.io.ByteArray;

public class DataChunkOutputStream
extends FilterOutputStream {
    protected long written;
    private boolean forwardFlushAndClose;
    private byte[] byteBuffer = new byte[8];

    public DataChunkOutputStream(OutputStream out) {
        this(out, true);
    }

    public DataChunkOutputStream(OutputStream out, boolean forwardFlushAndClose) {
        super(out);
        this.forwardFlushAndClose = forwardFlushAndClose;
    }

    public void writeType(String s) throws IOException {
        if (s.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(s.getBytes("ASCII"), 0, 4);
            this.incCount(4);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public void writeInt(int v) throws IOException {
        ByteArray.setIntLE(this.byteBuffer, 0, v);
        this.out.write(this.byteBuffer, 0, 4);
        this.incCount(4);
    }

    public void writeUInt(long v) throws IOException {
        ByteArray.setIntLE(this.byteBuffer, 0, (int)v);
        this.out.write(this.byteBuffer, 0, 4);
        this.incCount(4);
    }

    public void writeShort(int v) throws IOException {
        ByteArray.setShortLE(this.byteBuffer, 0, (short)v);
        this.out.write(this.byteBuffer, 0, 2);
        this.incCount(2);
    }

    public void writeShorts(short[] v, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.out.write(v[i] >>> 0 & 0xFF);
            this.out.write(v[i] >> 8 & 0xFF);
        }
        this.incCount(len * 2);
    }

    public void writeInts24(int[] v, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.out.write(v[i] >>> 0 & 0xFF);
            this.out.write(v[i] >> 8 & 0xFF);
            this.out.write(v[i] >> 16 & 0xFF);
        }
        this.incCount(len * 3);
    }

    public void writeLong(long v) throws IOException {
        ByteArray.setLongLE(this.byteBuffer, 0, v);
        this.out.write(this.byteBuffer, 0, 8);
        this.incCount(8);
    }

    public void writeUShort(int v) throws IOException {
        ByteArray.setShortLE(this.byteBuffer, 0, (short)v);
        this.out.write(this.byteBuffer, 0, 2);
        this.incCount(2);
    }

    protected void incCount(int value) {
        long temp = this.written + (long)value;
        if (temp < 0L) {
            temp = Long.MAX_VALUE;
        }
        this.written = temp;
    }

    public final long size() {
        return this.written;
    }

    public void clearCount() {
        this.written = 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.forwardFlushAndClose) {
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.forwardFlushAndClose) {
            super.flush();
        }
    }
}

