/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi.codec.video;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.video.AbstractVideoCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageOutputStream;

public class RunLengthCodec
extends AbstractVideoCodec {
    private byte[] previousPixels;
    private int frameCounter;

    public RunLengthCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "\u0002\u0000\u0000\u0000", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "\u0001\u0000\u0000\u0000", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 4})});
    }

    @Override
    public Format setOutputFormat(Format f) {
        super.setOutputFormat(f);
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey, VideoFormatKeys.DepthKey));
        }
        return this.outputFormat;
    }

    @Override
    public void reset() {
        this.frameCounter = 0;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.outputFormat == null) {
            return 1;
        }
        if (this.outputFormat.get(FormatKeys.EncodingKey).equals("\u0002\u0000\u0000\u0000") || this.outputFormat.get(FormatKeys.EncodingKey).equals("\u0001\u0000\u0000\u0000")) {
            return this.encode(in, out);
        }
        return this.decode(in, out);
    }

    private int encode(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
            out.header = image.getColorModel();
        } else {
            r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
            scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
            out.header = null;
        }
        int offset = r.x + r.y * scanlineStride;
        Integer keyFrameInterval = this.outputFormat.get(FormatKeys.KeyFrameIntervalKey, this.outputFormat.get(FormatKeys.FrameRateKey).intValue());
        boolean isKeyframe = this.frameCounter == 0 || keyFrameInterval == 0 || this.frameCounter % keyFrameInterval == 0;
        ++this.frameCounter;
        try {
            byte[] pixels = this.getIndexed8(in);
            if (pixels == null) {
                return 1;
            }
            if (isKeyframe) {
                this.writeKey8(tmp, pixels, r.width, r.height, offset, scanlineStride);
                out.setFlag(BufferFlag.KEYFRAME);
            } else {
                this.writeDelta8(tmp, pixels, this.previousPixels, r.width, r.height, offset, scanlineStride);
                out.clearFlag(BufferFlag.KEYFRAME);
            }
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            if (this.previousPixels == null) {
                this.previousPixels = (byte[])pixels.clone();
            } else {
                System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
            }
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    private int decode(Buffer in, Buffer out) {
        return 1;
    }

    public void writeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeKey8(buf, data, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    public void writeKey8(ImageOutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                byte v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    out.write(0);
                    out.write(literalCount);
                    out.write(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            out.write(1);
                            out.write(data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        out.write(0);
                        out.write(literalCount);
                        out.write(data, xy - literalCount, literalCount);
                        if (literalCount % 2 == 1) {
                            out.write(0);
                        }
                        literalCount = 0;
                    }
                }
                out.write(repeatCount);
                out.write(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        out.write(1);
                        out.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    out.write(0);
                    out.write(literalCount);
                    out.write(data, xy - literalCount, literalCount);
                    if (literalCount % 2 == 1) {
                        out.write(0);
                    }
                }
                literalCount = 0;
            }
            out.write(0);
            out.write(0);
        }
        out.write(0);
        out.write(1);
    }

    public void writeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeDelta8(buf, data, prev, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    public void writeDelta8(ImageOutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                if (verticalOffset == 1 && skipCount == 0) {
                    out.write(0);
                    out.write(0);
                    verticalOffset = 0;
                    continue;
                }
                out.write(0);
                out.write(2);
                out.write(Math.min(255, skipCount));
                out.write(Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                byte v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            out.write(1);
                            out.write(data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        out.write(0);
                        out.write(literalRun);
                        out.write(data, xy - literalCount, literalRun);
                        if (literalRun % 2 == 1) {
                            out.write(0);
                        }
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            out.write(0);
                            out.write(2);
                            out.write(Math.min(255, skipCount));
                            out.write(0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        out.write(repeatCount);
                        out.write(v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    out.write(1);
                    out.write(data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                out.write(0);
                out.write(literalRun);
                out.write(data, xy - literalCount, literalRun);
                if (literalRun % 2 == 1) {
                    out.write(0);
                }
                literalCount -= literalRun;
            }
            out.write(0);
            out.write(0);
        }
        out.write(0);
        out.write(1);
    }
}

