/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.monte.media.color.ICCPackedColorModel;
import org.monte.media.util.stream.RangeStream;

public class CMYKImages {
    public static final DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab = new int[256];
    private static final int[] Cb_b_tab = new int[256];
    private static final int[] Cr_g_tab = new int[256];
    private static final int[] Cb_g_tab = new int[256];

    public static BufferedImage createImageFromYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        return CMYKImages.createImageFromCMYK(CMYKImages.convertYCCKtoCMYK(ycckRaster), cmykProfile);
    }

    public static BufferedImage createImageFromInvertedYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        return CMYKImages.createImageFromCMYK(CMYKImages.convertInvertedYCCKToCMYK(ycckRaster), cmykProfile);
    }

    public static BufferedImage createImageFromICCProfile(Raster raster, ICC_Profile profile) {
        ICC_ColorSpace cs = new ICC_ColorSpace(profile);
        WritableRaster r = (WritableRaster)raster;
        ColorModel cm = raster.getSampleModel() instanceof PixelInterleavedSampleModel ? new ComponentColorModel(cs, false, false, 1, raster.getTransferType()) : new ICCPackedColorModel(cs, raster);
        return new BufferedImage(cm, (WritableRaster)raster, cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createImageFromCMYK(Raster cmykRaster, ICC_Profile cmykProfile) {
        if (cmykProfile != null) {
            return CMYKImages.createImageFromICCProfile(cmykRaster, cmykProfile);
        }
        int w = cmykRaster.getWidth();
        int h = cmykRaster.getHeight();
        int[] rgb = new int[w * h];
        int[][] cmyk = new int[4][0];
        IntStream.range(0, 4).forEach(i -> {
            cmyk[i] = cmykRaster.getSamples(0, 0, w, h, i, (int[])null);
        });
        int[] C = cmyk[0];
        int[] M = cmyk[1];
        int[] Y = cmyk[2];
        int[] K = cmyk[3];
        RangeStream.range(0, rgb.length).parallel().forEach((lo, hi) -> {
            for (int i = lo; i < hi; ++i) {
                int k = Math.min(255, K[i]);
                rgb[i] = 255 - Math.min(255, C[i] + k) << 16 | 255 - Math.min(255, M[i] + k) << 8 | 255 - Math.min(255, Y[i] + k);
            }
        });
        Hashtable properties = new Hashtable();
        WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
        DirectColorModel cm = RGB;
        return new BufferedImage(cm, rgbRaster, cm.isAlphaPremultiplied(), properties);
    }

    public static BufferedImage createImageFromInvertedCMYK(Raster rgbwRaster, ICC_Profile cmykProfile) {
        int w = rgbwRaster.getWidth();
        int h = rgbwRaster.getHeight();
        try {
            CompletableFuture<int[]> cfR = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfG = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfB = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfW = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] rgb = new int[w * h];
            int[] R = cfR.get();
            int[] G = cfG.get();
            int[] B = cfB.get();
            int[] W = cfW.get();
            RangeStream.range(0, rgb.length).parallel().forEach((lo, hi) -> {
                for (int i = lo; i < hi; ++i) {
                    rgb[i] = 255 - W[i] << 24 | 255 - R[i] << 16 | 255 - G[i] << 8 | 255 - B[i] << 0;
                }
            });
            WritableRaster packedRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            return CMYKImages.createImageFromCMYK(packedRaster, cmykProfile);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    public static BufferedImage createImageFromRGB(Raster rgbRaster, ICC_Profile rgbProfile) {
        if (rgbProfile != null) {
            return CMYKImages.createImageFromICCProfile(rgbRaster, rgbProfile);
        }
        int w = rgbRaster.getWidth();
        int h = rgbRaster.getHeight();
        try {
            CompletableFuture<int[]> cfR = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfG = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfB = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 2, (int[])null));
            int[] rgb = new int[w * h];
            int[] R = cfR.get();
            int[] G = cfG.get();
            int[] B = cfB.get();
            RangeStream.range(0, rgb.length).parallel().forEach((lo, hi) -> {
                for (int i = lo; i < hi; ++i) {
                    rgb[i] = 0xFF000000 | R[i] << 16 | G[i] << 8 | B[i];
                }
            });
            WritableRaster packedRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            Hashtable properties = new Hashtable();
            return new BufferedImage(cm, packedRaster, cm.isAlphaPremultiplied(), properties);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    public static BufferedImage createImageFromYCC(Raster yccRaster, ICC_Profile yccProfile) {
        if (yccProfile != null) {
            return CMYKImages.createImageFromICCProfile(yccRaster, yccProfile);
        }
        int w = yccRaster.getWidth();
        int h = yccRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 2, (int[])null));
            int[] rgb = new int[w * h];
            int[] Y = cfY.get();
            int[] Cb = cfCb.get();
            int[] Cr = cfCr.get();
            RangeStream.range(0, rgb.length).parallel().forEach((lo, hi) -> {
                for (int i = lo; i < hi; ++i) {
                    int Yi = Y[i];
                    int Cbi = Cb[i];
                    int Cri = Cr[i];
                    int R = (1000 * Yi + 1402 * (Cri - 128)) / 1000;
                    int G = (100000 * Yi - 34414 * (Cbi - 128) - 71414 * (Cri - 128)) / 100000;
                    int B = (1000 * Yi + 1772 * (Cbi - 128)) / 1000;
                    R = Math.min(255, Math.max(0, R));
                    G = Math.min(255, Math.max(0, G));
                    B = Math.min(255, Math.max(0, B));
                    rgb[i] = 0xFF000000 | R << 16 | G << 8 | B;
                }
            });
            Hashtable properties = new Hashtable();
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            return new BufferedImage(cm, rgbRaster, cm.isAlphaPremultiplied(), properties);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int i = 0;
            int x = -128;
            while (i <= 255) {
                CMYKImages.Cr_r_tab[i] = (int)(91881.972 * (double)x + 32768.0) >> 16;
                CMYKImages.Cb_b_tab[i] = (int)(116130.292 * (double)x + 32768.0) >> 16;
                CMYKImages.Cr_g_tab[i] = -46802 * x;
                CMYKImages.Cb_g_tab[i] = -22554 * x + 32768;
                ++i;
                ++x;
            }
        }
    }

    static Raster convertInvertedYCCKToCMYK(Raster ycckRaster) {
        return CMYKImages.convertInvertedYCCKToCMYK_byBytes(ycckRaster);
    }

    private static Raster convertInvertedYCCKToCMYK_byBytes(Raster ycckRaster) {
        CMYKImages.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        if (!(ycckRaster.getDataBuffer() instanceof DataBufferByte)) {
            return CMYKImages.convertInvertedYCCKToCMYK_byPixels(ycckRaster);
        }
        byte[] ycck = ((DataBufferByte)ycckRaster.getDataBuffer()).getData();
        int[] cmyk = new int[w * h];
        RangeStream.range(0, cmyk.length).parallel().forEach((lo, hi) -> {
            for (int i = lo; i < hi; ++i) {
                int j = i * 4;
                int y = 255 - (ycck[j] & 0xFF);
                int cb = 255 - (ycck[j + 1] & 0xFF);
                int cr = 255 - (ycck[j + 2] & 0xFF);
                int k = 255 - (ycck[j + 3] & 0xFF);
                int cmykC = 255 - (y + Cr_r_tab[cr]);
                int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                int cmykY = 255 - (y + Cb_b_tab[cb]);
                cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | k;
            }
        });
        WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return cmykRaster;
    }

    private static Raster convertInvertedYCCKToCMYK_byPixels(Raster ycckRaster) {
        CMYKImages.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycck = ycckRaster.getPixels(0, 0, w, h, (int[])null);
        int[] cmyk = new int[w * h];
        RangeStream.range(0, cmyk.length).parallel().forEach((lo, hi) -> {
            for (int i = lo; i < hi; ++i) {
                int j = i * 4;
                int y = 255 - ycck[j];
                int cb = 255 - ycck[j + 1];
                int cr = 255 - ycck[j + 2];
                int cmykC = 255 - (y + Cr_r_tab[cr]);
                int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                int cmykY = 255 - (y + Cb_b_tab[cb]);
                cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | 255 - ycck[j + 3];
            }
        });
        WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return cmykRaster;
    }

    private static Raster convertInvertedYCCKToCMYK_bySamples(Raster ycckRaster) {
        CMYKImages.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfK = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] cmyk = new int[w * h];
            int[] ycckY = cfY.get();
            int[] ycckCb = cfCb.get();
            int[] ycckCr = cfCr.get();
            int[] ycckK = cfK.get();
            RangeStream.range(0, cmyk.length).parallel().forEach((lo, hi) -> {
                for (int i = lo; i < hi; ++i) {
                    int y = 255 - ycckY[i];
                    int cb = 255 - ycckCb[i];
                    int cr = 255 - ycckCr[i];
                    int cmykC = 255 - (y + Cr_r_tab[cr]);
                    int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                    int cmykY = 255 - (y + Cb_b_tab[cb]);
                    cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | 255 - ycckK[i];
                }
            });
            WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
            return cmykRaster;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new InternalError(ex);
        }
    }

    private static Raster convertYCCKtoCMYK(Raster ycckRaster) {
        CMYKImages.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfK = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] cmyk = new int[w * h];
            int[] ycckY = cfY.get();
            int[] ycckCb = cfCb.get();
            int[] ycckCr = cfCr.get();
            int[] ycckK = cfK.get();
            RangeStream.range(0, cmyk.length).parallel().forEach((lo, hi) -> {
                for (int i = lo; i < hi; ++i) {
                    int y = ycckY[i];
                    int cb = ycckCb[i];
                    int cr = ycckCr[i];
                    int cmykC = 255 - (y + Cr_r_tab[cr]);
                    int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                    int cmykY = 255 - (y + Cb_b_tab[cb]);
                    cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | ycckK[i];
                }
            });
            return Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }
}

