/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.imageio.stream.ImageOutputStream;

public class IOStreams {
    public static void copy(File source, File target) throws IOException {
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static long copy(InputStream source, OutputStream target) throws IOException {
        long n = 0L;
        byte[] b = new byte[8192];
        int count = source.read(b);
        while (count != -1) {
            target.write(b, 0, count);
            n += (long)count;
            count = source.read(b);
        }
        return n;
    }

    public static long copy(InputStream source, ImageOutputStream target) throws IOException {
        long count = 0L;
        byte[] b = new byte[8192];
        int read = source.read(b);
        while (read != -1) {
            target.write(b, 0, read);
            count += (long)read;
            read = source.read(b);
        }
        return count;
    }

    public static long copy(InputStream source, ImageOutputStream target, long n) throws IOException {
        long count = 0L;
        byte[] b = new byte[8192];
        int read = source.read(b);
        while (read != -1 && count < n) {
            target.write(b, 0, read);
            read = source.read(b, 0, (int)Math.min((long)b.length, n - (count += (long)read)));
        }
        return count;
    }
}

