/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Date;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.quicktime.QTFFImageInputStream;
import org.monte.media.quicktime.QuickTimeDeserializer;
import org.monte.media.quicktime.QuickTimeMeta;

public class QuickTimeInputStream {
    protected ImageInputStream in;
    protected QuickTimeMeta meta = null;
    protected long streamOffset = 0L;
    protected long currentTime = 0L;

    public QuickTimeInputStream(File file) throws IOException {
        this.in = new FileImageInputStream(file);
        this.in.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.streamOffset = 0L;
    }

    public QuickTimeInputStream(ImageInputStream in) throws IOException {
        this.in = in;
        this.streamOffset = in.getStreamPosition();
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public int getTrackCount() throws IOException {
        this.ensureRealized();
        return this.meta.getTrackCount();
    }

    public long getMovieDuration() throws IOException {
        this.ensureRealized();
        long duration = 0L;
        long movieTimeScale = this.meta.getTimeScale();
        for (QuickTimeMeta.Track t : this.meta.tracks) {
            duration = Math.max(duration, t.getTrackDuration(movieTimeScale));
        }
        return duration;
    }

    public Date getCreationTime() throws IOException {
        this.ensureRealized();
        return this.meta.getCreationTime();
    }

    public Date getModificationTime() throws IOException {
        this.ensureRealized();
        return this.meta.getModificationTime();
    }

    public double getPreferredRate() throws IOException {
        this.ensureRealized();
        return this.meta.getPreferredRate();
    }

    public double getPreferredVolume() throws IOException {
        this.ensureRealized();
        return this.meta.getPreferredVolume();
    }

    public long getCurrentTime() throws IOException {
        this.ensureRealized();
        return this.currentTime;
    }

    public long getPosterTime() throws IOException {
        this.ensureRealized();
        return this.meta.getPosterTime();
    }

    public long getPreviewDuration() throws IOException {
        this.ensureRealized();
        return this.meta.getPreviewDuration();
    }

    public long getPreviewTime() throws IOException {
        this.ensureRealized();
        return this.meta.getPreviewTime();
    }

    public double[] getMovieTransformationMatrix() throws IOException {
        this.ensureRealized();
        return this.meta.getTransformationMatrix();
    }

    public long getMovieTimeScale() throws IOException {
        this.ensureRealized();
        return this.meta.getTimeScale();
    }

    public long getMediaTimeScale(int track) throws IOException {
        this.ensureRealized();
        return this.meta.tracks.get((int)track).mediaList.get((int)0).mediaTimeScale;
    }

    public long getMediaDuration(int track) throws IOException {
        this.ensureRealized();
        return this.meta.tracks.get((int)track).mediaList.get((int)0).mediaDuration;
    }

    public double[] getTransformationMatrix(int track) throws IOException {
        this.ensureRealized();
        return (double[])this.meta.tracks.get((int)track).matrix.clone();
    }

    protected void ensureRealized() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream is closed.");
        }
        if (this.meta == null) {
            this.meta = new QuickTimeMeta();
            this.readAllMetadata();
        }
    }

    private void readAllMetadata() throws IOException {
        this.in.seek(this.streamOffset);
        QuickTimeDeserializer d = new QuickTimeDeserializer();
        d.parse(new QTFFImageInputStream(this.in), this.meta);
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.meta != null) {
            this.meta = null;
        }
    }
}

