/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieReader;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeInputStream;
import org.monte.media.quicktime.QuickTimeMeta;

public class QuickTimeReader
extends QuickTimeInputStream
implements MovieReader {
    private Buffer[] inputBuffers = null;
    private Codec[] codecs = null;
    public static final Format QUICKTIME = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"});

    public QuickTimeReader(File file) throws IOException {
        super(file);
    }

    public QuickTimeReader(ImageInputStream in) throws IOException {
        super(in);
    }

    @Override
    public long timeToSample(int track, Rational seconds) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational sampleToTime(int track, long sample) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Format getFileFormat() throws IOException {
        return QUICKTIME;
    }

    @Override
    public Format getFormat(int track) throws IOException {
        this.ensureRealized();
        return this.meta.getFormat(track);
    }

    @Override
    public long getChunkCount(int track) throws IOException {
        this.ensureRealized();
        return this.meta.tracks.get((int)track).mediaList.get((int)0).sampleCount;
    }

    @Override
    protected void ensureRealized() throws IOException {
        super.ensureRealized();
        this.inputBuffers = new Buffer[this.meta.getTrackCount()];
        this.codecs = new Codec[this.meta.getTrackCount()];
        for (int i = 0; i < this.inputBuffers.length; ++i) {
            this.inputBuffers[i] = new Buffer();
        }
    }

    public BufferedImage read(int track, BufferedImage img) throws IOException {
        this.ensureRealized();
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        if (this.codecs[track] == null) {
            this.createCodec(track);
        }
        Buffer buf = new Buffer();
        buf.data = img;
        do {
            this.read(track, this.inputBuffers[track]);
            this.codecs[track].process(this.inputBuffers[track], buf);
        } while (buf.isFlag(BufferFlag.DISCARD) && !buf.isFlag(BufferFlag.END_OF_MEDIA));
        if (buf.isFlag(BufferFlag.END_OF_MEDIA)) {
            return null;
        }
        return (BufferedImage)buf.data;
    }

    @Override
    public void read(int track, Buffer buffer) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("read() not supported yet.");
    }

    @Override
    public int nextTrack() throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("nextTrack() not supported yet.");
    }

    @Override
    public void setMovieReadTime(Rational newValue) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("setMovieReadTime() not supported yet.");
    }

    @Override
    public Rational getReadTime(int track) throws IOException {
        throw new UnsupportedOperationException("getReadTime() not supported yet.");
    }

    @Override
    public Rational getDuration() throws IOException {
        return new Rational(this.getMovieDuration(), this.getMovieTimeScale());
    }

    @Override
    public Rational getDuration(int track) throws IOException {
        this.ensureRealized();
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        QuickTimeMeta.Media m = tr.mediaList.get(0);
        Rational trackDuration = new Rational(m.mediaDuration, m.mediaTimeScale);
        return trackDuration;
    }

    @Override
    public int findTrack(int fromTrack, Format format) throws IOException {
        int n = this.getTrackCount();
        for (int i = fromTrack; i < n; ++i) {
            if (!this.getFormat(i).matches(format)) continue;
            return i;
        }
        return -1;
    }

    private void createCodec(int track) throws IOException {
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        Format fmt = this.meta.getFormat(track);
        Codec codec = this.createCodec(fmt);
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (codec == null) {
            throw new IOException("Track " + String.valueOf(tr) + " no codec found for format " + String.valueOf(fmt));
        }
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            if (null == codec.setInputFormat(fmt)) {
                throw new IOException("Track " + String.valueOf(tr) + " codec " + String.valueOf(codec) + " does not support input format " + String.valueOf(fmt) + ". codec=" + String.valueOf(codec));
            }
            Format outFormat = fmt.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class});
            if (null == codec.setOutputFormat(outFormat)) {
                throw new IOException("Track " + String.valueOf(tr) + " codec does not support output format " + String.valueOf(outFormat) + ". codec=" + String.valueOf(codec));
            }
        }
        this.codecs[track] = codec;
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getDecoder(fmt.prepend(FormatKeys.MimeTypeKey, "video/quicktime"));
    }
}

