/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.riff;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.exception.AbortException;
import org.monte.media.exception.ParseException;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.riff.RIFFChunk;
import org.monte.media.riff.RIFFPrimitivesInputStream;
import org.monte.media.riff.RIFFVisitor;

public class RIFFParser {
    private static final boolean DEBUG = false;
    public static final int RIFF_ID = RIFFParser.stringToID("RIFF");
    public static final int LIST_ID = RIFFParser.stringToID("LIST");
    public static final int NULL_ID = RIFFParser.stringToID("    ");
    public static final int NULL_NUL_ID = RIFFParser.stringToID("\u0000\u0000\u0000\u0000");
    public static final int JUNK_ID = RIFFParser.stringToID("JUNK");
    private RIFFVisitor visitor;
    private HashSet<RIFFChunk> dataChunks;
    private HashSet<RIFFChunk> propertyChunks;
    private HashSet<RIFFChunk> collectionChunks;
    private HashSet<Integer> stopChunkTypes;
    private HashSet<RIFFChunk> groupChunks;
    private RIFFPrimitivesInputStream in;
    private ImageInputStream iin;
    private boolean isStopChunks;
    private long streamOffset;
    private boolean readData = true;
    private WeakHashMap<String, String> ids;

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(long offset) {
        this.streamOffset = offset;
    }

    public long parse(InputStream in, RIFFVisitor v) throws ParseException, AbortException, IOException {
        this.in = new RIFFPrimitivesInputStream(in);
        this.visitor = v;
        this.parseFile();
        return this.getScan(this.in);
    }

    public long parse(ImageInputStream in, RIFFVisitor v) throws ParseException, AbortException, IOException {
        return this.parse(new ImageInputStreamAdapter(in), v);
    }

    private void parseFile() throws ParseException, AbortException, IOException {
        int id = this.in.readFourCC();
        if (id == RIFF_ID) {
            this.parseFORM(null);
        } else if (id == JUNK_ID) {
            this.parseLocalChunk(null, id);
        } else {
            if (this.iin != null) {
                throw new ParseException("Invalid RIFF File ID: \"" + RIFFParser.idToString(id) + " 0x" + Integer.toHexString(id) + " near " + this.iin.getStreamPosition() + " 0x" + Long.toHexString(this.iin.getStreamPosition()));
            }
            throw new ParseException("Invalid RIFF File ID: \"" + RIFFParser.idToString(id) + " 0x" + Integer.toHexString(id));
        }
    }

    private long getScan(RIFFPrimitivesInputStream in) {
        return in.getScan() + this.streamOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFORM(HashMap<Integer, RIFFChunk> props) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long offset = this.getScan(this.in);
        int type = this.in.readFourCC();
        if (!RIFFParser.isGroupType(type)) {
            throw new ParseException("Invalid FORM Type: \"" + RIFFParser.idToString(type) + "\"");
        }
        RIFFChunk propGroup = props == null ? null : props.get(type);
        RIFFChunk chunk = new RIFFChunk(type, RIFF_ID, size, offset, propGroup);
        boolean visitorWantsToEnterGroup = false;
        if (this.isGroupChunk(chunk) && (visitorWantsToEnterGroup = this.visitor.enteringGroup(chunk))) {
            this.visitor.enterGroup(chunk);
        }
        try {
            long finish = offset + size;
            while (this.getScan(this.in) < finish) {
                long idscan = this.getScan(this.in);
                int id = this.in.readFourCC();
                if (id == RIFF_ID) {
                    this.parseFORM(props);
                } else if (id == LIST_ID) {
                    this.parseLIST(props);
                } else if (RIFFParser.isLocalChunkID(id)) {
                    this.parseLocalChunk(chunk, id);
                } else {
                    ParseException pex = new ParseException("Invalid Chunk: \"" + id + "\" at offset:" + idscan);
                    chunk.setParserMessage(pex.getMessage());
                    throw pex;
                }
                this.in.align();
            }
        }
        catch (EOFException e) {
            e.printStackTrace();
            chunk.setParserMessage("Unexpected EOF after " + NumberFormat.getInstance().format(this.getScan(this.in) - offset) + " bytes");
        }
        finally {
            if (visitorWantsToEnterGroup) {
                this.visitor.leaveGroup(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLIST(HashMap<Integer, RIFFChunk> props) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.getScan(this.in);
        int type = this.in.readFourCC();
        if (!RIFFParser.isGroupType(type)) {
            throw new ParseException("Invalid LIST Type: \"" + type + "\"");
        }
        RIFFChunk propGroup = props == null ? null : props.get(type);
        RIFFChunk chunk = new RIFFChunk(type, LIST_ID, size, scan, propGroup);
        boolean visitorWantsToEnterGroup = false;
        if (this.isGroupChunk(chunk) && (visitorWantsToEnterGroup = this.visitor.enteringGroup(chunk))) {
            this.visitor.enterGroup(chunk);
        }
        try {
            if (visitorWantsToEnterGroup) {
                long finish = scan + size;
                while (this.getScan(this.in) < finish) {
                    long idscan = this.getScan(this.in);
                    int id = this.in.readFourCC();
                    if (id == LIST_ID) {
                        this.parseLIST(props);
                    } else if (RIFFParser.isLocalChunkID(id)) {
                        this.parseLocalChunk(chunk, id);
                    } else {
                        this.parseGarbage(chunk, id, finish - this.getScan(this.in), this.getScan(this.in));
                        ParseException pex = new ParseException("Invalid Chunk: \"" + id + "\" at offset:" + idscan);
                        chunk.setParserMessage(pex.getMessage());
                    }
                    this.in.align();
                }
            } else {
                this.in.skipFully(size - 4L);
                this.in.align();
            }
        }
        finally {
            if (visitorWantsToEnterGroup) {
                this.visitor.leaveGroup(chunk);
            }
        }
    }

    private void parseLocalChunk(RIFFChunk parent, int id) throws ParseException, AbortException, IOException {
        long scan;
        long size;
        RIFFChunk chunk = new RIFFChunk(parent == null ? 0 : parent.getType(), id, size = this.in.readULONG(), scan = this.getScan(this.in));
        if (this.isDataChunk(chunk)) {
            if (this.readData || this.dataChunks != null && this.dataChunks.contains(chunk)) {
                byte[] data = new byte[(int)size];
                this.in.read(data, 0, (int)size);
                chunk.setData(data);
            } else {
                this.in.skipFully(size);
            }
            this.visitor.visitChunk(parent, chunk);
        } else if (this.isPropertyChunk(chunk)) {
            if (this.readData) {
                byte[] data = new byte[(int)size];
                this.in.read(data, 0, (int)size);
                chunk.setData(data);
            } else {
                this.in.skipFully(size);
            }
            parent.putPropertyChunk(chunk);
        } else if (this.isCollectionChunk(chunk)) {
            if (this.readData) {
                byte[] data = new byte[(int)size];
                this.in.read(data, 0, (int)size);
                chunk.setData(data);
            } else {
                this.in.skipFully(size);
            }
            parent.addCollectionChunk(chunk);
        } else {
            this.in.skipFully((int)size);
            if (this.isStopChunks) {
                this.visitor.visitChunk(parent, chunk);
            }
        }
    }

    private void parseGarbage(RIFFChunk parent, int id, long size, long scan) throws ParseException, AbortException, IOException {
        RIFFChunk chunk = new RIFFChunk(parent.getType(), id, size, scan);
        if (this.isDataChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            this.visitor.visitChunk(parent, chunk);
        } else if (this.isPropertyChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            parent.putPropertyChunk(chunk);
        } else if (this.isCollectionChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            parent.addCollectionChunk(chunk);
        } else {
            this.in.skipFully((int)size);
            if (this.isStopChunk(chunk)) {
                this.visitor.visitChunk(parent, chunk);
            }
        }
    }

    protected boolean isDataChunk(RIFFChunk chunk) {
        if (this.dataChunks == null) {
            return this.collectionChunks == null && this.propertyChunks == null && (this.stopChunkTypes == null || !this.stopChunkTypes.contains(chunk.getType()));
        }
        return this.dataChunks.contains(chunk);
    }

    protected boolean isGroupChunk(RIFFChunk chunk) {
        if (this.groupChunks == null) {
            return true;
        }
        return this.groupChunks.contains(chunk);
    }

    protected boolean isPropertyChunk(RIFFChunk chunk) {
        if (this.propertyChunks == null) {
            return false;
        }
        return this.propertyChunks.contains(chunk);
    }

    protected boolean isCollectionChunk(RIFFChunk chunk) {
        if (this.collectionChunks == null) {
            return false;
        }
        return this.collectionChunks.contains(chunk);
    }

    public void declareDataChunk(int type, int id) {
        RIFFChunk chunk = new RIFFChunk(type, id);
        if (this.dataChunks == null) {
            this.dataChunks = new HashSet();
        }
        this.dataChunks.add(chunk);
    }

    public void declareGroupChunk(int type, int id) {
        RIFFChunk chunk = new RIFFChunk(type, id);
        if (this.groupChunks == null) {
            this.groupChunks = new HashSet();
        }
        this.groupChunks.add(chunk);
    }

    public void declarePropertyChunk(int type, int id) {
        RIFFChunk chunk = new RIFFChunk(type, id);
        if (this.propertyChunks == null) {
            this.propertyChunks = new HashSet();
        }
        this.propertyChunks.add(chunk);
    }

    public void declareCollectionChunk(int type, int id) {
        RIFFChunk chunk = new RIFFChunk(type, id);
        if (this.collectionChunks == null) {
            this.collectionChunks = new HashSet();
        }
        this.collectionChunks.add(chunk);
    }

    public void declareStopChunkType(int type) {
        if (this.stopChunkTypes == null) {
            this.stopChunkTypes = new HashSet();
        }
        this.stopChunkTypes.add(type);
    }

    public void declareStopChunks() {
        this.isStopChunks = true;
    }

    private boolean isStopChunk(RIFFChunk chunk) {
        return this.isStopChunks || this.stopChunkTypes != null && this.stopChunkTypes.contains(chunk.getType());
    }

    public static boolean isGroupID(int id) {
        return id == LIST_ID || id == RIFF_ID;
    }

    public static boolean isGroupType(int id) {
        return RIFFParser.isID(id) && !RIFFParser.isGroupID(id) && id != NULL_ID;
    }

    public static boolean isID(int id) {
        int c0 = id >> 24;
        int c1 = id >> 16 & 0xFF;
        int c2 = id >> 8 & 0xFF;
        int c3 = id & 0xFF;
        return id == NULL_NUL_ID || c0 >= 32 && c0 <= 126 && c1 >= 32 && c1 <= 126 && c2 >= 32 && c2 <= 126 && c3 >= 32 && c3 <= 126;
    }

    public static boolean isLocalChunkID(int id) {
        if (RIFFParser.isGroupID(id)) {
            return false;
        }
        return id != NULL_ID && RIFFParser.isID(id);
    }

    public static String idToString(int anInt) {
        byte[] bytes = new byte[]{(byte)(anInt >>> 24), (byte)(anInt >>> 16), (byte)(anInt >>> 8), (byte)(anInt >>> 0)};
        try {
            return new String(bytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static int stringToID(String aString) {
        byte[] bytes = aString.getBytes();
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] << 0;
    }

    public boolean isReadData() {
        return this.readData;
    }

    public void setReadData(boolean readData) {
        this.readData = readData;
    }
}

