/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.HashSet;
import java.util.LinkedList;
import org.monte.media.tiff.ValueFormatter;

public class SetValueFormatter
implements ValueFormatter {
    private LinkedList<Entry> setDefinition = new LinkedList();

    public SetValueFormatter(Object ... set) {
        int i = 0;
        while (i < set.length) {
            if (i < set.length - 2 && set[i + 1] instanceof Integer && set[i + 2] instanceof Integer) {
                this.setDefinition.add(new Entry((String)set[i], (Integer)set[i + 1], (Integer)set[i + 2]));
                i += 3;
                continue;
            }
            if (set[i + 1] instanceof Integer) {
                this.setDefinition.add(new Entry((String)set[i], (Integer)set[i + 1]));
                i += 2;
                continue;
            }
            if (set[i + 1] instanceof String) {
                this.setDefinition.add(new Entry((String)set[i], (String)set[i + 1]));
                i += 2;
                continue;
            }
            throw new IllegalArgumentException("illegal set:" + String.valueOf(set));
        }
    }

    @Override
    public Object format(Object value) {
        if (value instanceof Number) {
            HashSet<String> setValue = new HashSet<String>();
            int intValue = ((Number)value).intValue();
            for (Entry elem : this.setDefinition) {
                if ((elem.mask & intValue) != elem.bits) continue;
                setValue.add(elem.name);
            }
            return setValue;
        }
        if (value instanceof String) {
            HashSet<String> setValue = new HashSet<String>();
            for (Entry elem : this.setDefinition) {
                if (!value.equals(elem.stringValue)) continue;
                setValue.add(elem.name);
            }
            return setValue;
        }
        return value;
    }

    @Override
    public Object prettyFormat(Object value) {
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            StringBuilder prettyValue = new StringBuilder();
            for (Entry elem : this.setDefinition) {
                if ((elem.mask & intValue) != elem.bits) continue;
                if (prettyValue.length() > 0) {
                    prettyValue.append(',');
                }
                prettyValue.append(elem.name);
            }
            prettyValue.insert(0, " {");
            prettyValue.insert(0, Integer.toHexString(intValue));
            prettyValue.insert(0, "0x");
            prettyValue.append("}");
            return prettyValue.toString();
        }
        return value;
    }

    @Override
    public String descriptionFormat(Object value) {
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            StringBuilder prettyValue = new StringBuilder();
            for (Entry elem : this.setDefinition) {
                if ((elem.mask & intValue) != elem.bits) continue;
                if (prettyValue.length() > 0) {
                    prettyValue.append(',');
                }
                prettyValue.append(elem.name);
            }
            return prettyValue.toString();
        }
        return null;
    }

    private class Entry {
        int bits;
        int mask;
        String name;
        String stringValue;

        public Entry(String name, int bits) {
            this.name = name;
            this.bits = bits;
            this.mask = bits;
        }

        public Entry(String name, int bits, int mask) {
            this.name = name;
            this.bits = bits;
            this.mask = mask;
        }

        public Entry(String name, String stringValue) {
            this.name = name;
            this.stringValue = stringValue;
            this.mask = 0;
            this.bits = 0;
        }
    }
}

