/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.util.stream;

import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.function.IntConsumer;
import org.monte.media.util.stream.BiIntConsumer;

public class RangeStream {
    private final int startInclusive;
    private final int endExclusive;
    int threshold;

    private RangeStream(int startInclusive, int endExclusive) {
        this.startInclusive = startInclusive;
        this.endExclusive = endExclusive;
    }

    public RangeStream parallel() {
        return this.parallel(128);
    }

    public RangeStream parallel(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public RangeStream serial() {
        return this.parallel(0);
    }

    public void forEach(IntConsumer consumer) {
        this.forEach((int lo, int hi) -> {
            for (int i = lo; i < hi; ++i) {
                consumer.accept(i);
            }
        });
    }

    public void forEach(BiIntConsumer consumer) {
        if (this.threshold > 0) {
            this.doParallel(consumer);
        } else {
            this.doSequential(consumer);
        }
    }

    private void doSequential(BiIntConsumer consumer) {
        consumer.accept(this.startInclusive, this.endExclusive);
    }

    private void doParallel(BiIntConsumer consumer) {
        new Applier(consumer, this.threshold, this.startInclusive, this.endExclusive, null).invoke();
    }

    public static RangeStream range(int startInclusive, int endExclusive) {
        return new RangeStream(startInclusive, endExclusive);
    }

    private static class Applier
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        final BiIntConsumer consumer;
        final int thresh;
        final int lo;
        final int hi;
        Applier next;

        Applier(BiIntConsumer consumer, int thresh, int lo, int hi, Applier next) {
            this.consumer = consumer;
            this.thresh = thresh;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
        }

        void atLeaf(int l, int h) {
            this.consumer.accept(l, h);
        }

        @Override
        protected void compute() {
            int l = this.lo;
            int h = this.hi;
            ForkJoinTask right = null;
            while (h - l > this.thresh && Applier.getSurplusQueuedTaskCount() <= 3) {
                int mid = l + h >>> 1;
                right = new Applier(this.consumer, this.thresh, mid, h, (Applier)right);
                right.fork();
                h = mid;
            }
            this.atLeaf(l, h);
            while (right != null) {
                if (right.tryUnfork()) {
                    ((Applier)right).atLeaf(((Applier)right).lo, ((Applier)right).hi);
                } else {
                    right.join();
                }
                right = ((Applier)right).next;
            }
        }
    }
}

