/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.monte.media.av.Codec;
import org.monte.media.av.CodecSpi;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieReader;
import org.monte.media.av.MovieReaderSpi;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.MovieWriterSpi;
import org.monte.media.av.Registry;

public class DefaultRegistry
extends Registry {
    private List<CodecSpi> codecSpis;
    private List<MovieReaderSpi> readerSpis;
    private List<MovieWriterSpi> writerSpis;
    private Map<String, String> mimeTypeToExtensionMap;
    private Map<String, Format> extensionToFormatMap;

    private synchronized List<CodecSpi> getCodecSpis() {
        if (this.codecSpis == null) {
            this.codecSpis = new ArrayList<CodecSpi>();
            for (CodecSpi spi : ServiceLoader.load(CodecSpi.class)) {
                this.codecSpis.add(spi);
            }
        }
        return this.codecSpis;
    }

    private synchronized Map<String, String> getMimeTypeToExtensionMap() {
        if (this.mimeTypeToExtensionMap == null) {
            this.mimeTypeToExtensionMap = new LinkedHashMap<String, String>();
            for (MovieReaderSpi movieReaderSpi : this.getReaderSpis()) {
                this.mimeTypeToExtensionMap.put(movieReaderSpi.getFileFormat().get(FormatKeys.MimeTypeKey), movieReaderSpi.getExtensions().isEmpty() ? "" : movieReaderSpi.getExtensions().get(0));
            }
            Iterator<Object> iterator = this.getWriterSpis().iterator();
            while (iterator.hasNext()) {
                MovieWriterSpi movieWriterSpi;
                this.mimeTypeToExtensionMap.put(movieWriterSpi.getFileFormat().get(FormatKeys.MimeTypeKey), (movieWriterSpi = (MovieWriterSpi)iterator.next()).getExtensions().isEmpty() ? "" : movieWriterSpi.getExtensions().get(0));
            }
        }
        return this.mimeTypeToExtensionMap;
    }

    private synchronized Map<String, Format> getExtensionToFormatMap() {
        if (this.extensionToFormatMap == null) {
            this.extensionToFormatMap = new LinkedHashMap<String, Format>();
            for (MovieReaderSpi movieReaderSpi : this.getReaderSpis()) {
                for (String ext : movieReaderSpi.getExtensions()) {
                    this.extensionToFormatMap.put(ext, movieReaderSpi.getFileFormat());
                }
            }
            for (MovieWriterSpi movieWriterSpi : this.getWriterSpis()) {
                for (String ext : movieWriterSpi.getExtensions()) {
                    this.extensionToFormatMap.put(ext, movieWriterSpi.getFileFormat());
                }
            }
        }
        return this.extensionToFormatMap;
    }

    private synchronized List<MovieReaderSpi> getReaderSpis() {
        if (this.readerSpis == null) {
            this.readerSpis = new ArrayList<MovieReaderSpi>();
            for (MovieReaderSpi spi : ServiceLoader.load(MovieReaderSpi.class)) {
                this.readerSpis.add(spi);
            }
        }
        return this.readerSpis;
    }

    private synchronized List<MovieWriterSpi> getWriterSpis() {
        if (this.writerSpis == null) {
            this.writerSpis = new ArrayList<MovieWriterSpi>();
            for (MovieWriterSpi spi : ServiceLoader.load(MovieWriterSpi.class)) {
                this.writerSpis.add(spi);
            }
        }
        return this.writerSpis;
    }

    @Override
    public List<Codec> getCodecs(Format inputFormat, Format outputFormat) {
        ArrayList<Codec> codecs = new ArrayList<Codec>();
        for (CodecSpi spi : this.getCodecSpis()) {
            Format actual;
            Codec codec = spi.create();
            if (inputFormat != null && (actual = codec.setInputFormat(inputFormat)) == null || outputFormat != null && (actual = codec.setOutputFormat(outputFormat)) == null) continue;
            codecs.add(codec);
        }
        return Collections.unmodifiableList(codecs);
    }

    @Override
    public String getExtension(Format ff) {
        return this.getMimeTypeToExtensionMap().get(ff.get(FormatKeys.MimeTypeKey));
    }

    private String getExtension(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        return p == -1 ? "" : name.substring(p + 1).toLowerCase();
    }

    @Override
    public Format getFileFormat(File file) {
        String extension = this.getExtension(file);
        return this.getExtensionToFormatMap().get(extension);
    }

    @Override
    public List<Format> getReaderFormats() {
        LinkedHashSet<Format> result = new LinkedHashSet<Format>();
        for (MovieReaderSpi spi : this.getReaderSpis()) {
            result.add(spi.getFileFormat());
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }

    @Override
    public MovieReader getReader(Format fileFormat, File file) throws IOException {
        if (fileFormat == null) {
            fileFormat = this.getFileFormat(file);
        }
        for (MovieReaderSpi spi : this.getReaderSpis()) {
            if (!spi.getFileFormat().matches(fileFormat)) continue;
            return spi.create(file);
        }
        return null;
    }

    @Override
    public MovieWriter getWriter(Format fileFormat, File file) throws IOException {
        if (fileFormat == null) {
            fileFormat = this.getFileFormat(file);
        }
        for (MovieWriterSpi spi : this.getWriterSpis()) {
            if (!spi.getFileFormat().matches(fileFormat)) continue;
            return spi.create(file);
        }
        return null;
    }

    @Override
    public List<Format> getWriterFormats() {
        LinkedHashSet<Format> result = new LinkedHashSet<Format>();
        for (MovieWriterSpi spi : this.getWriterSpis()) {
            result.add(spi.getFileFormat());
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }
}

