/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.monte.media.av.Codec;
import org.monte.media.av.DefaultRegistry;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieReader;
import org.monte.media.av.MovieWriter;

public abstract class Registry {
    private static Registry instance;

    public final Codec getCodec(Format inputFormat, Format outputFormat) {
        List<Codec> codecs = this.getCodecs(inputFormat, outputFormat);
        return codecs.isEmpty() ? null : codecs.get(0);
    }

    public abstract List<Codec> getCodecs(Format var1, Format var2);

    public final Codec getDecoder(Format inputFormat) {
        return this.getCodec(inputFormat, null);
    }

    public final List<Codec> getDecoders(Format inputFormat) {
        return this.getCodecs(inputFormat, null);
    }

    public final Codec getEncoder(Format outputFormat) {
        return this.getCodec(null, outputFormat);
    }

    public final List<Codec> getEncoders(Format outputFormat) {
        return this.getCodecs(null, outputFormat);
    }

    public abstract String getExtension(Format var1);

    public abstract Format getFileFormat(File var1);

    public List<Format> getFileFormats() {
        LinkedHashSet<Format> formats = new LinkedHashSet<Format>();
        formats.addAll(this.getReaderFormats());
        formats.addAll(this.getWriterFormats());
        return Collections.unmodifiableList(new ArrayList(formats));
    }

    public abstract MovieReader getReader(Format var1, File var2) throws IOException;

    public MovieReader getReader(File file) throws IOException {
        Format format = this.getFileFormat(file);
        return format == null ? null : this.getReader(format, file);
    }

    public abstract List<Format> getReaderFormats();

    public abstract List<Format> getWriterFormats();

    public MovieWriter getWriter(File file) throws IOException {
        Format format = this.getFileFormat(file);
        return format == null ? null : this.getWriter(format, file);
    }

    public abstract MovieWriter getWriter(Format var1, File var2) throws IOException;

    public ArrayList<Format> suggestOutputFormats(Format inputMediaFormat, Format outputFileFormat) {
        ArrayList<Format> formats = new ArrayList<Format>();
        Format matchFormat = new Format(new Object[]{FormatKeys.MimeTypeKey, outputFileFormat.get(FormatKeys.MimeTypeKey), FormatKeys.MediaTypeKey, inputMediaFormat.get(FormatKeys.MediaTypeKey)});
        List<Codec> codecs = this.getEncoders(matchFormat);
        int matchingCount = 0;
        for (Codec c : codecs) {
            for (Format mf : c.getOutputFormats(null)) {
                if (!mf.matches(matchFormat)) continue;
                if (inputMediaFormat.matchesWithout(mf, FormatKeys.MimeTypeKey)) {
                    formats.add(0, mf.append(inputMediaFormat));
                    ++matchingCount;
                    continue;
                }
                if (inputMediaFormat.matchesWithout(mf, FormatKeys.MimeTypeKey, FormatKeys.EncodingKey)) {
                    formats.add(matchingCount, mf.append(inputMediaFormat));
                    continue;
                }
                formats.add(mf.append(inputMediaFormat));
            }
        }
        block2: for (int i = formats.size() - 1; i >= 0; --i) {
            Format fi = formats.get(i);
            for (int j = i - 1; j >= 0; --j) {
                Format fj = formats.get(j);
                if (!fi.matches(fj)) continue;
                formats.remove(i);
                continue block2;
            }
        }
        return formats;
    }

    public static Registry getInstance() {
        if (instance == null) {
            instance = new DefaultRegistry();
        }
        return instance;
    }
}

