/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.time;

import org.monte.media.av.AbstractCodec;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.math.Rational;

public class TrimTimeCodec
extends AbstractCodec {
    private Rational startTime;
    private Rational endTime;

    public TrimTimeCodec() {
        super(new Format[]{new Format(new Object[0])}, new Format[]{new Format(new Object[0])});
        this.name = "Trim Time";
    }

    public void setStartTime(Rational newValue) {
        this.startTime = newValue;
    }

    public Rational getStartTime() {
        return this.startTime;
    }

    public Rational getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Rational newValue) {
        this.endTime = newValue;
    }

    @Override
    public Format setInputFormat(Format f) {
        Format fNew;
        this.outputFormat = fNew = super.setInputFormat(f);
        return fNew;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        int sampleSize;
        int removeCount;
        out.setMetaTo(in);
        Rational bufStartTS = out.timeStamp;
        Rational bufEndTS = out.timeStamp.add(out.sampleDuration.multiply(out.sampleCount));
        if (!out.isFlag(BufferFlag.DISCARD) && this.startTime != null) {
            if (bufEndTS.compareTo(this.startTime) <= 0) {
                out.setFlag(BufferFlag.DISCARD);
            } else if (bufStartTS.compareTo(this.startTime) < 0 && out.data instanceof byte[]) {
                removeCount = this.startTime.subtract(bufStartTS).divide(out.sampleDuration).intValue();
                removeCount = Math.max(0, Math.min(removeCount, out.sampleCount - 1));
                sampleSize = (out.length - out.offset) / out.sampleCount;
                out.offset += removeCount * sampleSize;
                out.length -= removeCount * sampleSize;
                out.timeStamp = out.timeStamp.add(out.sampleDuration.multiply(removeCount));
                out.sampleCount -= removeCount;
            }
        }
        if (!out.isFlag(BufferFlag.DISCARD) && this.endTime != null) {
            if (bufStartTS.compareTo(this.endTime) >= 0) {
                out.setFlag(BufferFlag.DISCARD);
            } else if (bufEndTS.compareTo(this.endTime) > 0) {
                removeCount = bufEndTS.subtract(this.endTime).divide(out.sampleDuration).intValue();
                removeCount = Math.max(0, Math.min(removeCount, out.sampleCount - 1));
                sampleSize = (out.length - out.offset) / out.sampleCount;
                out.length -= removeCount * sampleSize;
                out.sampleCount -= removeCount;
            }
        }
        int flags = 0;
        if (!out.isFlag(BufferFlag.DISCARD)) {
            flags = out.setDataTo(in);
        }
        return flags;
    }
}

