/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.video;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.color.BitDepthConverters;

public class AbstractVideoCodecCore {
    private byte[] byteBuf = new byte[4];

    protected static void writeInt24LE(ByteBuffer out, int v) throws IOException {
        out.put((byte)v);
        out.put((byte)(v >>> 8));
        out.put((byte)(v >>> 16));
    }

    protected static void writeInts24LE(ByteBuffer out, int[] i, int off, int len) throws IOException {
        int n = off + len;
        for (int j = off; j < n; ++j) {
            int v = i[j];
            out.put((byte)v);
            out.put((byte)(v >>> 8));
            out.put((byte)(v >>> 16));
        }
    }

    protected void readInts24LE(ImageInputStream in, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!, off=" + off + ", len=" + len);
        }
        byte[] b = this.byteBuf;
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v;
            in.readFully(b, 0, 3);
            i[j] = v = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16;
        }
    }

    protected int readInt24LE(ImageInputStream in) throws IOException {
        in.readFully(this.byteBuf, 0, 3);
        return (this.byteBuf[2] & 0xFF) << 16 | (this.byteBuf[1] & 0xFF) << 8 | (this.byteBuf[0] & 0xFF) << 0;
    }

    protected static void writeInts16LE(ByteBuffer out, short[] i, int off, int len) throws IOException {
        int n = off + len;
        for (int j = off; j < n; ++j) {
            short v = i[j];
            out.put((byte)v);
            out.put((byte)(v >>> 8));
        }
    }

    protected static void readInts24LE(ByteBuffer in, int[] i, int off, int len) throws IOException {
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v;
            byte b0 = in.get();
            byte b1 = in.get();
            byte b2 = in.get();
            i[j] = v = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
        }
    }

    protected static int readInt24LE(ByteBuffer in) throws IOException {
        byte b0 = in.get();
        byte b1 = in.get();
        byte b2 = in.get();
        return (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    protected static void readRGBs565to24(ByteBuffer in, int[] i, int off, int len) throws IOException {
        int end = off + len;
        for (int j = off; j < end; ++j) {
            short v = in.getShort();
            i[j] = (v & 0xF800) << 8 | (v & 0x3800) << 5 | (v & 0x7E0) << 5 | (v & 0x60) << 3 | (v & 0x1F) << 3 | v & 7;
        }
    }

    protected int readRGB565to24(ByteBuffer in) throws IOException {
        short v = in.getShort();
        return (v & 0xF800) << 8 | (v & 0x3800) << 5 | (v & 0x7E0) << 5 | (v & 0x60) << 3 | (v & 0x1F) << 3 | v & 7;
    }

    protected static void readRGBs555to24(ImageInputStream in, int[] i, int off, int len) throws IOException {
        int end = off + len;
        for (int j = off; j < end; ++j) {
            int v = in.readUnsignedShort();
            i[j] = (v & 0x7C00) << 9 | (v & 0x7000) << 4 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x1F) << 3 | (v & 0x1C) >> 2;
        }
    }

    protected static void readRGBs555to24(ByteBuffer in, int[] i, int off, int len) throws IOException {
        int end = off + len;
        for (int j = off; j < end; ++j) {
            short v = in.getShort();
            i[j] = (v & 0x7C00) << 9 | (v & 0x7000) << 4 | (v & 0x3E0) << 6 | (v & 0x380) << 1 | (v & 0x1F) << 3 | (v & 0x1C) >> 2;
        }
    }

    protected int readRGB555to24(ImageInputStream in) throws IOException {
        int v = in.readUnsignedShort();
        return BitDepthConverters.rgb15to24(v);
    }

    protected static int readRGB555to24(ByteBuffer in) throws IOException {
        short v = in.getShort();
        return BitDepthConverters.rgb15to24(v);
    }
}

