/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.avi.AVIOutputStream;
import org.monte.media.avi.AbstractAVIStream;
import org.monte.media.io.ByteArrayImageOutputStream;
import org.monte.media.math.Rational;
import org.monte.media.riff.RIFFParser;

public class AVIWriter
implements MovieWriter {
    public static final Format AVI = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AudioFormatKeys.MimeTypeKey, "video/avi"});
    public static final Format VIDEO_RAW = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0000", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_JPEG = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "MJPG", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_PNG = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "png ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_RLE = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "\u0002\u0000\u0000\u0000", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_SCREEN_CAPTURE = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/avi", AudioFormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "NONE"});
    private final AVIOutputStream out;

    public AVIWriter(File file) throws IOException {
        this.out = new AVIOutputStream(file);
    }

    public AVIWriter(ImageOutputStream out) throws IOException {
        this.out = new AVIOutputStream(out);
    }

    @Override
    public Format getFileFormat() throws IOException {
        return AVI;
    }

    @Override
    public Format getFormat(int track) {
        return ((AbstractAVIStream.Track)this.out.tracks.get((int)track)).format;
    }

    @Override
    public Rational getDuration(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.out.tracks.get(track);
        long duration = this.out.getMediaDuration(track);
        return new Rational(duration * tr.scale, tr.rate);
    }

    @Override
    public int addTrack(Format format) throws IOException {
        switch (format.get(AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO)) {
            case VIDEO: {
                return this.addVideoTrack(format);
            }
            case AUDIO: {
                return this.addAudioTrack(format);
            }
        }
        throw new IllegalArgumentException("VIDEO or AUDIO format expected: " + String.valueOf(format));
    }

    private int addVideoTrack(Format vf) throws IOException {
        if (!vf.containsKey(AudioFormatKeys.EncodingKey)) {
            throw new IllegalArgumentException("EncodingKey missing in " + String.valueOf(vf));
        }
        if (!vf.containsKey(AudioFormatKeys.FrameRateKey)) {
            throw new IllegalArgumentException("FrameRateKey missing in " + String.valueOf(vf));
        }
        if (!vf.containsKey(VideoFormatKeys.WidthKey)) {
            throw new IllegalArgumentException("WidthKey missing in " + String.valueOf(vf));
        }
        if (!vf.containsKey(VideoFormatKeys.HeightKey)) {
            throw new IllegalArgumentException("HeightKey missing in " + String.valueOf(vf));
        }
        if (!vf.containsKey(VideoFormatKeys.DepthKey)) {
            throw new IllegalArgumentException("DepthKey missing in " + String.valueOf(vf));
        }
        int tr = this.out.addVideoTrack((String)vf.get(AudioFormatKeys.EncodingKey), ((Rational)vf.get(AudioFormatKeys.FrameRateKey)).getDenominator(), ((Rational)vf.get(AudioFormatKeys.FrameRateKey)).getNumerator(), vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), vf.get(VideoFormatKeys.DepthKey), vf.get(AudioFormatKeys.KeyFrameIntervalKey, ((Rational)vf.get(AudioFormatKeys.FrameRateKey)).floor(1L).intValue()));
        this.out.setCompressionQuality(tr, vf.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue());
        return tr;
    }

    private int addAudioTrack(Format format) throws IOException {
        int waveFormatTag = 1;
        long timeScale = 1L;
        long sampleRate = format.get(AudioFormatKeys.SampleRateKey, new Rational(41000L, 1L)).longValue();
        int numberOfChannels = format.get(AudioFormatKeys.ChannelsKey, 1);
        int sampleSizeInBits = format.get(AudioFormatKeys.SampleSizeInBitsKey, 16);
        boolean isCompressed = false;
        int frameDuration = 1;
        int frameSize = format.get(AudioFormatKeys.FrameSizeKey, (sampleSizeInBits + 7) / 8 * numberOfChannels);
        String enc = (String)format.get(AudioFormatKeys.EncodingKey);
        waveFormatTag = enc == null ? 1 : (enc.equals(AudioFormatKeys.ENCODING_ALAW) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_PCM_SIGNED) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_PCM_UNSIGNED) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_ULAW) ? 1 : (enc.equals("MP3") ? 1 : RIFFParser.stringToID((String)format.get(AudioFormatKeys.EncodingKey)) & 0xFFFF)))));
        return this.out.addAudioTrack(waveFormatTag, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize);
    }

    public Codec getCodec(int track) {
        return ((AbstractAVIStream.Track)this.out.tracks.get((int)track)).codec;
    }

    public void setCodec(int track, Codec codec) {
        ((AbstractAVIStream.Track)this.out.tracks.get((int)track)).codec = codec;
    }

    @Override
    public int getTrackCount() {
        return this.out.tracks.size();
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        Format fmt;
        this.out.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.out.tracks.get(track);
        if (vt.codec == null) {
            this.createCodec(track);
            if (vt.codec == null) {
                throw new IOException("No codec for this format: " + String.valueOf(vt.format));
            }
        }
        if ((fmt = vt.format).get(VideoFormatKeys.WidthKey).intValue() != image.getWidth() || fmt.get(VideoFormatKeys.HeightKey).intValue() != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of image[" + vt.samples.size() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video format of track: " + String.valueOf(fmt));
        }
        boolean isKeyframe = vt.syncInterval == 0 ? false : vt.samples.size() % vt.syncInterval == 0;
        Buffer inputBuffer = new Buffer();
        inputBuffer.flags = isKeyframe ? EnumSet.of(BufferFlag.KEYFRAME) : EnumSet.noneOf(BufferFlag.class);
        inputBuffer.data = image;
        inputBuffer.header = image.getColorModel();
        inputBuffer.format = new Format(AudioFormatKeys.EncodingKey, "image");
        inputBuffer.sampleDuration = new Rational(vt.scale, vt.rate);
        this.write(track, inputBuffer);
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        Buffer outBuf;
        this.out.ensureStarted();
        if (buf.flags.contains((Object)BufferFlag.DISCARD)) {
            return;
        }
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.out.tracks.get(track);
        boolean isKeyframe = buf.flags.contains((Object)BufferFlag.KEYFRAME);
        if (buf.data instanceof BufferedImage && tr.syncInterval != 0) {
            isKeyframe = buf.flags.contains((Object)BufferFlag.KEYFRAME) | tr.samples.size() % tr.syncInterval == 0;
        }
        boolean paletteChange = buf.header instanceof IndexColorModel && tr instanceof AbstractAVIStream.VideoTrack ? this.writePalette(track, (IndexColorModel)buf.header, isKeyframe) : false;
        if (buf.format == null) {
            throw new IllegalArgumentException("Buffer.format must not be null");
        }
        if (buf.format.matchesWithout(tr.format, AudioFormatKeys.FrameRateKey) && buf.data instanceof byte[]) {
            this.out.writeSamples(track, buf.sampleCount, (byte[])buf.data, buf.offset, buf.length, buf.isFlag(BufferFlag.KEYFRAME) && !paletteChange);
            return;
        }
        if (tr.codec == null) {
            this.createCodec(track);
            if (tr.codec == null) {
                throw new UnsupportedOperationException("No codec for this format " + String.valueOf(tr.format));
            }
        }
        if (tr.outputBuffer == null) {
            tr.outputBuffer = new Buffer();
        }
        if (tr.codec.process(buf, outBuf = tr.outputBuffer) != 0) {
            throw new IOException("Codec failed or could not encode the sample in a single step. codec:" + String.valueOf(tr.codec));
        }
        if (outBuf.isFlag(BufferFlag.DISCARD)) {
            return;
        }
        this.out.writeSamples(track, outBuf.sampleCount, (byte[])outBuf.data, outBuf.offset, outBuf.length, isKeyframe && !paletteChange);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public boolean isDataLimitReached() {
        return this.out.isDataLimitReached();
    }

    private boolean writePalette(int track, BufferedImage image, boolean isKeyframe) throws IOException {
        if (image.getColorModel() instanceof IndexColorModel) {
            return this.writePalette(track, (IndexColorModel)image.getColorModel(), isKeyframe);
        }
        return false;
    }

    private boolean writePalette(int track, IndexColorModel imgPalette, boolean isKeyframe) throws IOException {
        this.out.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.out.tracks.get(track);
        int imgDepth = vt.bitCount;
        ByteArrayImageOutputStream tmp = null;
        boolean paletteChange = false;
        if (vt.samples.isEmpty()) {
            vt.palette = imgPalette;
            vt.previousPalette = imgPalette;
        }
        switch (imgDepth) {
            case 4: {
                int[] imgRGBs = new int[16];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[16];
                vt.previousPalette.getRGBs(previousRGBs);
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                for (int i = first; i <= last; ++i) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                }
                break;
            }
            case 8: {
                int[] imgRGBs = new int[256];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[256];
                if (vt.previousPalette != null) {
                    vt.previousPalette.getRGBs(previousRGBs);
                }
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                for (int i = first; i <= last; ++i) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                }
                break;
            }
        }
        if (tmp != null) {
            tmp.close();
            this.out.writePalette(track, tmp.toByteArray(), 0, (int)tmp.length(), isKeyframe);
        }
        if (paletteChange) {
            vt.previousPalette = imgPalette;
        }
        return paletteChange;
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getEncoder(fmt.prepend(AudioFormatKeys.MimeTypeKey, "video/avi"));
    }

    private void createCodec(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.out.tracks.get(track);
        Format fmt = tr.format;
        tr.codec = this.createCodec(fmt);
        if (tr.codec != null) {
            if (fmt.get(AudioFormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
                tr.codec.setInputFormat(fmt.prepend(AudioFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class));
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.out.getCompressionQuality(track)), AudioFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Track " + String.valueOf(tr) + " codec does not support format " + String.valueOf(fmt) + ". codec=" + String.valueOf(tr.codec));
                }
            } else {
                tr.codec.setInputFormat(null);
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.out.getCompressionQuality(track)), AudioFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Track " + String.valueOf(tr) + " codec " + String.valueOf(tr.codec) + " does not support format. " + String.valueOf(fmt));
                }
            }
        }
    }

    public boolean isVFRSupported() {
        return false;
    }

    @Override
    public boolean isEmpty(int track) {
        return ((AbstractAVIStream.Track)this.out.tracks.get((int)track)).samples.isEmpty();
    }

    public void setPalette(int track, ColorModel palette) {
        this.out.setPalette(track, palette);
    }
}

