/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.color;

public class BitDepthConverters {
    private BitDepthConverters() {
    }

    public static int rgb12to24(int v) {
        int e = (v & 0xF00) << 12 | (v & 0xF0) << 8 | (v & 0xF) << 4;
        return e | e >>> 4;
    }

    public static int rgb6to24(int v) {
        int e = (v & 0x30) << 18 | (v & 0xC) << 12 | (v & 3) << 6;
        return e | e >>> 2 | e >>> 4 | e >>> 6;
    }

    public static int rgb15to24(int v) {
        int e = (v & 0x7C00) << 9 | (v & 0x3E0) << 6 | (v & 0x1F) << 3;
        return e | (e & 0xE0E0E0) >>> 5;
    }

    public static int rgb16to24(int v) {
        return (v & 0xF800) << 8 | (v & 0xE000) << 3 | (v & 0x7E0) << 5 | (v & 0x600) >>> 1 | (v & 0x1F) << 3 | (v & 0x1C) >>> 2;
    }

    public static int rgb24to12(int v) {
        return (v & 0xF00000) >>> 12 | (v & 0xF000) >>> 8 | (v & 0xF0) >>> 4;
    }

    public static int rgb24to6(int v) {
        return (v & 0xC00000) >>> 18 | (v & 0xC000) >>> 12 | (v & 0xC0) >>> 6;
    }

    public static int rgb24to15(int v) {
        return (v & 0xF80000) >>> 9 | (v & 0xF800) >>> 6 | (v & 0xF8) >>> 3;
    }

    public static int rgb24to16(int v) {
        return (v & 0xF80000) >>> 8 | (v & 0xFC00) >>> 5 | (v & 0xF8) >>> 3;
    }
}

