/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.imgseq;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.codec.video.JPEGCodec;
import org.monte.media.av.codec.video.PNGCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.io.IOStreams;
import org.monte.media.math.Rational;

public class ImageSequenceWriter
implements MovieWriter {
    private final Format fileFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE});
    private final ArrayList<VideoTrack> tracks = new ArrayList();

    @Override
    public int addTrack(Format format) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Format getFileFormat() throws IOException {
        return this.fileFormat;
    }

    @Override
    public int getTrackCount() {
        return 1;
    }

    @Override
    public Format getFormat(int track) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addVideoTrack(File dir, String filenameFormatter, int width, int height) {
        Format fmt = filenameFormatter.toLowerCase().endsWith(".png") ? new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "png ", VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, 24}) : new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, 24});
        VideoTrack t = new VideoTrack(dir, filenameFormatter, fmt, null, width, height);
        this.tracks.add(t);
        this.createCodec(t);
        return this.tracks.size() - 1;
    }

    private void createCodec(VideoTrack vt) {
        Format fmt = vt.videoFormat;
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (enc.equals("MJPG") || enc.equals("jpeg")) {
            vt.codec = new JPEGCodec();
        } else if (enc.equals("png ") || enc.equals("png ")) {
            vt.codec = new PNGCodec();
        }
        vt.codec.setInputFormat(fmt.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class}));
        vt.codec.setOutputFormat(fmt.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, enc, VideoFormatKeys.DataClassKey, byte[].class}));
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        VideoTrack t = this.tracks.get(track);
        if (t.inputBuffer == null) {
            t.inputBuffer = new Buffer();
        }
        if (t.outputBuffer == null) {
            t.outputBuffer = new Buffer();
        }
        t.inputBuffer.setFlagsTo(BufferFlag.KEYFRAME);
        t.inputBuffer.data = image;
        t.codec.process(t.inputBuffer, t.outputBuffer);
        this.write(track, t.outputBuffer);
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        VideoTrack t = this.tracks.get(track);
        if (buf.data instanceof BufferedImage) {
            if (t.outputBuffer == null) {
                t.outputBuffer = new Buffer();
            }
            if (buf.isFlag(BufferFlag.DISCARD)) {
                return;
            }
            t.codec.process(buf, t.outputBuffer);
            buf = t.outputBuffer;
        }
        File file = new File(t.dir, String.format(t.nameFormat, t.count + 1));
        if (buf.data instanceof byte[]) {
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write((byte[])buf.data, buf.offset, buf.length);
            }
        } else if (buf.data instanceof File) {
            IOStreams.copy((File)buf.data, file);
        } else {
            throw new IllegalArgumentException("Can't process buffer data:" + String.valueOf(buf.data));
        }
        ++t.count;
    }

    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        VideoTrack t = this.tracks.get(track);
        File file = new File(t.dir, String.format(t.nameFormat, t.count + 1));
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(data, off, len);
        }
        ++t.count;
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        for (int i = 0; i < sampleCount; ++i) {
            this.writeSample(track, data, off, len / sampleCount, sampleDuration, isSync);
            off += len / sampleCount;
        }
    }

    @Override
    public void close() throws IOException {
    }

    public boolean isVFRSupported() {
        return false;
    }

    @Override
    public boolean isDataLimitReached() {
        return false;
    }

    @Override
    public Rational getDuration(int track) {
        VideoTrack tr = this.tracks.get(track);
        return new Rational(tr.count, 30L);
    }

    @Override
    public boolean isEmpty(int track) {
        return this.tracks.get((int)track).count == 0;
    }

    private static class VideoTrack {
        Format videoFormat;
        File dir;
        String nameFormat;
        int count;
        Codec codec;
        Buffer inputBuffer;
        Buffer outputBuffer;
        int width;
        int height;

        public VideoTrack(File dir, String filenameFormatter, Format fmt, Codec codec, int width, int height) {
            this.dir = dir;
            this.nameFormat = filenameFormatter;
            this.videoFormat = fmt;
            this.codec = codec;
            this.width = width;
            this.height = height;
        }
    }
}

