/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class ByteArrayImageOutputStream
extends ImageOutputStreamImpl {
    protected byte[] buf;
    protected int count;
    private final int arrayOffset;

    public ByteArrayImageOutputStream() {
        this(16);
    }

    public ByteArrayImageOutputStream(int initialCapacity) {
        this(new byte[initialCapacity]);
    }

    public ByteArrayImageOutputStream(byte[] buf) {
        this(buf, ByteOrder.BIG_ENDIAN);
    }

    public ByteArrayImageOutputStream(byte[] buf, ByteOrder byteOrder) {
        this(buf, 0, buf.length, byteOrder);
    }

    public ByteArrayImageOutputStream(byte[] buf, int offset, int length, ByteOrder byteOrder) {
        this.buf = buf;
        this.streamPos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.arrayOffset = offset;
        this.byteOrder = byteOrder;
    }

    public ByteArrayImageOutputStream(ByteOrder byteOrder) {
        this(new byte[16], byteOrder);
    }

    @Override
    public int read() throws IOException {
        this.flushBits();
        return this.streamPos < (long)this.count ? this.buf[(int)this.streamPos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.streamPos >= (long)this.count) {
            return -1;
        }
        if (this.streamPos + (long)len > (long)this.count) {
            len = (int)((long)this.count - this.streamPos);
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, (int)this.streamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    public long skip(long n) {
        if (this.streamPos + n > (long)this.count) {
            n = (long)this.count - this.streamPos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.streamPos += n;
        return n;
    }

    public int available() {
        return (int)((long)this.count - this.streamPos);
    }

    @Override
    public void close() {
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos - (long)this.arrayOffset;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        this.flushBits();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = pos + (long)this.arrayOffset;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        long newcount = Math.max(this.streamPos + 1L, (long)this.count);
        if (newcount > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(newcount + " > max array size");
        }
        if (newcount > (long)this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, (int)newcount));
        }
        this.buf[(int)this.streamPos++] = (byte)b;
        this.count = (int)newcount;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off=" + off + ", len=" + len + ", b.length=" + b.length);
        }
        if (len == 0) {
            return;
        }
        int newcount = Math.max((int)this.streamPos + len, this.count);
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, (int)this.streamPos, len);
        this.streamPos += (long)len;
        this.count = newcount;
    }

    public void toOutputStream(OutputStream out) throws IOException {
        out.write(this.buf, this.arrayOffset, this.count);
    }

    public void toImageOutputStream(ImageOutputStream out) throws IOException {
        out.write(this.buf, this.arrayOffset, this.count);
    }

    public byte[] toByteArray() {
        byte[] copy = new byte[this.count - this.arrayOffset];
        System.arraycopy(this.buf, this.arrayOffset, copy, 0, this.count);
        return copy;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    @Override
    public long length() {
        return this.count - this.arrayOffset;
    }

    public void clear() {
        this.count = this.arrayOffset;
        this.streamPos = this.arrayOffset;
    }
}

