/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.math;

import java.math.BigInteger;
import org.monte.media.math.IntMath;

public class Rational
extends Number
implements Comparable<Rational> {
    public static final Rational ONE = new Rational(1L, 1L, false);
    public static final Rational ZERO = new Rational(0L, 1L, false);
    public static final long serialVersionUID = 1L;
    private final long num;
    private final long den;

    public Rational(long numerator) {
        this(numerator, 1L);
    }

    public Rational(long numerator, long denominator) {
        this(numerator, denominator, true);
    }

    private Rational(long numerator, long denominator, boolean reduceFraction) {
        if (numerator == 0L) {
            denominator = 1L;
        }
        if (denominator == 0L) {
            numerator = numerator > 0L ? 1L : -1L;
        } else if (denominator < 0L) {
            denominator = -denominator;
            numerator = -numerator;
        }
        if (reduceFraction) {
            long g = IntMath.gcd(numerator, denominator);
            this.num = numerator / g;
            this.den = denominator / g;
        } else {
            this.num = numerator;
            this.den = denominator;
        }
    }

    private Rational(BigInteger numerator, BigInteger denominator, boolean reduceFraction) {
        BigInteger denB;
        BigInteger numB;
        if (numerator.equals(BigInteger.ZERO)) {
            denominator = BigInteger.ONE;
        }
        if (denominator.equals(BigInteger.ZERO)) {
            numerator = numerator.compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ONE.negate();
        } else if (denominator.compareTo(BigInteger.ZERO) < 0) {
            denominator = denominator.negate();
            numerator = numerator.negate();
        }
        if (reduceFraction) {
            BigInteger g = IntMath.gcd(numerator, denominator);
            numB = numerator.divide(g);
            denB = denominator.divide(g);
        } else {
            numB = numerator;
            denB = denominator;
        }
        int bitLength = Math.max(numB.bitLength(), denB.bitLength());
        if (bitLength > 63) {
            numB = numB.shiftRight(bitLength - 63);
            denB = denB.shiftRight(bitLength - 63);
            if (numB.equals(BigInteger.ZERO)) {
                denB = BigInteger.ONE;
            }
            if (denB.equals(BigInteger.ZERO)) {
                numB = numB.compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ONE.negate();
            }
        }
        this.num = numB.longValue();
        this.den = denB.longValue();
    }

    public Rational(Rational r) {
        this(r.num, r.den);
    }

    public long getNumerator() {
        return this.num;
    }

    public long getDenominator() {
        return this.den;
    }

    public Rational add(Rational that) {
        return this.add(that, true);
    }

    public Rational add(long num, long den) {
        return this.add(num, den, true);
    }

    private Rational add(Rational that, boolean reduceFraction) {
        return this.add(that.num, that.den, reduceFraction);
    }

    private Rational add(long thatNum, long thatDen, boolean reduceFraction) {
        if (this.den == thatDen) {
            return new Rational(this.num + thatNum, this.den, reduceFraction);
        }
        long s = IntMath.scm(this.den, thatDen);
        return new Rational(this.num * (s / this.den) + thatNum * (s / thatDen), s, reduceFraction);
    }

    public Rational subtract(Rational that) {
        return this.add(that.negate());
    }

    public Rational negate() {
        return Rational.valueOf(-this.num, this.den);
    }

    public Rational inverse() {
        return Rational.valueOf(this.den, this.num, false);
    }

    public Rational floor(long d) {
        if (d == this.den) {
            return Rational.valueOf(this.num, this.den);
        }
        long s = IntMath.scm(this.den, d);
        if (s == d) {
            return Rational.valueOf(this.num * s / this.den, d);
        }
        if (s == this.den) {
            return Rational.valueOf(this.num * d / this.den, d);
        }
        return Rational.valueOf(this.num * d / this.den, d);
    }

    public long floorNumerator(long d) {
        if (d == this.den) {
            return this.num;
        }
        long s = IntMath.scm(this.den, d);
        if (s == d) {
            return this.num * s / this.den;
        }
        return this.num * d / this.den;
    }

    public Rational ceil(long d) {
        if (d == this.den) {
            return Rational.valueOf(this.num, this.den);
        }
        long s = IntMath.scm(this.den, d);
        if (s == d) {
            return Rational.valueOf((this.num * s + this.den - 1L) / this.den, d);
        }
        if (s == this.den) {
            return Rational.valueOf((this.num * d + this.den - 1L) / this.den, d);
        }
        return Rational.valueOf((this.num * d + this.den - 1L) / this.den, d);
    }

    public Rational multiply(Rational that) {
        if (Math.abs(this.num) < Integer.MAX_VALUE && Math.abs(this.den) < Integer.MAX_VALUE && Math.abs(that.num) < Integer.MAX_VALUE && Math.abs(that.den) < Integer.MAX_VALUE) {
            return Rational.valueOf(this.num * that.num, this.den * that.den);
        }
        return new Rational(BigInteger.valueOf(this.num).multiply(BigInteger.valueOf(that.num)), BigInteger.valueOf(this.den).multiply(BigInteger.valueOf(that.den)), true);
    }

    public Rational multiply(long integer) {
        if (integer == 0L) {
            return ZERO;
        }
        if (this.den % integer == 0L) {
            return Rational.valueOf(this.num, this.den / integer);
        }
        if (Math.abs(this.num) < Integer.MAX_VALUE && Math.abs(integer) < Integer.MAX_VALUE) {
            return Rational.valueOf(this.num * integer, this.den);
        }
        return new Rational(BigInteger.valueOf(this.num).multiply(BigInteger.valueOf(integer)), BigInteger.valueOf(this.den), true);
    }

    public Rational divide(Rational that) {
        if (Math.abs(this.num) < Integer.MAX_VALUE && Math.abs(this.den) < Integer.MAX_VALUE && Math.abs(that.num) < Integer.MAX_VALUE && Math.abs(that.den) < Integer.MAX_VALUE) {
            return Rational.valueOf(this.num * that.den, this.den * that.num);
        }
        return Rational.valueOf(BigInteger.valueOf(this.num).multiply(BigInteger.valueOf(that.den)), BigInteger.valueOf(this.den).multiply(BigInteger.valueOf(that.num)), true);
    }

    public String toString() {
        if (this.num == 0L) {
            return "0";
        }
        if (this.den == 1L) {
            return Long.toString(this.num);
        }
        return this.num + "/" + this.den;
    }

    public String toDescriptiveString() {
        long gcd = IntMath.gcd(this.num, this.den);
        if (gcd == 0L || this.num == 0L) {
            return this.num + "/" + this.den + " = 0";
        }
        if (gcd == this.den) {
            return this.num + "/" + this.den + " = " + Long.toString(this.num / this.den);
        }
        return this.num + "/" + this.den + " \u2248 " + (float)this.num / (float)this.den;
    }

    @Override
    public int intValue() {
        return (int)(this.num / this.den);
    }

    @Override
    public long longValue() {
        return this.num / this.den;
    }

    @Override
    public float floatValue() {
        return (float)this.num / (float)this.den;
    }

    @Override
    public double doubleValue() {
        return (double)this.num / (double)this.den;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(Rational that) {
        if (this.den == that.den) {
            if (this.num < that.num) {
                return -1;
            }
            if (this.num > that.num) {
                return 1;
            }
            return 0;
        }
        if (Math.abs(this.num) < Integer.MAX_VALUE && Math.abs(this.den) < Integer.MAX_VALUE && Math.abs(that.num) < Integer.MAX_VALUE && Math.abs(that.den) < Integer.MAX_VALUE) {
            long lhs = this.num * that.den;
            long rhs = this.den * that.num;
            if (lhs < rhs) {
                return -1;
            }
            if (lhs > rhs) {
                return 1;
            }
            return 0;
        }
        BigInteger lhs = BigInteger.valueOf(this.num).multiply(BigInteger.valueOf(that.den));
        BigInteger rhs = BigInteger.valueOf(this.den).multiply(BigInteger.valueOf(that.num));
        return lhs.compareTo(rhs);
    }

    public int hashCode() {
        return (int)(this.num ^ this.num >>> 32 ^ (this.den ^ this.den >>> 32));
    }

    public static Rational max(Rational a, Rational b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static Rational min(Rational a, Rational b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public boolean isZero() {
        return this.num == 0L;
    }

    public boolean isLessOrEqualZero() {
        return this.num <= 0L;
    }

    public static Rational valueOf(double d) {
        if (d == 0.0) {
            return Rational.valueOf(0L, 1L);
        }
        if (Math.abs(d) > 2.147483647E9) {
            throw new IllegalArgumentException("Value " + d + " is too big.");
        }
        if (Double.isInfinite(d)) {
            return Rational.valueOf((long)Math.signum(d), 0L);
        }
        if (Double.isNaN(d)) {
            return Rational.valueOf(0L, 1L);
        }
        return Rational.toRational(d, 2.147483647E9, 100);
    }

    public static Rational valueOf(long num, long den) {
        return Rational.valueOf(num, den, true);
    }

    private static Rational valueOf(long num, long den, boolean reduceFraction) {
        if (num == den) {
            return ONE;
        }
        if (num == 0L) {
            return ZERO;
        }
        return new Rational(num, den, reduceFraction);
    }

    public static Rational valueOf(BigInteger num, BigInteger den) {
        return Rational.valueOf(num, den, true);
    }

    private static Rational valueOf(BigInteger num, BigInteger den, boolean reduceFraction) {
        if (num.equals(den)) {
            return ONE;
        }
        if (num.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        return new Rational(num, den, reduceFraction);
    }

    private static Rational toRational(double x, double limit, int iterations) {
        double intpart = Math.floor(x);
        double fractpart = x - intpart;
        double d = 1.0 / fractpart;
        long left = (long)intpart;
        if (d > limit || iterations == 0) {
            return Rational.valueOf(left, 1L, false);
        }
        return Rational.valueOf(left, 1L, false).add(Rational.toRational(d, limit * 0.1, iterations - 1).inverse(), false);
    }

    public Rational round(long d) {
        if (d == this.den) {
            return Rational.valueOf(this.num, this.den);
        }
        Rational fl = this.floor(d);
        Rational diffFl = this.subtract(fl);
        if (diffFl.isZero()) {
            return fl;
        }
        Rational cl = this.ceil(d);
        Rational diffCl = this.subtract(cl);
        if (diffCl.isZero()) {
            return cl;
        }
        if (diffFl.isNegative()) {
            diffFl = diffFl.negate();
        }
        if (diffCl.isNegative()) {
            diffCl = diffCl.negate();
        }
        return diffFl.compareTo(diffCl) <= 0 ? fl : cl;
    }

    private boolean isNegative() {
        return this.num < 0L;
    }

    public static Rational valueOf(String str) {
        int p = str.indexOf(47);
        if (p != -1) {
            return Rational.valueOf(Long.valueOf(str.substring(0, p)), Long.valueOf(str.substring(p + 1)));
        }
        try {
            return Rational.valueOf(Long.valueOf(str).longValue());
        }
        catch (NumberFormatException e) {
            return Rational.valueOf(Double.valueOf(str));
        }
    }
}

