/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.mpo;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.exif.DefaultIIOMetadata;
import org.monte.media.exif.EXIFReader;
import org.monte.media.exif.EXIFTagSet;
import org.monte.media.exif.MPEntryTagSet;
import org.monte.media.exif.MPFTagSet;
import org.monte.media.io.SubImageInputStream;
import org.monte.media.jpeg.CMYKJPEGImageReader;
import org.monte.media.mpo.MPOImageReaderSpi;
import org.monte.media.tiff.BaselineTagSet;
import org.monte.media.tiff.TIFFDirectory;
import org.monte.media.tiff.TIFFField;
import org.monte.media.tiff.TIFFNode;
import org.monte.media.tiff.TIFFTag;

public class MPOImageReader
extends ImageReader {
    private static DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private int numImages = -1;
    private long[] imageOffsets;
    private long[] imageLengths;
    private long[] thumbOffsets;
    private long[] thumbLengths;
    private int[] width = null;
    private int[] height = null;
    private IIOMetadata[] imageMetadata;
    private EXIFReader er;

    public MPOImageReader(MPOImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (allowSearch && this.numImages == -1) {
            this.readHeader();
        }
        return this.numImages;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.width[imageIndex];
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.height[imageIndex];
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.width[imageIndex], this.height[imageIndex])));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.readHeader();
        if (imageIndex < 0 || imageIndex >= this.imageOffsets.length) {
            throw new IndexOutOfBoundsException("illegal imageIndex=" + imageIndex);
        }
        return this.imageMetadata[imageIndex];
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readHeader();
        if (imageIndex < 0 || imageIndex >= this.imageOffsets.length) {
            throw new IndexOutOfBoundsException("illegal imageIndex=" + imageIndex);
        }
        ImageInputStream in = (ImageInputStream)this.getInput();
        SubImageInputStream sin = new SubImageInputStream(in, this.imageOffsets[imageIndex], this.imageLengths[imageIndex]);
        sin.seek(0L);
        CMYKJPEGImageReader ir = new CMYKJPEGImageReader(this.getOriginatingProvider());
        ir.setInput(sin);
        BufferedImage img = ir.read(0);
        ((ImageReader)ir).dispose();
        return img;
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        this.readHeader();
        return super.getNumThumbnails(imageIndex);
    }

    private void readHeader() throws IOException {
        if (this.numImages == -1) {
            ImageInputStream in = (ImageInputStream)this.getInput();
            in.seek(0L);
            this.er = new EXIFReader(in);
            this.er.setFirstImageOnly(false);
            this.er.read();
            HashMap<TIFFTag, TIFFField> m = this.er.getMetaDataMap();
            TIFFField mde = m.get(MPFTagSet.get(45057));
            this.numImages = mde != null ? ((Number)mde.getData()).intValue() : 1;
            this.width = new int[this.numImages];
            this.height = new int[this.numImages];
            TIFFNode metaDataTree = this.er.getMetaDataTree();
            int n = metaDataTree.getChildCount();
            for (int i = 0; i < n; ++i) {
                TIFFNode imageNode = metaDataTree.getChildAt(i);
                Iterator<TIFFNode> e = imageNode.preorderIterator();
                while (e.hasNext()) {
                    TIFFNode node = e.next();
                    if (!(node instanceof TIFFDirectory)) continue;
                    TIFFDirectory dir = (TIFFDirectory)node;
                    mde = dir.getField(BaselineTagSet.ImageWidth);
                    if (mde != null) {
                        this.width[i] = ((Number)mde.getData()).intValue();
                    }
                    if ((mde = dir.getField(BaselineTagSet.ImageHeight)) != null) {
                        this.height[i] = ((Number)mde.getData()).intValue();
                    }
                    if ((mde = dir.getField(EXIFTagSet.PixelXDimension)) != null) {
                        this.width[i] = ((Number)mde.getData()).intValue();
                    }
                    if ((mde = dir.getField(EXIFTagSet.PixelYDimension)) == null) continue;
                    this.height[i] = ((Number)mde.getData()).intValue();
                }
            }
            this.imageOffsets = new long[this.numImages];
            this.imageLengths = new long[this.numImages];
            if (this.numImages == 1) {
                this.imageOffsets[0] = 0L;
                this.imageLengths[0] = in.length();
            }
            int index = 0;
            Iterator<TIFFNode> e = this.er.getMetaDataTree().preorderIterator();
            while (e.hasNext()) {
                TIFFDirectory dir;
                TIFFNode n2 = e.next();
                if (!(n2 instanceof TIFFDirectory) || (dir = (TIFFDirectory)n2).getName() == null || !dir.getName().equals("MPEntry")) continue;
                long dirOffset = dir.getFileSegments().get(0).offset();
                TIFFField offsetField = dir.getField(MPEntryTagSet.IndividualImageDataOffset);
                TIFFField lengthField = dir.getField(MPEntryTagSet.IndividualImageSize);
                if (offsetField == null || lengthField == null) continue;
                long dataOffset = (Long)offsetField.getData();
                this.imageOffsets[index] = dataOffset == 0L ? 0L : dirOffset + dataOffset;
                this.imageLengths[index] = (Long)lengthField.getData();
                ++index;
            }
            String formatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
            this.imageMetadata = new IIOMetadata[this.numImages];
            for (int i = 0; i < this.numImages; ++i) {
                this.imageMetadata[i] = new DefaultIIOMetadata(formatName, this.er.getIIOMetadataTree(formatName, i));
            }
            in.seek(0L);
        }
    }

    public TIFFNode getExifMetadata() throws IOException {
        this.readHeader();
        return this.er.getMetaDataTree();
    }

    public EXIFReader getExifReader() throws IOException {
        this.readHeader();
        return this.er;
    }
}

