/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.io.ImageOutputStreamAdapter;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.DataAtomOutputStream;

public class AbstractQuickTimeStream {
    protected ImageOutputStream out;
    protected long streamOffset;
    protected WideDataAtom mdatAtom;
    protected long mdatOffset;
    protected CompositeAtom moovAtom;
    protected Date creationTime;
    protected Date modificationTime;
    protected long movieTimeScale = 600L;
    protected double preferredRate = 1.0;
    protected double preferredVolume = 1.0;
    protected long previewTime = 0L;
    protected long previewDuration = 0L;
    protected long posterTime = 0L;
    protected long selectionTime = 0L;
    protected long selectionDuration = 0L;
    protected long currentTime = 0L;
    protected ArrayList<Track> tracks = new ArrayList();
    protected double[] movieMatrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    protected States state = States.REALIZED;

    public void setTrackEnabled(int track, boolean newValue) {
        this.tracks.get(track).setEnabled(newValue);
    }

    public boolean isTrackEnabled(int track) {
        return this.tracks.get(track).isEnabled();
    }

    public void setTrackInMovie(int track, boolean newValue) {
        this.tracks.get(track).setInMovie(newValue);
    }

    public boolean isTrackInMovie(int track) {
        return this.tracks.get(track).isInMovie();
    }

    public void setTrackInPreview(int track, boolean newValue) {
        this.tracks.get(track).setInPreview(newValue);
    }

    public boolean isTrackInPreview(int track) {
        return this.tracks.get(track).isInPreview();
    }

    public void setTrackInPoster(int track, boolean newValue) {
        this.tracks.get(track).setInPoster(newValue);
    }

    public boolean isTrackInPoster(int track) {
        return this.tracks.get(track).isInPoster();
    }

    protected long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    protected void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    protected static int typeToInt(String str) {
        int value = (str.charAt(0) & 0xFF) << 24 | (str.charAt(1) & 0xFF) << 16 | (str.charAt(2) & 0xFF) << 8 | str.charAt(3) & 0xFF;
        return value;
    }

    protected static String intToType(int id) {
        char[] b = new char[]{(char)(id >>> 24 & 0xFF), (char)(id >>> 16 & 0xFF), (char)(id >>> 8 & 0xFF), (char)(id & 0xFF)};
        return String.valueOf(b);
    }

    protected static enum States {
        REALIZED,
        STARTED,
        FINISHED,
        CLOSED;

    }

    protected abstract class Track {
        protected final FormatKeys.MediaType mediaType;
        protected Format format;
        protected long mediaTimeScale = 600L;
        protected String mediaCompressionType;
        protected String mediaCompressorName;
        protected ArrayList<Chunk> chunks = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected ArrayList<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected long mediaDuration = 0L;
        protected Edit[] editList;
        protected int syncInterval;
        protected Codec codec;
        protected Buffer outputBuffer;
        protected Buffer inputBuffer;
        protected Rational inputTime;
        protected Rational writeTime;
        protected double[] matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        protected double width;
        protected double height;
        private static final int TrackEnable = 1;
        private static final int TrackInMovie = 2;
        private static final int TrackInPreview = 4;
        private static final int TrackInPoster = 8;
        protected int headerFlags = 15;

        public Track(FormatKeys.MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public void setEnabled(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 1 : this.headerFlags & 0xFE;
        }

        public boolean isEnabled() {
            return (this.headerFlags & 1) != 0;
        }

        public void setInMovie(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 2 : this.headerFlags & 0xFD;
        }

        public boolean isInMovie() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPreview(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 4 : this.headerFlags & 0xFB;
        }

        public boolean isInPreview() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPoster(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 8 : this.headerFlags & 0xF7;
        }

        public boolean isInPoster() {
            return (this.headerFlags & 8) != 0;
        }

        public void addSample(Sample sample, int sampleDescriptionId, boolean isSyncSample) {
            this.mediaDuration += sample.duration;
            ++this.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    this.syncSamples.add(this.sampleCount);
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddSample(sample)) {
                this.timeToSamples.add(new TimeToSampleGroup(sample));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddSample(sample)) {
                this.sampleSizes.add(new SampleSizeGroup(sample));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddSample(sample, sampleDescriptionId)) {
                this.chunks.add(new Chunk(sample, sampleDescriptionId));
            }
        }

        public void addChunk(Chunk chunk, boolean isSyncSample) {
            this.mediaDuration += chunk.firstSample.duration * chunk.sampleCount;
            this.sampleCount += chunk.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    for (long i = this.sampleCount - chunk.sampleCount; i < this.sampleCount; ++i) {
                        this.syncSamples.add(i);
                    }
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddChunk(chunk)) {
                this.timeToSamples.add(new TimeToSampleGroup(chunk));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddChunk(chunk)) {
                this.sampleSizes.add(new SampleSizeGroup(chunk));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddChunk(chunk)) {
                this.chunks.add(chunk);
            }
        }

        public boolean isEmpty() {
            return this.sampleCount == 0L;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getTrackDuration(long movieTimeScale) {
            if (this.editList == null || this.editList.length == 0) {
                return this.mediaDuration * movieTimeScale / this.mediaTimeScale;
            }
            long duration = 0L;
            for (int i = 0; i < this.editList.length; ++i) {
                duration += (long)this.editList[i].trackDuration;
            }
            return duration;
        }

        public int getFirstSampleTime(long movieTimeScale) {
            return this.inputTime == null ? 0 : this.inputTime.multiply(movieTimeScale).intValue();
        }

        protected abstract void writeSampleDescriptionAtom(CompositeAtom var1) throws IOException;
    }

    public static class Edit {
        public int trackDuration;
        public int mediaTime;
        public int mediaRate;

        public Edit(int trackDuration, int mediaTime, double mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = (int)(mediaRate * 65536.0);
        }

        public Edit(int trackDuration, int mediaTime, int mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
        }
    }

    protected class AudioTrack
    extends Track {
        protected int soundNumberOfChannels;
        protected int soundSampleSize;
        protected int soundCompressionId;
        protected long soundSamplesPerPacket;
        protected long soundBytesPerPacket;
        protected long soundBytesPerFrame;
        protected long soundBytesPerSample;
        protected double soundSampleRate;
        protected byte[] stsdExtensions;

        public AudioTrack() {
            super(FormatKeys.MediaType.AUDIO);
            this.stsdExtensions = new byte[0];
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeUInt(52 + this.stsdExtensions.length);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeUShort(1);
            d.writeUShort(1);
            d.writeUShort(0);
            d.writeUInt(0L);
            d.writeUShort(this.soundNumberOfChannels);
            d.writeUShort(this.soundSampleSize);
            d.writeUShort(this.soundCompressionId);
            d.writeUShort(0);
            d.writeFixed16D16(this.soundSampleRate);
            d.writeUInt(this.soundSamplesPerPacket);
            d.writeUInt(this.soundBytesPerPacket);
            d.writeUInt(this.soundBytesPerFrame);
            d.writeUInt(this.soundBytesPerSample);
            d.write(this.stsdExtensions);
        }
    }

    protected class VideoTrack
    extends Track {
        protected float videoQuality;
        protected int videoDepth;
        protected IndexColorModel videoColorTable;

        public VideoTrack() {
            super(FormatKeys.MediaType.VIDEO);
            this.videoQuality = 0.97f;
            this.videoDepth = -1;
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            CompositeAtom leaf = new CompositeAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeInt(86);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeShort(1);
            d.writeShort(0);
            d.writeShort(0);
            d.writeType("java");
            d.writeInt(0);
            d.writeInt((int)(1024.0f * (1.0f - this.videoQuality)));
            d.writeUShort((int)this.width);
            d.writeUShort((int)this.height);
            d.writeFixed16D16(72.0);
            d.writeFixed16D16(72.0);
            d.writeInt(0);
            d.writeShort(1);
            d.writePString(this.mediaCompressorName, 32);
            d.writeShort(this.videoDepth);
            d.writeShort(this.videoColorTable == null ? -1 : 0);
        }

        protected void writeColorTableAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("ctab");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.writeUInt(0L);
            d.writeUShort(32768);
            d.writeUShort(this.videoColorTable.getMapSize() - 1);
            int n = this.videoColorTable.getMapSize();
            for (int i = 0; i < n; ++i) {
                d.writeUShort(0);
                d.writeUShort(this.videoColorTable.getRed(i) << 8 | this.videoColorTable.getRed(i));
                d.writeUShort(this.videoColorTable.getGreen(i) << 8 | this.videoColorTable.getGreen(i));
                d.writeUShort(this.videoColorTable.getBlue(i) << 8 | this.videoColorTable.getBlue(i));
            }
        }
    }

    protected static class Chunk
    extends Group {
        protected int sampleDescriptionId;

        public Chunk(Sample firstSample, int sampleDescriptionId) {
            super(firstSample);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public Chunk(Sample firstSample, Sample lastSample, int sampleCount, int sampleDescriptionId) {
            super(firstSample, lastSample, sampleCount);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public boolean maybeAddSample(Sample sample, int sampleDescriptionId) {
            if (sampleDescriptionId == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    protected static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(Sample firstSample) {
            super(firstSample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    protected static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(Sample firstSample) {
            super(firstSample);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    protected static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    protected static abstract class Group {
        protected Sample firstSample;
        protected Sample lastSample;
        protected long sampleCount;
        protected static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(Sample firstSample) {
            this.firstSample = this.lastSample = firstSample;
            this.sampleCount = 1L;
        }

        protected Group(Sample firstSample, Sample lastSample, long sampleCount) {
            this.firstSample = firstSample;
            this.lastSample = lastSample;
            this.sampleCount = sampleCount;
            if (sampleCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(Sample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }

    protected class WideDataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public WideDataAtom(String type) throws IOException {
            super(type, AbstractQuickTimeStream.this.getRelativeStreamPosition());
            AbstractQuickTimeStream.this.out.writeLong(0L);
            AbstractQuickTimeStream.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(this, new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out)){
                final /* synthetic */ WideDataAtom this$1;
                {
                    this.this$1 = this$1;
                    super(out);
                }

                @Override
                public void flush() throws IOException {
                }
            };
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("Atom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                long finishedSize = this.size();
                if (finishedSize <= 0xFFFFFFFFL) {
                    headerData.writeUInt(8L);
                    headerData.writeType("wide");
                    headerData.writeUInt(finishedSize - 8L);
                    headerData.writeType(this.type);
                } else {
                    headerData.writeInt(1);
                    headerData.writeType(this.type);
                    headerData.writeLong(finishedSize - 8L);
                }
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 16L + this.data.size();
        }
    }

    protected class DataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public DataAtom(String type) throws IOException {
            super(type, AbstractQuickTimeStream.this.getRelativeStreamPosition());
            AbstractQuickTimeStream.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataAtom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                headerData.writeUInt(this.size());
                headerData.writeType(this.type);
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    protected class CompositeAtom
    extends DataAtom {
        protected LinkedList<Atom> children;

        public CompositeAtom(String type) throws IOException {
            super(type);
            this.children = new LinkedList();
        }

        public void add(Atom child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                headerData.writeInt((int)this.size());
                headerData.writeType(this.type);
                for (Atom child : this.children) {
                    child.finish();
                }
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 8L + this.data.size();
            for (Atom child : this.children) {
                length += child.size();
            }
            return length;
        }
    }

    protected abstract class Atom {
        protected String type;
        protected long offset;

        public Atom(String type, long offset) {
            this.type = type;
            this.offset = offset;
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }
}

