/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.av.FormatKeys;
import org.monte.media.io.UncachedImageInputStream;
import org.monte.media.quicktime.QTFFImageInputStream;
import org.monte.media.quicktime.QuickTimeMeta;

public class QuickTimeDeserializer {
    static final HashSet<String> compositeAtoms = new HashSet();

    public QuickTimeMeta read(URI uri) throws IOException {
        QuickTimeMeta m = new QuickTimeMeta();
        QTFFImageInputStream in = new QTFFImageInputStream(new FileImageInputStream(new File(uri)));
        this.parse(in, m);
        return m;
    }

    public QuickTimeMeta read(ImageInputStream iin) throws IOException {
        QuickTimeMeta m = new QuickTimeMeta();
        QTFFImageInputStream in = new QTFFImageInputStream(iin);
        this.parse(in, m);
        return m;
    }

    protected void parse(QTFFImageInputStream in, QuickTimeMeta m) throws IOException {
        this.parseRecursively(in, in.length(), m);
        for (QuickTimeMeta.Track track : m.tracks) {
            track.buildSamplesTable(m.timeScale);
        }
    }

    protected void parseRecursively(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        while (remainingSize > 0L) {
            Atom atom = new Atom();
            atom.offset = in.getStreamPosition();
            atom.size = (long)in.readInt() & 0xFFFFFFFFL;
            if (atom.size >= 8L) {
                atom.type = in.readType();
                atom.headerSize = 8L;
            } else {
                atom.type = "free";
                atom.headerSize = 4L;
            }
            if (atom.size == 0L) {
                atom.size = remainingSize;
                if (atom.headerSize + 4L <= remainingSize) {
                    in.skipBytes(4);
                    atom.headerSize += 4L;
                }
            } else if (atom.size == 1L) {
                atom.headerSize = 16L;
                atom.size = in.readLong();
            }
            if (atom.size > remainingSize) {
                atom.size = remainingSize;
            }
            String t = atom.type;
            if (compositeAtoms.contains(atom.type)) {
                if ("trak".equals(t)) {
                    m.tracks.add(new QuickTimeMeta.Track());
                } else if ("mdia".equals(t)) {
                    m.tracks.get((int)(m.getTrackCount() - 1)).media = new QuickTimeMeta.Media();
                }
                this.parseRecursively(in, atom.size - atom.headerSize, m);
            } else {
                QuickTimeMeta.Media media;
                QuickTimeMeta.Track track = m.tracks.isEmpty() ? null : m.tracks.get(m.tracks.size() - 1);
                QuickTimeMeta.Media media2 = media = track == null ? null : track.media;
                if (null != t) {
                    block22 : switch (t) {
                        case "ftyp": {
                            this.parseFileType(in, atom.size - atom.headerSize, m);
                            break;
                        }
                        case "wide": {
                            break;
                        }
                        case "mdat": {
                            this.parseMovieData(in, atom.size - atom.headerSize, m);
                            break;
                        }
                        case "mvhd": {
                            this.parseMovieHeader(in, atom.size - atom.headerSize, m);
                            break;
                        }
                        case "dcom": {
                            this.parseDataCompressionAtom(in, atom.size - atom.headerSize, m);
                            break;
                        }
                        case "cmvd": {
                            this.parseCompressedMovieAtom(in, atom.size - atom.headerSize, m);
                            break;
                        }
                        case "tkhd": {
                            this.parseTrackHeader(in, atom.size - atom.headerSize, track);
                            break;
                        }
                        case "elst": {
                            this.parseEditList(in, atom.size - atom.headerSize, track);
                            break;
                        }
                        case "mdhd": {
                            this.parseMediaHeader(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "hdlr": {
                            this.parseHandlerReference(in, atom.size - atom.headerSize, track, media);
                            break;
                        }
                        case "smhd": {
                            this.parseSoundMediaHeader(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "dref": {
                            this.parseDataReference(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stsd": {
                            if (track == null || track.mediaType == null) break;
                            switch (track.mediaType) {
                                case AUDIO: {
                                    this.parseSoundSampleDescription(in, atom.size - atom.headerSize, media);
                                    break block22;
                                }
                                case VIDEO: {
                                    this.parseVideoSampleDescription(in, atom.size - atom.headerSize, media);
                                    break block22;
                                }
                            }
                            this.parseGenericSampleDescription(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "vmhd": {
                            this.parseVideoMediaHeader(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stts": {
                            this.parseTimeToSample(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stsc": {
                            this.parseSampleToChunk(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stco": {
                            this.parseChunkOffsets(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "co64": {
                            this.parseChunkOffsets64(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stss": {
                            this.parseSyncSample(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        case "stsz": {
                            this.parseSampleSize(in, atom.size - atom.headerSize, media);
                            break;
                        }
                        default: {
                            atom.data = new byte[(int)(atom.size - atom.headerSize)];
                            in.read(atom.data);
                        }
                    }
                }
                in.seek(atom.offset + atom.size);
            }
            remainingSize -= atom.size;
        }
    }

    protected void parseFileType(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        m.brand = in.readType();
        m.versionYear = in.readUnsignedBCD4();
        m.versionMonth = in.readUnsignedBCD2();
        m.versionMinor = in.readUnsignedBCD2();
        m.compatibleBrands.clear();
        remainingSize -= 10L;
        while (remainingSize > 4L) {
            m.compatibleBrands.add(in.readType());
            remainingSize -= 4L;
        }
    }

    protected void parseDataCompressionAtom(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        if (remainingSize != 4L) {
            return;
        }
        m.compressionMethod = in.readType();
    }

    protected void parseCompressedMovieAtom(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        int sizeOfDecompressedData;
        int n = sizeOfDecompressedData = remainingSize > 4L ? in.readInt() : -1;
        if (sizeOfDecompressedData > 0 && "zlib".equals(m.compressionMethod)) {
            byte[] compressed = new byte[(int)remainingSize - 4];
            in.readFully(compressed);
            QTFFImageInputStream decompressed = new QTFFImageInputStream(new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(compressed))));
            this.parseRecursively(decompressed, sizeOfDecompressedData, m);
        }
    }

    protected void parseMovieData(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        m.movieDataStreamPosition = in.getStreamPosition();
        m.movieDataSize = remainingSize;
    }

    protected void parseMovieHeader(QTFFImageInputStream in, long remainingSize, QuickTimeMeta m) throws IOException {
        if (remainingSize < 100L) {
            return;
        }
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        m.creationTime = in.readMacTimestamp();
        m.modificationTime = in.readMacTimestamp();
        m.timeScale = in.readUnsignedInt();
        m.duration = in.readUnsignedInt();
        m.preferredRate = in.readFixed16D16();
        m.preferredVolume = in.readFixed8D8();
        in.skipBytes(10);
        m.matrix[0] = in.readFixed16D16();
        m.matrix[1] = in.readFixed16D16();
        m.matrix[2] = in.readFixed2D30();
        m.matrix[3] = in.readFixed16D16();
        m.matrix[4] = in.readFixed16D16();
        m.matrix[5] = in.readFixed2D30();
        m.matrix[6] = in.readFixed16D16();
        m.matrix[7] = in.readFixed16D16();
        m.matrix[8] = in.readFixed2D30();
        m.previewTime = in.readUnsignedInt();
        m.previewDuration = in.readUnsignedInt();
        m.posterTime = in.readUnsignedInt();
        m.selectionTime = in.readUnsignedInt();
        m.selectionDuration = in.readUnsignedInt();
        m.currentTime = in.readUnsignedInt();
        m.nextTrackId = in.readUnsignedInt();
    }

    protected void parseTrackHeader(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Track t) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(2);
        t.headerFlags = in.readUnsignedByte();
        t.creationTime = in.readMacTimestamp();
        t.modificationTime = in.readMacTimestamp();
        t.trackId = in.readInt();
        in.skipBytes(4);
        t.duration = in.readUnsignedInt();
        in.skipBytes(8);
        t.layer = in.readUnsignedShort();
        t.alternateGroup = in.readUnsignedShort();
        t.volume = in.readFixed8D8();
        in.skipBytes(2);
        t.matrix[0] = in.readFixed16D16();
        t.matrix[1] = in.readFixed16D16();
        t.matrix[2] = in.readFixed2D30();
        t.matrix[3] = in.readFixed16D16();
        t.matrix[4] = in.readFixed16D16();
        t.matrix[5] = in.readFixed2D30();
        t.matrix[6] = in.readFixed16D16();
        t.matrix[7] = in.readFixed16D16();
        t.matrix[8] = in.readFixed2D30();
        t.width = in.readFixed16D16();
        t.height = in.readFixed16D16();
        remainingSize -= 84L;
    }

    protected void parseEditList(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Track t) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        int numberOfEntries = (int)in.readUnsignedInt();
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.Edit edit = new QuickTimeMeta.Edit(in.readInt(), in.readInt(), in.readFixed16D16());
            t.editList.add(edit);
        }
        remainingSize -= 8L + (long)numberOfEntries * 12L;
    }

    protected void parseMediaHeader(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        m.mediaCreationTime = in.readMacTimestamp();
        m.mediaModificationTime = in.readMacTimestamp();
        m.mediaTimeScale = in.readUnsignedInt();
        m.mediaDuration = in.readUnsignedInt();
        int languageCode = in.readUnsignedShort();
        if (languageCode < 2048) {
            m.mediaLanguageEncoding = "MacRoman";
            m.mediaLanguage = languageCode < QuickTimeMeta.LANGUAGE_CODES.length ? QuickTimeMeta.LANGUAGE_CODES[languageCode] : null;
        } else {
            char[] isochars;
            String iso;
            m.mediaLanguageEncoding = "UTF-8";
            m.mediaLanguage = (languageCode & 0x8000) == 0 ? ("und".equals(iso = new String(isochars = new char[]{(char)((languageCode >>> 10 & 0x1F) + 96), (char)((languageCode >>> 5 & 0x1F) + 96), (char)((languageCode >>> 0 & 0x1F) + 96)})) ? null : new Locale(iso)) : null;
        }
        m.mediaQuality = in.readShort();
    }

    protected void parseHandlerReference(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Track t, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        String componentType = in.readType();
        String componentSubtype = in.readType();
        String componentManufacturer = in.readType();
        int componentFlags = in.readInt();
        int componentFlagsMask = in.readInt();
        String componentName = in.readPString();
        if ("mhlr".equals(componentType)) {
            t.encoding = componentSubtype;
            switch (componentSubtype) {
                case "vide": {
                    t.mediaType = FormatKeys.MediaType.VIDEO;
                    break;
                }
                case "soun": {
                    t.mediaType = FormatKeys.MediaType.AUDIO;
                    break;
                }
                case "midi": {
                    t.mediaType = FormatKeys.MediaType.MIDI;
                    break;
                }
                case "text": 
                case "clcp": {
                    t.mediaType = FormatKeys.MediaType.TEXT;
                    break;
                }
                case "meta": {
                    t.mediaType = FormatKeys.MediaType.META;
                    break;
                }
                case "sprt": {
                    t.mediaType = FormatKeys.MediaType.SPRITE;
                    break;
                }
                default: {
                    t.mediaType = FormatKeys.MediaType.UNKNOWN;
                    break;
                }
            }
        } else if ("dhlr".equals(componentType)) {
            // empty if block
        }
    }

    protected void parseSoundMediaHeader(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        m.soundBalance = in.readFixed8D8();
        in.skipBytes(2);
    }

    protected void parseVideoMediaHeader(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0 || remainingSize != 12L) {
            return;
        }
        in.skipBytes(2);
        int vmhdFlags = in.readUnsignedByte();
        m.videoFlagNoLeanAhead = (vmhdFlags & 1) != 0;
        m.graphicsMode = in.readUnsignedShort();
        for (int i = 0; i < 3; ++i) {
            m.opcolor[i] = in.readUnsignedShort();
        }
    }

    protected void parseDataReference(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.DataReference dref = new QuickTimeMeta.DataReference();
            long size = in.readUnsignedInt();
            dref.referenceType = in.readType();
            version = in.readUnsignedByte();
            in.skipBytes(2);
            dref.referenceFlags = in.readUnsignedByte();
            dref.data = new byte[(int)(size - 12L)];
            in.readFully(dref.data);
            m.dataReferenceList.add(dref);
        }
    }

    protected void parseSoundSampleDescription(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            throw new IOException("unsupported stsd version=" + version);
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        remainingSize -= 12L;
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.SampleDescription d = new QuickTimeMeta.SampleDescription();
            m.addSampleDescription(d);
            int size = in.readInt();
            remainingSize -= (long)size;
            int remainingEntrySize = size;
            d.dataFormat = in.readType();
            in.skipBytes(6);
            d.dataReferenceIndex = in.readUnsignedShort();
            int descriptionVersion = in.readUnsignedShort();
            int revisionLevel = in.readUnsignedShort();
            int vendor = in.readInt();
            d.soundNumberOfChannels = in.readUnsignedShort();
            d.soundSampleSize = in.readUnsignedShort();
            d.soundCompressionId = in.readShort();
            int packetSize = in.readUnsignedShort();
            d.soundSampleRate = in.readFixed16D16();
            remainingEntrySize -= 38;
            if (descriptionVersion == 1) {
                d.soundSamplesPerPacket = in.readUnsignedInt();
                d.soundBytesPerPacket = in.readUnsignedInt();
                d.soundBytesPerFrame = in.readUnsignedInt();
                d.soundBytesPerSample = in.readUnsignedInt();
                remainingEntrySize -= 16;
            }
            while (remainingEntrySize > 0) {
                long atomSize = in.readUnsignedInt();
                if (atomSize < 4L) {
                    remainingEntrySize -= 4;
                    continue;
                }
                if (atomSize < 8L) {
                    in.skipBytes(atomSize - 4L);
                    remainingEntrySize = (int)((long)remainingEntrySize - atomSize);
                    continue;
                }
                String atomType = in.readType();
                System.out.println("stsd  atom:" + atomType);
                byte[] atomData = new byte[(int)(atomSize - 8L)];
                in.readFully(atomData);
                remainingEntrySize = (int)((long)remainingEntrySize - atomSize);
            }
        }
    }

    protected void parseGenericSampleDescription(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            throw new IOException("unsupported stsd version=" + version);
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        remainingSize -= 8L;
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.SampleDescription d = new QuickTimeMeta.SampleDescription();
            m.addSampleDescription(d);
            int size = in.readInt();
            remainingSize -= (long)size;
            d.dataFormat = in.readType();
            in.skipBytes(6);
            d.dataReferenceIndex = in.readUnsignedShort();
            d.extendData = new byte[size - 16];
            in.readFully(d.extendData);
        }
    }

    protected void parseVideoSampleDescription(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            throw new IOException("unsupported stsd version=" + version);
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        remainingSize -= 8L;
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.SampleDescription d = new QuickTimeMeta.SampleDescription();
            m.addSampleDescription(d);
            int size = in.readInt();
            remainingSize -= (long)size;
            d.dataFormat = in.readType();
            in.skipBytes(6);
            d.dataReferenceIndex = in.readUnsignedShort();
            int descriptionVersion = in.readUnsignedShort();
            int revisionLevel = in.readUnsignedShort();
            int vendor = in.readInt();
            float value1 = (float)in.readInt() / 1024.0f;
            d.videoTemporalQuality = Math.clamp(value1, 0.0f, 1.0f);
            float value = (float)in.readInt() / 1024.0f;
            d.videoSpatialQuality = Math.clamp(value, 0.0f, 1.0f);
            d.videoWidth = in.readUnsignedShort();
            d.videoHeight = in.readUnsignedShort();
            d.videoHorizontalResolution = in.readFixed16D16();
            d.videoVerticalResolution = in.readFixed16D16();
            long dataSize = in.readUnsignedInt();
            d.videoFrameCount = in.readUnsignedShort();
            d.videoCompressorName = in.readPString(32);
            d.videoDepth = in.readUnsignedShort();
            d.videoColorTableId = in.readShort();
            d.extendData = new byte[size - 86];
            in.readFully(d.extendData);
        }
    }

    protected void parseTimeToSample(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        m.sampleCount = 0L;
        m.timeToSamples.clear();
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.MediaSample sFirst;
            int sampleCount = in.readInt();
            int sampleDuration = in.readInt();
            m.sampleCount += (long)sampleCount;
            QuickTimeMeta.MediaSample sLast = sFirst = new QuickTimeMeta.MediaSample(sampleDuration, -1L, -1L);
            QuickTimeMeta.TimeToSampleGroup group = new QuickTimeMeta.TimeToSampleGroup(sFirst, sLast, sampleCount);
            m.timeToSamples.add(group);
        }
    }

    protected void parseSampleToChunk(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        if (remainingSize < 20L) {
            return;
        }
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        m.samplesToChunks.clear();
        for (int i = 0; i < numberOfEntries; ++i) {
            QuickTimeMeta.SampleToChunk stc = new QuickTimeMeta.SampleToChunk();
            stc.firstChunk = in.readInt();
            stc.samplesPerChunk = in.readInt();
            stc.sampleDescription = in.readInt();
            m.samplesToChunks.add(stc);
        }
    }

    protected void parseChunkOffsets(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        m.chunkOffsets.clear();
        for (int i = 0; i < numberOfEntries; ++i) {
            m.chunkOffsets.add(in.readUnsignedInt());
        }
    }

    protected void parseChunkOffsets64(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        m.chunkOffsets.clear();
        for (int i = 0; i < numberOfEntries; ++i) {
            m.chunkOffsets.add(in.readLong());
        }
    }

    protected void parseSyncSample(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        int numberOfEntries = in.readInt();
        if (numberOfEntries == 0) {
            m.syncSamples = null;
        } else {
            m.syncSamples = new TreeSet<Long>();
            for (int i = 0; i < numberOfEntries; ++i) {
                m.syncSamples.add(in.readUnsignedInt() - 1L);
            }
        }
    }

    protected void parseSampleSize(QTFFImageInputStream in, long remainingSize, QuickTimeMeta.Media m) throws IOException {
        int version = in.readUnsignedByte();
        if (version != 0) {
            return;
        }
        in.skipBytes(3);
        int sampleSize = in.readInt();
        int numberOfEntries = in.readInt();
        m.sampleSizes.clear();
        if (sampleSize != 0) {
            QuickTimeMeta.MediaSample firstSample = new QuickTimeMeta.MediaSample(-1L, -1L, sampleSize);
            QuickTimeMeta.MediaSample lastSample = new QuickTimeMeta.MediaSample(-1L, -1L, sampleSize);
            QuickTimeMeta.SampleSizeGroup ssg = new QuickTimeMeta.SampleSizeGroup(firstSample, lastSample, numberOfEntries);
            m.sampleSizes.add(ssg);
        } else {
            QuickTimeMeta.SampleSizeGroup ssg = null;
            for (int i = 0; i < numberOfEntries; ++i) {
                int size = in.readInt();
                QuickTimeMeta.MediaSample s = new QuickTimeMeta.MediaSample(-1L, -1L, size);
                if (ssg != null && ssg.maybeAddSample(s)) continue;
                ssg = new QuickTimeMeta.SampleSizeGroup(s);
                m.sampleSizes.add(ssg);
            }
        }
    }

    static {
        compositeAtoms.add("moov");
        compositeAtoms.add("cmov");
        compositeAtoms.add("gmhd");
        compositeAtoms.add("trak");
        compositeAtoms.add("tref");
        compositeAtoms.add("meta");
        compositeAtoms.add("ilst");
        compositeAtoms.add("mdia");
        compositeAtoms.add("minf");
        compositeAtoms.add("udta");
        compositeAtoms.add("stbl");
        compositeAtoms.add("dinf");
        compositeAtoms.add("edts");
        compositeAtoms.add("clip");
        compositeAtoms.add("matt");
        compositeAtoms.add("rmra");
        compositeAtoms.add("rmda");
        compositeAtoms.add("tapt");
        compositeAtoms.add("mvex");
    }

    private static class Atom {
        public long offset;
        public long size;
        public String type;
        public long headerSize;
        public byte[] data;
        public HashMap<String, Atom> children = new HashMap();

        private Atom() {
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.type);
            b.append(':');
            b.append(Long.toString(this.size));
            b.append('@');
            b.append(Long.toString(this.offset));
            return b.toString();
        }
    }
}

