/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.monte.media.av.AbstractMovie;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieReader;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;

public class QuickTimeMeta
extends AbstractMovie {
    private static final long serialVersionUID = 1L;
    public static final Locale[] LANGUAGE_CODES = new Locale[]{new Locale("en"), new Locale("fr"), new Locale("de"), new Locale("it"), new Locale("nld"), new Locale("swe"), new Locale("spa"), new Locale("dan"), new Locale("por"), new Locale("nor"), new Locale("heb"), new Locale("ja"), new Locale("ara"), new Locale("fin"), new Locale("ell"), new Locale("isl"), new Locale("mlt"), new Locale("tur"), new Locale("hrv"), new Locale("zh"), new Locale("urd"), new Locale("hin"), new Locale("tha"), new Locale("ko"), new Locale("lit"), new Locale("pol"), new Locale("hun"), new Locale("est"), new Locale("lav"), new Locale("sme"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Locale("kat"), new Locale("ron"), new Locale("kir"), new Locale("tgk"), new Locale("tuk"), new Locale("mon"), new Locale("mon"), new Locale("pus"), new Locale("kur"), new Locale("kas"), new Locale("snd"), new Locale("bod"), new Locale("npi"), new Locale("san"), new Locale("mar"), new Locale("ben"), new Locale("asm"), new Locale("guj"), new Locale("pan"), new Locale("ory"), new Locale("mal"), new Locale("kan"), new Locale("tam"), new Locale("tel"), new Locale("sin"), new Locale("mya"), new Locale("khm"), new Locale("lao"), new Locale("vie"), new Locale("ind"), new Locale("tgl"), new Locale("mal")};
    public String compressionMethod;
    public long movieDataStreamPosition = -1L;
    public long movieDataSize = -1L;
    protected Format fileFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"});
    protected String brand;
    protected int versionYear;
    protected int versionMonth;
    protected int versionMinor;
    protected ArrayList<String> compatibleBrands = new ArrayList();
    protected Date creationTime;
    protected Date modificationTime;
    protected long timeScale;
    protected long duration;
    protected double preferredRate;
    protected double preferredVolume;
    protected double[] matrix;
    protected long previewTime;
    protected long previewDuration;
    protected long posterTime;
    protected long selectionTime;
    protected long selectionDuration;
    protected long currentTime;
    protected long nextTrackId;
    protected ArrayList<Track> tracks = new ArrayList();

    public QuickTimeMeta() {
        this.clear();
    }

    private void deriveTrackFormat(int trackIndex) {
        Track track = this.tracks.get(trackIndex);
        Format format = new Format(new Object[]{FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.MediaTypeKey, track.mediaType, FormatKeys.EncodingKey, track.encoding});
        if (track.media == null) {
            throw new UnsupportedOperationException("not implemented for tracks without media. " + trackIndex + " " + String.valueOf((Object)track.mediaType) + " " + String.valueOf(track.media));
        }
        Media m = track.media;
        switch (track.mediaType) {
            case VIDEO: {
                if (m.sampleDescriptions.size() != 1) {
                    throw new UnsupportedOperationException("not implemented for media with multiple sample descriptions.. " + trackIndex + " " + String.valueOf((Object)track.mediaType) + " " + String.valueOf(m) + " " + String.valueOf(m.sampleDescriptions));
                }
                SampleDescription desc = m.sampleDescriptions.get(0);
                format = format.append(FormatKeys.SampleFormatKey, desc.dataFormat, VideoFormatKeys.CompressorNameKey, desc.videoCompressorName, VideoFormatKeys.HeightKey, desc.videoHeight, VideoFormatKeys.WidthKey, desc.videoWidth, VideoFormatKeys.DepthKey, desc.videoDepth);
                if (m.timeToSamples.size() == 1) {
                    TimeToSampleGroup ttsg = m.timeToSamples.get(0);
                    format = format.append(FormatKeys.FrameRateKey, new Rational(ttsg.getSampleDuration(), m.mediaTimeScale));
                    break;
                }
                format = format.append(FormatKeys.FrameRateKey, new Rational(1L, m.mediaTimeScale));
                break;
            }
            default: {
                if (m.sampleDescriptions.size() != 1) {
                    throw new UnsupportedOperationException("not implemented for media with multiple sample descriptions.. " + trackIndex + " " + String.valueOf((Object)track.mediaType) + " " + String.valueOf(m) + " " + String.valueOf(m.sampleDescriptions));
                }
                SampleDescription desc = m.sampleDescriptions.get(0);
                format = format.append(FormatKeys.SampleFormatKey, desc.dataFormat);
                break;
            }
        }
        track.format = format;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(Date modificationTime) {
        this.modificationTime = modificationTime;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(long movieTimeScale) {
        this.timeScale = movieTimeScale;
    }

    public double getPreferredRate() {
        return this.preferredRate;
    }

    public void setPreferredRate(double preferredRate) {
        this.preferredRate = preferredRate;
    }

    public double getPreferredVolume() {
        return this.preferredVolume;
    }

    public void setPreferredVolume(double preferredVolume) {
        this.preferredVolume = preferredVolume;
    }

    public long getPreviewTime() {
        return this.previewTime;
    }

    public void setPreviewTime(long previewTime) {
        this.previewTime = previewTime;
    }

    public long getPreviewDuration() {
        return this.previewDuration;
    }

    public void setPreviewDuration(long previewDuration) {
        this.previewDuration = previewDuration;
    }

    public long getPosterTime() {
        return this.posterTime;
    }

    public void setPosterTime(long posterTime) {
        this.posterTime = posterTime;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setSelectionTime(long selectionTime) {
        this.selectionTime = selectionTime;
    }

    public long getSelectionDuration() {
        return this.selectionDuration;
    }

    public void setSelectionDuration(long selectionDuration) {
        this.selectionDuration = selectionDuration;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }

    public void setNextTrackId(long nextTrackId) {
        this.nextTrackId = nextTrackId;
    }

    @Override
    public Rational getDuration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long timeToSample(int track, Rational seconds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational sampleToTime(int track, long sample) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public Format getFormat(int track) {
        if (this.tracks.get((int)track).format == null) {
            this.deriveTrackFormat(track);
        }
        return this.tracks.get((int)track).format;
    }

    @Override
    public Format getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public MovieReader getReader() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void clear() {
        this.brand = "qt";
        this.versionMinor = 0;
        this.versionMonth = 0;
        this.versionYear = 0;
        this.compatibleBrands.clear();
        this.compatibleBrands.add(this.brand);
        this.creationTime = this.modificationTime = new Date();
        this.timeScale = 600L;
        this.duration = 0L;
        this.preferredRate = 1.0;
        this.preferredVolume = 1.0;
        this.previewTime = 0L;
        this.previewDuration = 0L;
        this.posterTime = 0L;
        this.selectionTime = 0L;
        this.selectionDuration = 0L;
        this.currentTime = 0L;
        this.nextTrackId = 0L;
        this.matrix = new double[9];
        this.tracks.clear();
    }

    public double[] getTransformationMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("QuickTimeMovie{ fileFormat=" + String.valueOf(this.fileFormat) + "\nftyp: brand=" + this.brand + ", versionYear=" + this.versionYear + ", versionMonth=" + this.versionMonth + ", versionMinor=" + this.versionMinor + ", compatibleBrands=" + String.valueOf(this.compatibleBrands) + "\nmvhd: creationTime=" + String.valueOf(this.creationTime) + ", modificationTime=" + String.valueOf(this.modificationTime) + ", timeScale=" + this.timeScale + ", duration=" + this.duration + ", preferredRate=" + this.preferredRate + ", preferredVolume=" + this.preferredVolume + ", matrix=" + Arrays.toString(this.matrix) + ", previewTime=" + this.previewTime + ", previewDuration=" + this.previewDuration + ", posterTime=" + this.posterTime + ", selectionTime=" + this.selectionTime + ", selectionDuration=" + this.selectionDuration + ", currentTime=" + this.currentTime + ", nextTrackId=" + this.nextTrackId);
        for (Track t : this.tracks) {
            buf.append("\ntrak: ");
            buf.append(t.toString());
        }
        buf.append('}');
        return buf.toString();
    }

    protected static class Track {
        public NavigableMap<Long, ArrayList<TrackSample>> trackSampleMap = null;
        public ArrayList<TrackSample> trackSamplesList = null;
        public int readIndex;
        protected FormatKeys.MediaType mediaType;
        protected String encoding;
        protected Format format;
        private static final int TrackEnable = 1;
        private static final int TrackInMovie = 2;
        private static final int TrackInPreview = 4;
        private static final int TrackInPoster = 8;
        protected int headerFlags = 15;
        protected Date creationTime;
        protected Date modificationTime;
        protected int trackId;
        protected long duration;
        protected int layer;
        protected int alternateGroup;
        protected double volume;
        protected double[] matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        protected double width;
        protected double height;
        protected ArrayList<Edit> editList = new ArrayList();
        public Media media = null;

        protected Track() {
        }

        public void setEnabled(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 1 : this.headerFlags & 0xFE;
        }

        public boolean isEnabled() {
            return (this.headerFlags & 1) != 0;
        }

        public void setInMovie(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 2 : this.headerFlags & 0xFD;
        }

        public boolean isInMovie() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPreview(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 4 : this.headerFlags & 0xFB;
        }

        public boolean isInPreview() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPoster(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 8 : this.headerFlags & 0xF7;
        }

        public boolean isInPoster() {
            return (this.headerFlags & 8) != 0;
        }

        public long getTrackDuration(long movieTimeScale) {
            long sum = 0L;
            if (this.editList.isEmpty()) {
                Media m = this.media;
                sum += m.mediaDuration * movieTimeScale / m.mediaTimeScale;
            } else {
                for (Edit e : this.editList) {
                    sum += e.trackDuration;
                }
            }
            return sum;
        }

        public void buildSamplesTable(long movieTimeScale) throws IOException {
            this.buildMediaSamplesTable(movieTimeScale);
            this.buildTrackSamplesTable(movieTimeScale);
        }

        public void buildTrackSamplesTable(long movieTimeScale) throws IOException {
            NavigableMap<Long, ArrayList<MediaSample>> mediaSamplesMap;
            this.trackSampleMap = new TreeMap<Long, ArrayList<TrackSample>>();
            this.trackSamplesList = new ArrayList();
            NavigableMap<Long, ArrayList<MediaSample>> navigableMap = mediaSamplesMap = this.media == null ? null : this.media.mediaSamples;
            if (mediaSamplesMap == null) {
                throw new IOException("track " + this.trackId + ": 'mdia' atom does not exist or is incomplete");
            }
            long mediaTimeScale = this.media.mediaTimeScale;
            if (this.editList.isEmpty()) {
                this.editList.add(new Edit(this.duration, 0, 1.0));
            }
            long editTrackTime = 0L;
            for (Edit edit : this.editList) {
                if (edit.mediaTime == -1L) {
                    editTrackTime += edit.trackDuration;
                    continue;
                }
                double mediaRate = edit.mediaRate;
                long editMediaEndTime = (long)((double)edit.mediaTime + (double)edit.trackDuration * mediaRate * (double)mediaTimeScale / (double)movieTimeScale);
                long sampleTrackTime = editTrackTime;
                double invMediaRate = 1.0 / edit.mediaRate;
                long mediaDuration = (long)((double)edit.trackDuration * mediaRate * (double)mediaTimeScale / (double)movieTimeScale);
                Long floorKey = mediaSamplesMap.floorKey(edit.mediaTime);
                Long l = floorKey = this.media.syncSamples == null ? floorKey : this.media.syncSamples.floor(floorKey);
                if (floorKey == null) {
                    editTrackTime += edit.trackDuration;
                    continue;
                }
                for (Map.Entry<Long, ArrayList<MediaSample>> entry : mediaSamplesMap.subMap(floorKey, edit.mediaTime + mediaDuration).entrySet()) {
                    ArrayList<MediaSample> mediaSamples = entry.getValue();
                    if (mediaSamples.isEmpty()) continue;
                    long mediaSampleTime = entry.getKey();
                    MediaSample lastMediaSample = mediaSamples.get(mediaSamples.size() - 1);
                    long mediaSampleDuration = lastMediaSample.duration;
                    long cutStart = Math.max(0L, mediaSampleTime + mediaSampleDuration - editMediaEndTime);
                    long cutEnd = Math.max(0L, edit.mediaTime - mediaSampleTime);
                    mediaSampleDuration = Math.max(0L, mediaSampleDuration - cutStart + cutEnd);
                    long trackSampleDuration = Math.max(0L, (long)((double)mediaSampleDuration * invMediaRate * (double)movieTimeScale / (double)mediaTimeScale));
                    int n = mediaSamples.size();
                    for (int i = 0; i < n - 1; ++i) {
                        TrackSample trackSample = new TrackSample(mediaSamples.get(i), sampleTrackTime, 0L, 0L, 0L);
                        this.trackSampleMap.computeIfAbsent(sampleTrackTime, k -> new ArrayList()).add(trackSample);
                        this.trackSamplesList.add(trackSample);
                    }
                    TrackSample trackSample = new TrackSample(lastMediaSample, sampleTrackTime, this.duration, cutStart, mediaSampleDuration);
                    this.trackSampleMap.computeIfAbsent(sampleTrackTime, k -> new ArrayList()).add(trackSample);
                    this.trackSamplesList.add(trackSample);
                    sampleTrackTime += trackSampleDuration;
                }
                editTrackTime += edit.trackDuration;
            }
        }

        public void buildMediaSamplesTable(long movieTimeScale) throws IOException {
            Media m = this.media;
            m.mediaSamples = new TreeMap<Long, ArrayList<MediaSample>>();
            if (m.sampleSizes.isEmpty()) {
                throw new IOException("track " + this.trackId + ": 'mdia' atom does not contain an 'stsz' atom.");
            }
            if (m.samplesToChunks.isEmpty()) {
                throw new IOException("track " + this.trackId + ": 'mdia' atom does not contain an 'stsc' atom.");
            }
            if (m.timeToSamples.isEmpty()) {
                throw new IOException("track " + this.trackId + ": 'mdia' atom does not contain an 'stts' atom.");
            }
            if (m.chunkOffsets.isEmpty()) {
                throw new IOException("track " + this.trackId + ": 'mdia' atom does neither contain an 'stco' nor an 'co64' atom.");
            }
            TreeMap<Integer, SampleSizeGroup> sampleSizeMap = new TreeMap<Integer, SampleSizeGroup>();
            int sampleIndex = 0;
            for (SampleSizeGroup ssg : m.sampleSizes) {
                sampleSizeMap.put(sampleIndex, ssg);
                sampleIndex = (int)((long)sampleIndex + ssg.sampleCount);
            }
            TreeMap<Integer, SampleToChunk> sampleChunkMap = new TreeMap<Integer, SampleToChunk>();
            sampleIndex = 0;
            int prevFirstChunk = 1;
            int prevSamplesPerChunk = 0;
            for (SampleToChunk stc : m.samplesToChunks) {
                sampleChunkMap.put(sampleIndex += (stc.firstChunk - prevFirstChunk) * prevSamplesPerChunk, stc);
                prevFirstChunk = stc.firstChunk;
                prevSamplesPerChunk = stc.samplesPerChunk;
            }
            sampleIndex = 0;
            long time = 0L;
            int firstChunkId = -1;
            int chunkId = -1;
            int remainingSamplesInChunk = 0;
            long offset = -1L;
            for (TimeToSampleGroup tsg : m.timeToSamples) {
                long duration = tsg.getSampleDuration();
                int i = 0;
                while ((long)i < tsg.sampleCount) {
                    long length;
                    Map.Entry sizeEntry = sampleSizeMap.floorEntry(sampleIndex);
                    long l = length = sizeEntry == null ? -1L : ((SampleSizeGroup)sizeEntry.getValue()).getSampleLength();
                    if (remainingSamplesInChunk == 0) {
                        Map.Entry chunkEntry = sampleChunkMap.floorEntry(sampleIndex);
                        if (chunkEntry == null) {
                            throw new IOException("track " + this.trackId + ": 'stsc' atom does not contain required chunk entry");
                        }
                        SampleToChunk stsc = (SampleToChunk)chunkEntry.getValue();
                        if (stsc.firstChunk != firstChunkId) {
                            firstChunkId = stsc.firstChunk;
                            chunkId = stsc.firstChunk;
                        } else {
                            ++chunkId;
                        }
                        remainingSamplesInChunk = stsc.samplesPerChunk;
                        if (chunkId < 0 || chunkId > m.chunkOffsets.size()) {
                            throw new IOException("track " + this.trackId + ": 'stco' or 'co64' atom does not contain an entry for chunkId=" + chunkId);
                        }
                        offset = m.chunkOffsets.get(chunkId - 1);
                    }
                    MediaSample sample = new MediaSample(duration, offset, length);
                    sample.timeStamp = time;
                    sample.isKeyframe = m.syncSamples == null || m.syncSamples.contains(sampleIndex + 1);
                    m.mediaSamples.computeIfAbsent(time, k -> new ArrayList(1)).add(sample);
                    time += duration;
                    --remainingSamplesInChunk;
                    offset += length;
                    ++sampleIndex;
                    ++i;
                }
                time += duration;
            }
        }

        public String toString() {
            return "Track{ format=" + String.valueOf(this.format) + "\ntkhd: creationTime=" + String.valueOf(this.creationTime) + ", modificationTime=" + String.valueOf(this.modificationTime) + ", trackId=" + this.trackId + ", duration=" + this.duration + ", layer=" + this.layer + ", alternateGroup=" + this.alternateGroup + ", volume=" + this.volume + ", matrix=" + Arrays.toString(this.matrix) + ", width=" + this.width + ", height=" + this.height + "\nelst: editList=" + String.valueOf(this.editList) + "\nmdia: media=" + String.valueOf(this.media) + "}";
        }
    }

    protected static class Media {
        protected Date mediaCreationTime;
        protected Date mediaModificationTime;
        protected long mediaTimeScale = 600L;
        protected long mediaDuration = 0L;
        protected Locale mediaLanguage = Locale.ENGLISH;
        protected String mediaLanguageEncoding = "UTF-8";
        protected int mediaQuality;
        protected double soundBalance;
        protected ArrayList<DataReference> dataReferenceList = new ArrayList();
        protected ArrayList<Long> chunkOffsets = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleToChunk> samplesToChunks = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected NavigableSet<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected int syncInterval;
        protected float videoQuality = 0.97f;
        protected IndexColorModel videoColorTable;
        boolean videoFlagNoLeanAhead;
        int graphicsMode;
        int[] opcolor = new int[3];
        private ArrayList<SampleDescription> sampleDescriptions = new ArrayList();
        public NavigableMap<Long, ArrayList<MediaSample>> mediaSamples = null;

        protected Media() {
        }

        public void addSampleDescription(SampleDescription d) {
            this.sampleDescriptions.add(d);
        }

        public boolean isEmpty() {
            return this.sampleCount == 0L;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public String toString() {
            return "Media{mediaCreationTime=" + String.valueOf(this.mediaCreationTime) + ", mediaModificationTime=" + String.valueOf(this.mediaModificationTime) + ", mediaTimeScale=" + this.mediaTimeScale + ", mediaDuration=" + this.mediaDuration + ", mediaLanguage=" + String.valueOf(this.mediaLanguage) + ", mediaQuality=" + this.mediaQuality + ", videoColorTable=" + String.valueOf(this.videoColorTable) + ", soundBalance=" + this.soundBalance + ", dataReferenceList=" + String.valueOf(this.dataReferenceList) + ", chunks=" + String.valueOf(this.chunkOffsets) + ", timeToSamples=" + String.valueOf(this.timeToSamples) + ", sampleSizes=" + String.valueOf(this.sampleSizes) + ", syncSamples=" + String.valueOf(this.syncSamples) + ", sampleCount=" + this.sampleCount + ", syncInterval=" + this.syncInterval + ", videoQuality=" + this.videoQuality + ", videoColorTable=" + String.valueOf(this.videoColorTable) + "}";
        }
    }

    protected static class SampleDescription {
        protected String dataFormat;
        protected int dataReferenceIndex;
        protected float videoTemporalQuality;
        protected float videoSpatialQuality;
        protected int videoWidth;
        protected int videoHeight;
        protected double videoHorizontalResolution = 72.0;
        protected double videoVerticalResolution = 72.0;
        protected int videoFrameCount;
        protected String videoCompressorName;
        protected int videoDepth = -1;
        protected int videoColorTableId = -1;
        protected byte[] extendData;
        protected int soundNumberOfChannels;
        protected int soundSampleSize;
        protected int soundCompressionId;
        protected long soundSamplesPerPacket;
        protected long soundBytesPerPacket;
        protected long soundBytesPerFrame;
        protected long soundBytesPerSample;
        protected double soundSampleRate;
        protected byte[] stsdExtensions = new byte[0];

        protected SampleDescription() {
        }

        public String toString() {
            return "SampleDescription{, videoDepth=" + this.videoDepth + ", soundNumberOfChannels=" + this.soundNumberOfChannels + ", soundSampleSize=" + this.soundSampleSize + ", soundCompressionId=" + this.soundCompressionId + ", soundSamplesPerPacket=" + this.soundSamplesPerPacket + ", soundBytesPerPacket=" + this.soundBytesPerPacket + ", soundBytesPerFrame=" + this.soundBytesPerFrame + ", soundBytesPerSample=" + this.soundBytesPerSample + ", soundSampleRate=" + this.soundSampleRate + ", stsdExtensions=" + String.valueOf(this.stsdExtensions) + "}";
        }
    }

    protected static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(MediaSample firstSample) {
            super(firstSample);
        }

        protected TimeToSampleGroup(MediaSample firstSample, MediaSample lastSample, long sampleCount) {
            super(firstSample, lastSample, sampleCount);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(MediaSample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    public static class DataReference {
        protected String referenceType;
        private static final int DataRefSelfReference = 1;
        protected int referenceFlags = 1;
        protected byte[] data;

        public String toString() {
            return "DataReference{referenceType=" + this.referenceType + ", referenceFlags=" + this.referenceFlags + ", data=" + String.valueOf(this.data) + "}";
        }
    }

    public static class Edit {
        public long trackDuration;
        public long mediaTime;
        public double mediaRate;

        public Edit(long trackDuration, int mediaTime, double mediaRate) {
            if (trackDuration < 0L) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
        }

        public String toString() {
            return "Edit{trackDuration=" + this.trackDuration + ", mediaTime=" + this.mediaTime + ", mediaRate=" + this.mediaRate + "}";
        }
    }

    protected static class Chunk
    extends Group {
        protected int sampleDescriptionId;

        public Chunk(MediaSample firstSample, int sampleDescriptionId) {
            super(firstSample);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public Chunk(MediaSample firstSample, MediaSample lastSample, int sampleCount, int sampleDescriptionId) {
            super(firstSample, lastSample, sampleCount);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public boolean maybeAddSample(MediaSample sample, int sampleDescriptionId) {
            if (sampleDescriptionId == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    protected static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(MediaSample firstSample) {
            super(firstSample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        public SampleSizeGroup(MediaSample firstSample, MediaSample lastSample, long sampleCount) {
            super(firstSample, lastSample, sampleCount);
        }

        @Override
        public boolean maybeAddSample(MediaSample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    protected static class SampleToChunk {
        int firstChunk;
        int samplesPerChunk;
        int sampleDescription;

        protected SampleToChunk() {
        }
    }

    protected static class TrackSample {
        MediaSample mediaSample;
        public long timeStamp;
        long duration;
        long startTimeInMediaSample;
        long endTimeInMediaSample;

        public TrackSample(MediaSample mediaSample, long timeStamp, long duration, long startTimeInMediaSample, long endTimeInMediaSample) {
            this.mediaSample = mediaSample;
            this.timeStamp = timeStamp;
            this.duration = duration;
            this.startTimeInMediaSample = startTimeInMediaSample;
            this.endTimeInMediaSample = endTimeInMediaSample;
        }
    }

    protected static class MediaSample {
        long offset;
        long length;
        long duration;
        public long timeStamp = -1L;
        public boolean isKeyframe;

        public MediaSample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    protected static abstract class Group {
        protected MediaSample firstSample;
        protected MediaSample lastSample;
        protected long sampleCount;
        protected static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(MediaSample firstSample) {
            this.firstSample = this.lastSample = firstSample;
            this.sampleCount = firstSample == null ? 0L : 1L;
        }

        protected Group(MediaSample firstSample, MediaSample lastSample, long sampleCount) {
            this.firstSample = firstSample;
            this.lastSample = lastSample;
            this.sampleCount = sampleCount;
            if (sampleCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(MediaSample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }
}

