/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioFormat;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.DataAtomOutputStream;
import org.monte.media.quicktime.QuickTimeOutputStream;

public class QuickTimeWriter
implements MovieWriter {
    public static final Format QUICKTIME = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"});
    public static final Format VIDEO_RAW = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_ANIMATION = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "Animation"});
    public static final Format VIDEO_JPEG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "Photo - JPEG"});
    public static final Format VIDEO_PNG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "png ", VideoFormatKeys.CompressorNameKey, "PNG"});
    private final QuickTimeOutputStream out;

    public QuickTimeWriter(File file) throws IOException {
        this.out = new QuickTimeOutputStream(file);
    }

    public QuickTimeWriter(ImageOutputStream out) throws IOException {
        this.out = new QuickTimeOutputStream(out);
    }

    @Override
    public Format getFileFormat() throws IOException {
        return QUICKTIME;
    }

    @Override
    public Format getFormat(int track) {
        return ((AbstractQuickTimeStream.Track)this.out.tracks.get((int)track)).format;
    }

    @Override
    public int addTrack(Format fmt) throws IOException {
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            int t = this.out.addVideoTrack(fmt.get(FormatKeys.EncodingKey), fmt.get(VideoFormatKeys.CompressorNameKey, fmt.get(FormatKeys.EncodingKey)), Math.min(6000L, fmt.get(FormatKeys.FrameRateKey).getNumerator() * fmt.get(FormatKeys.FrameRateKey).getDenominator()), fmt.get(VideoFormatKeys.WidthKey), fmt.get(VideoFormatKeys.HeightKey), fmt.get(VideoFormatKeys.DepthKey), (int)fmt.get(FormatKeys.FrameRateKey).getDenominator());
            this.out.setCompressionQuality(t, fmt.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue());
            return t;
        }
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.AUDIO) {
            int sampleSizeInBits = fmt.get(AudioFormatKeys.SampleSizeInBitsKey, 16);
            ByteOrder bo = fmt.get(AudioFormatKeys.ByteOrderKey, ByteOrder.BIG_ENDIAN);
            boolean signed = fmt.get(AudioFormatKeys.SignedKey, true);
            String encoding = fmt.get(FormatKeys.EncodingKey, null);
            Rational frameRate = fmt.get(FormatKeys.FrameRateKey, fmt.get(AudioFormatKeys.SampleRateKey));
            int channels = fmt.get(AudioFormatKeys.ChannelsKey, 1);
            int frameSize = fmt.get(AudioFormatKeys.FrameSizeKey, (sampleSizeInBits + 7) / 8 * sampleSizeInBits);
            if (encoding == null || encoding.length() != 4) {
                encoding = signed ? (bo == ByteOrder.BIG_ENDIAN ? "twos" : "sowt") : "raw ";
            }
            return this.out.addAudioTrack(encoding, fmt.get(AudioFormatKeys.SampleRateKey).longValue(), fmt.get(AudioFormatKeys.SampleRateKey).doubleValue(), channels, sampleSizeInBits, false, fmt.get(AudioFormatKeys.SampleRateKey).divide(frameRate).intValue(), frameSize, signed, bo);
        }
        throw new IOException("Unsupported media type:" + String.valueOf((Object)fmt.get(FormatKeys.MediaTypeKey)));
    }

    public int addVideoTrack(Format format, long timeScale, int width, int height) throws IOException {
        return this.out.addVideoTrack(format.get(FormatKeys.EncodingKey), format.get(VideoFormatKeys.CompressorNameKey), timeScale, width, height, 24, 30);
    }

    public int addVideoTrack(Format format, int width, int height, int depth, int syncInterval) throws IOException {
        return this.out.addVideoTrack(format.get(FormatKeys.EncodingKey), format.get(VideoFormatKeys.CompressorNameKey), format.get(FormatKeys.FrameRateKey).getDenominator() * format.get(FormatKeys.FrameRateKey).getNumerator(), width, height, depth, syncInterval);
    }

    public int addAudioTrack(AudioFormat format) throws IOException {
        String qtAudioFormat;
        this.out.ensureStarted();
        double sampleRate = format.getSampleRate();
        long timeScale = (int)Math.floor(sampleRate);
        int sampleSizeInBits = format.getSampleSizeInBits();
        int numberOfChannels = format.getChannels();
        ByteOrder byteOrder = format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int frameDuration = (int)(format.getSampleRate() / format.getFrameRate());
        int frameSize = format.getFrameSize();
        boolean isCompressed = format.getProperty("vbr") != null && (Boolean)format.getProperty("vbr") != false;
        boolean signed = false;
        AudioFormat.Encoding enc = format.getEncoding();
        if (enc.equals(AudioFormat.Encoding.ALAW)) {
            qtAudioFormat = "alaw";
            if (sampleSizeInBits != 8) {
                throw new IllegalArgumentException("Sample size of 8 for ALAW required:" + sampleSizeInBits);
            }
        } else if (AudioFormat.Encoding.PCM_SIGNED.equals(enc)) {
            qtAudioFormat = switch (sampleSizeInBits) {
                case 8 -> "raw ";
                case 16 -> {
                    if (byteOrder == ByteOrder.BIG_ENDIAN) {
                        yield "twos";
                    }
                    yield "sowt";
                }
                case 24 -> "in24";
                case 32 -> "in32";
                default -> throw new IllegalArgumentException("Unsupported sample size for PCM_SIGNED:" + sampleSizeInBits);
            };
        } else if (AudioFormat.Encoding.PCM_UNSIGNED.equals(enc)) {
            qtAudioFormat = switch (sampleSizeInBits) {
                case 8 -> "raw ";
                case 16 -> {
                    if (byteOrder == ByteOrder.BIG_ENDIAN) {
                        yield "twos";
                    }
                    yield "sowt";
                }
                case 24 -> "in24";
                case 32 -> "in32";
                default -> throw new IllegalArgumentException("Unsupported sample size for PCM_UNSIGNED:" + sampleSizeInBits);
            };
        } else if (AudioFormat.Encoding.ULAW.equals(enc)) {
            if (sampleSizeInBits != 8) {
                throw new IllegalArgumentException("Sample size of 8 for ULAW required:" + sampleSizeInBits);
            }
            qtAudioFormat = "ulaw";
        } else if ("MP3".equals(enc.toString())) {
            qtAudioFormat = ".mp3";
        } else {
            qtAudioFormat = format.getEncoding().toString();
            if (qtAudioFormat == null || qtAudioFormat.length() != 4) {
                throw new IllegalArgumentException("Unsupported encoding:" + String.valueOf(format.getEncoding()));
            }
        }
        return this.out.addAudioTrack(qtAudioFormat, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize, signed, byteOrder);
    }

    @Override
    public int getTrackCount() {
        return this.out.tracks.size();
    }

    @Override
    public Rational getDuration(int track) {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.out.tracks.get(track);
        return new Rational(tr.mediaDuration, tr.mediaTimeScale);
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getEncoder(fmt.prepend(FormatKeys.MimeTypeKey, "video/quicktime"));
    }

    private void createCodec(int track) {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.out.tracks.get(track);
        Format fmt = tr.format;
        tr.codec = this.createCodec(fmt);
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (tr.codec != null) {
            if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
                Format vf = fmt;
                tr.codec.setInputFormat(fmt.prepend(FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class));
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.QualityKey, Float.valueOf(this.out.getCompressionQuality(track)), FormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Input format not supported:" + String.valueOf(fmt));
                }
            } else {
                Format vf = fmt;
                tr.codec.setInputFormat(fmt.prepend(FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, fmt.containsKey(AudioFormatKeys.SignedKey) && fmt.get(AudioFormatKeys.SignedKey) != false ? AudioFormatKeys.ENCODING_PCM_SIGNED : AudioFormatKeys.ENCODING_PCM_UNSIGNED, VideoFormatKeys.DataClassKey, byte[].class));
                if (tr.codec.setOutputFormat(fmt) == null) {
                    throw new UnsupportedOperationException("Codec output format not supported:" + String.valueOf(fmt) + " codec:" + String.valueOf(tr.codec));
                }
                tr.format = tr.codec.getOutputFormat();
            }
        }
    }

    public Codec getCodec(int track) {
        return ((AbstractQuickTimeStream.Track)this.out.tracks.get((int)track)).codec;
    }

    public void setCodec(int track, Codec codec) {
        ((AbstractQuickTimeStream.Track)this.out.tracks.get((int)track)).codec = codec;
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        Rational exactSampleDuration;
        Rational sampleDuration;
        Buffer outBuf;
        this.out.ensureStarted();
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.out.tracks.get(track);
        if (tr.outputBuffer == null) {
            tr.outputBuffer = new Buffer();
            tr.outputBuffer.format = tr.format;
        }
        if (tr.format.matchesWithout(buf.format, FormatKeys.FrameRateKey)) {
            outBuf = buf;
        } else {
            outBuf = tr.outputBuffer;
            boolean isSync = tr.syncInterval == 0 ? false : tr.sampleCount % (long)tr.syncInterval == 0L;
            buf.setFlag(BufferFlag.KEYFRAME, isSync);
            if (tr.codec == null) {
                this.createCodec(track);
                if (tr.codec == null) {
                    throw new UnsupportedOperationException("No codec for this format " + String.valueOf(tr.format));
                }
            }
            tr.codec.process(buf, outBuf);
        }
        if (outBuf.isFlag(BufferFlag.DISCARD) || outBuf.sampleCount == 0) {
            return;
        }
        if (tr.inputTime == null) {
            tr.inputTime = buf.timeStamp;
            tr.writeTime = buf.timeStamp;
        }
        if ((sampleDuration = (exactSampleDuration = outBuf.sampleDuration.multiply(outBuf.sampleCount)).floor(tr.mediaTimeScale)).compareTo(new Rational(0L, 1L)) <= 0) {
            sampleDuration = new Rational(1L, tr.mediaTimeScale);
        }
        tr.writeTime = tr.writeTime.add(sampleDuration);
        long sampleDurationInMediaTS = sampleDuration.getNumerator() * (tr.mediaTimeScale / sampleDuration.getDenominator());
        this.out.writeSamples(track, buf.sampleCount, (byte[])outBuf.data, outBuf.offset, outBuf.length, sampleDurationInMediaTS / (long)buf.sampleCount, outBuf.isFlag(BufferFlag.KEYFRAME));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration must be greater 0.");
        }
        AbstractQuickTimeStream.VideoTrack vt = (AbstractQuickTimeStream.VideoTrack)this.out.tracks.get(track);
        if (vt.mediaType != FormatKeys.MediaType.VIDEO) {
            throw new IllegalArgumentException("Track " + track + " is not a video track");
        }
        if (vt.codec == null) {
            this.createCodec(track);
        }
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this format: " + String.valueOf(vt.format));
        }
        this.out.ensureStarted();
        if (vt.width == -1.0) {
            vt.width = image.getWidth();
            vt.height = image.getHeight();
        } else if (vt.width != (double)image.getWidth() || vt.height != (double)image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of frame[" + ((AbstractQuickTimeStream.Track)this.out.tracks.get(track)).getSampleCount() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video dimension (width=" + vt.width + ", height=" + vt.height + ") in track " + track + ".");
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isSync = vt.syncInterval == 0 ? false : vt.sampleCount % (long)vt.syncInterval == 0L;
        Buffer inputBuffer = new Buffer();
        inputBuffer.setFlag(BufferFlag.KEYFRAME, isSync);
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.isFlag(BufferFlag.DISCARD)) {
            return;
        }
        isSync = vt.outputBuffer.isFlag(BufferFlag.KEYFRAME);
        long offset = this.out.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.out.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write((byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length);
        long length = this.out.getRelativeStreamPosition() - offset;
        vt.addSample(new AbstractQuickTimeStream.Sample(duration, offset, length), 1, isSync);
    }

    @Deprecated
    public void write(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.out.writeSamples(track, 1, data, off, len, duration, isSync);
    }

    @Deprecated
    public void write(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.out.tracks.get(track);
        if (tr.codec == null) {
            this.out.writeSamples(track, sampleCount, data, off, len, sampleDuration, isSync);
        } else {
            if (tr.outputBuffer == null) {
                tr.outputBuffer = new Buffer();
            }
            if (tr.inputBuffer == null) {
                tr.inputBuffer = new Buffer();
            }
            Buffer outb = tr.outputBuffer;
            Buffer inb = tr.inputBuffer;
            inb.data = data;
            inb.offset = off;
            inb.length = len;
            inb.sampleDuration = new Rational(sampleDuration, tr.mediaTimeScale);
            inb.sampleCount = sampleCount;
            inb.setFlag(BufferFlag.KEYFRAME, isSync);
            tr.codec.process(inb, outb);
            if (!outb.isFlag(BufferFlag.DISCARD)) {
                this.out.writeSample(track, (byte[])outb.data, outb.offset, outb.length, outb.sampleCount, outb.isFlag(BufferFlag.KEYFRAME));
            }
        }
    }

    public boolean isVFRSupported() {
        return true;
    }

    @Override
    public boolean isDataLimitReached() {
        return this.out.isDataLimitReached();
    }

    @Override
    public boolean isEmpty(int track) {
        return ((AbstractQuickTimeStream.Track)this.out.tracks.get(track)).isEmpty();
    }

    public void setVideoColorTable(int track, ColorModel icm) {
        this.out.setVideoColorTable(track, icm);
    }

    public void setMovieTimeScale(long timeScale) {
        this.out.setMovieTimeScale(timeScale);
    }

    public void finish() throws IOException {
        this.out.finish();
    }

    public void setSyncInterval(int track, int i) {
        this.out.setSyncInterval(track, i);
    }

    public void writeSample(int track, File file, long duration, boolean isSync) throws IOException {
        this.out.writeSample(track, file, duration, isSync);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration) throws IOException {
        this.out.writeSamples(track, sampleCount, data, off, len, sampleDuration);
    }

    public void toWebOptimizedMovie(File outputFile, boolean compressHeader) throws IOException {
        this.out.toWebOptimizedMovie(outputFile, compressHeader);
    }

    public long getMediaTimeScale(int track) {
        return this.out.getMediaTimeScale(track);
    }

    public void setCompressionQuality(int track, float newValue) {
        this.out.setCompressionQuality(track, newValue);
    }

    public long getMovieTimeScale() {
        return this.out.getMovieTimeScale();
    }

    public long getTrackDuration(int track) {
        return this.out.getTrackDuration(track);
    }

    public void setEditList(int track, AbstractQuickTimeStream.Edit[] editList) {
        this.out.setEditList(track, editList);
    }
}

