/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text;

import java.io.IOException;
import java.nio.ByteOrder;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.text.AbstractTextCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.quicktime.QTFFImageInputStream;
import org.monte.media.quicktime.codec.text.cta608.Cta608Parser;
import org.monte.media.quicktime.codec.text.cta708.Cta708Parser;

public class AppleClosedCaptionCodec
extends AbstractTextCodec {
    public AppleClosedCaptionCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.TEXT, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "clcp", VideoFormatKeys.DataClassKey, byte[].class})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.TEXT, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "String", VideoFormatKeys.DataClassKey, String.class})});
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if ("String".equals(this.outputFormat.get(FormatKeys.EncodingKey))) {
            return this.decode(in, out);
        }
        return this.encode(in, out);
    }

    public int decode(Buffer in, Buffer out) {
        byte[] data;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        byte[] byArray = data = in.data instanceof byte[] ? (byte[])in.data : null;
        if (data == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        try {
            ByteArrayImageInputStream iis = new ByteArrayImageInputStream(data, in.offset, in.length, ByteOrder.BIG_ENDIAN);
            QTFFImageInputStream qtin = new QTFFImageInputStream(iis);
            long size = qtin.readUnsignedInt();
            String type = qtin.readType();
            if (size > (long)in.length) {
                throw new IOException("Chunk is bigger than buffer. chunk=" + type + ", size=" + size + ", buffer length " + in.length);
            }
            switch (type) {
                case "cdat": {
                    String text = new Cta608Parser().parseToStringWithOpCodes(iis);
                    out.data = text;
                    break;
                }
                case "ccdp": {
                    String text = new Cta708Parser().parseToStringWithOpCodes(iis);
                    out.data = text;
                    break;
                }
                default: {
                    throw new IOException("Unsupported chunk type. chunk=" + type + ", size=" + size + ", buffer length " + in.length);
                }
            }
        }
        catch (IOException e) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        return 0;
    }

    public int encode(Buffer in, Buffer out) {
        String data;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        String string = data = in.data instanceof String ? (String)in.data : null;
        if (data == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        return 0;
    }
}

