/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text.cta608;

import java.util.LinkedHashMap;
import java.util.Map;
import org.monte.media.quicktime.codec.text.cta608.Token;

public final class CmdToken
implements Token {
    private final short code;

    public CmdToken(short code) {
        if ((code & 0x7040) != 4096) {
            throw new IllegalArgumentException("code=" + Integer.toHexString(code));
        }
        this.code = Token.fixParityBits(code);
    }

    public CmdToken(int channel, Command command) {
        if (channel < 1 || channel > 2) {
            throw new IllegalArgumentException("channel=" + channel);
        }
        if (command == null) {
            throw new IllegalArgumentException("operation is null");
        }
        int opCode = command.code;
        int low = opCode & 0x3F;
        int high = 0x10 | channel - 1 << 3 | (opCode & 0x1C0) >>> 6;
        this.code = Token.fixParityBits((short)(high << 8 | low));
    }

    public int getChannel() {
        return ((this.code & 0x800) >> 11) + 1;
    }

    public short getCode() {
        return this.code;
    }

    public short getCodeWithoutParity() {
        return (short)(this.code & 0x7F7F);
    }

    public Command getOperation() {
        int high = this.code & 0x700;
        int low = this.code & 0x3F;
        int opCode = high >>> 2 | low;
        return Command.valueOf(opCode);
    }

    public static enum Command {
        BWO(32),
        BWS(33),
        BGO(34),
        BGS(35),
        BBO(36),
        BBS(37),
        BCO(38),
        BCS(39),
        BRO(40),
        BRS(41),
        BYO(42),
        BYS(43),
        BMO(44),
        BMS(45),
        BAO(46),
        BAS(47),
        BT(493),
        FA(494),
        FAU(495),
        CHARSET_STANDARD(0),
        CHARSET_STANDARD_DOUBLE_SIZE(0),
        CHARSET_PRIVATE_1(0),
        CHARSET_PRIVATE_2(0),
        CHARSET_CHINESE(0),
        CHARSET_KOREAN(0),
        CHARSET_REGISTERED_1(0),
        WHITE(96),
        WHITE_UNDERLINE(97),
        GREEN(98),
        GREEN_UNDERLINE(99),
        BLUE(100),
        BLUE_UNDERLINE(101),
        CYAN(102),
        CYAN_UNDERLINE(103),
        RED(104),
        RED_UNDERLINE(105),
        YELLOW(106),
        YELLOW_UNDERLINE(107),
        MAGENTA(108),
        MAGENTA_UNDERLINE(109),
        ITALICS(110),
        ITALICS_UNDERLINE(111),
        RCL(288),
        BS(289),
        AOF(290),
        AON(291),
        DER(292),
        RU2(293),
        RU3(294),
        RU4(295),
        FON(296),
        RDC(297),
        TR(298),
        RTD(299),
        EDM(300),
        CR(301),
        ENM(302),
        EOC(303),
        TO1(481),
        TO2(482),
        TO3(483);

        private final int code;
        private static Map<Integer, Command> codeMap;

        private Command(int code) {
            this.code = code;
        }

        public static Command valueOf(int opCode) {
            if (codeMap == null) {
                LinkedHashMap<Integer, Command> m = new LinkedHashMap<Integer, Command>();
                for (Command value : Command.values()) {
                    m.put(value.code, value);
                }
                codeMap = m;
            }
            return codeMap.get(opCode);
        }
    }
}

