/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text.cta608;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.io.UncachedImageInputStream;
import org.monte.media.quicktime.codec.text.cta608.CmdToken;
import org.monte.media.quicktime.codec.text.cta608.PacToken;
import org.monte.media.quicktime.codec.text.cta608.TextToken;
import org.monte.media.quicktime.codec.text.cta608.Token;

public class Cta608Parser {
    public List<Token> parse(InputStream in) throws IOException {
        ImageInputStream imageInputStream;
        if (in instanceof ImageInputStream) {
            ImageInputStream s = (ImageInputStream)((Object)in);
            imageInputStream = s;
        } else {
            imageInputStream = new UncachedImageInputStream(in);
        }
        ImageInputStream iis = imageInputStream;
        return this.parse(iis);
    }

    public List<Token> parse(ImageInputStream iis) throws IOException {
        long length = iis.length();
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder buf = new StringBuilder();
        int b = iis.readUnsignedShort();
        while (iis.getStreamPosition() < length - 1L) {
            switch ((b &= 0x7F7F) & 0x7040) {
                case 4096: {
                    Cta608Parser.drainTextBuffer(tokens, buf);
                    this.parseCommandCode(tokens, b);
                    break;
                }
                case 4160: {
                    Cta608Parser.drainTextBuffer(tokens, buf);
                    this.parsePreambleCode(tokens, b);
                    break;
                }
                default: {
                    this.parseCharacters(buf, b);
                }
            }
            b = iis.readUnsignedShort();
        }
        Cta608Parser.drainTextBuffer(tokens, buf);
        return tokens;
    }

    private void parsePreambleCode(List<Token> buf, int b) throws IOException {
        buf.add(new PacToken((short)b));
    }

    private void parseCommandCode(List<Token> buf, int b) throws IOException {
        buf.add(new CmdToken((short)b));
    }

    private static void drainTextBuffer(List<Token> tokens, StringBuilder buf) {
        if (!buf.isEmpty()) {
            tokens.add(new TextToken(buf.toString()));
            buf.setLength(0);
        }
    }

    private void parseCharacters(StringBuilder buf, int b) throws IOException {
        buf.append((char)(b >>> 8));
        if ((b & 0xFF) != 0) {
            buf.append((char)(b & 0xFF));
        }
    }

    public String parseToStringWithOpCodes(InputStream in) throws IOException {
        ImageInputStream imageInputStream;
        if (in instanceof ImageInputStream) {
            ImageInputStream s = (ImageInputStream)((Object)in);
            imageInputStream = s;
        } else {
            imageInputStream = new UncachedImageInputStream(in);
        }
        ImageInputStream iis = imageInputStream;
        return this.parseToStringWithOpCodes(iis);
    }

    public String parseToString(InputStream in) throws IOException {
        ImageInputStream imageInputStream;
        if (in instanceof ImageInputStream) {
            ImageInputStream s = (ImageInputStream)((Object)in);
            imageInputStream = s;
        } else {
            imageInputStream = new UncachedImageInputStream(in);
        }
        ImageInputStream iis = imageInputStream;
        return this.parseToString(iis);
    }

    private String parseToString(ImageInputStream iis) throws IOException {
        List<Token> tokens = new Cta608Parser().parse(iis);
        StringBuilder buf = new StringBuilder();
        for (Token token : tokens) {
            if (!(token instanceof TextToken)) continue;
            buf.append(((TextToken)token).getText());
        }
        return buf.toString();
    }

    public String parseToStringWithOpCodes(ImageInputStream iis) throws IOException {
        List<Token> tokens = new Cta608Parser().parse(iis);
        StringBuilder buf = new StringBuilder();
        for (Token token : tokens) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (token instanceof TextToken) {
                buf.append('\"');
                buf.append(((TextToken)token).getText().replaceAll("\"", "\\\""));
                buf.append('\"');
                continue;
            }
            if (token instanceof CmdToken) {
                CmdToken ct = (CmdToken)token;
                buf.append('{');
                buf.append(ct.getChannel());
                buf.append(':');
                if (ct.getOperation() == null) {
                    buf.append(Integer.toHexString(ct.getCodeWithoutParity()));
                } else {
                    buf.append((Object)ct.getOperation());
                }
                buf.append('}');
                continue;
            }
            if (!(token instanceof PacToken)) continue;
            PacToken ct = (PacToken)token;
            buf.append('{');
            buf.append(ct.getChannel());
            buf.append(":R");
            buf.append(ct.getRow());
            buf.append(":");
            buf.append((Object)ct.getTextAttributes());
            if (ct.isUnderline()) {
                buf.append(":UL");
            }
            buf.append('}');
        }
        return buf.toString();
    }
}

