/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text.cta608;

import java.util.Objects;
import org.monte.media.quicktime.codec.text.cta608.Token;

public class PacToken
implements Token {
    private static final int[] rowEncode = new int[]{-1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 0, 6, 7, 8, 9};
    private static final int[] rowDecode = new int[]{11, -1, 1, 2, 3, 4, 12, 13, 14, 15, 5, 6, 7, 8, 9, 10};
    private final short code;

    public PacToken(short code) {
        if ((code & 0x7040) != 4160) {
            throw new IllegalArgumentException("code=" + Integer.toHexString(code));
        }
        this.code = Token.fixParityBits(code);
    }

    public PacToken(int channel, int row, Attributes attributes, boolean underline) {
        if (channel < 1 || channel > 2) {
            throw new IllegalArgumentException("channel=" + channel);
        }
        if (row < 1 || row > 15) {
            throw new IllegalArgumentException("row=" + row);
        }
        Objects.requireNonNull(attributes, "textAttribute is null");
        int attrs = attributes.ordinal();
        int u = underline ? 1 : 0;
        int rrrr = rowEncode[row];
        int low = 0x40 | (rrrr & 1) << 5 | attrs << 1 | u;
        int high = 0x10 | channel - 1 << 3 | (rrrr & 0xE) >>> 1;
        this.code = Token.fixParityBits((short)(high << 8 | low));
    }

    public int getRow() {
        int rowHigh = (this.code & 0x700) >> 7;
        int rowLow = (this.code & 0x20) >> 5;
        int row = rowHigh | rowLow;
        return rowDecode[row];
    }

    public int getChannel() {
        return ((this.code & 0x800) >> 11) + 1;
    }

    public Attributes getTextAttributes() {
        int attrs = (this.code & 0x1E) >>> 1;
        return Attributes.values()[attrs];
    }

    public short getCode() {
        return this.code;
    }

    public short getCodeWithoutParity() {
        return (short)(this.code & 0x7F7F);
    }

    public boolean isUnderline() {
        return (this.code & 1) != 0;
    }

    public static enum Attributes {
        WHITE,
        GREEN,
        BLUE,
        CYAN,
        RED,
        YELLOW,
        MAGENTA,
        WHITE_ITALICS,
        INDENT_0,
        INDENT_4,
        INDENT_8,
        INDENT_12,
        INDENT_16,
        INDENT_20,
        INDENT_24,
        INDENT_28;

    }
}

