/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text.cta708;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class CCDataInputStream
extends InputStream {
    private final InputStream in;
    long remaining;

    protected CCDataInputStream(InputStream in) {
        this.in = in;
    }

    protected CCDataInputStream(InputStream in, int remaining) {
        this.in = in;
        this.remaining = (long)Math.max(0, remaining) * 2L;
    }

    private void readHeader() throws IOException {
    }

    @Override
    public int read() throws IOException {
        block9: {
            while (true) {
                if (this.remaining <= 0L) {
                    int header = this.in.read();
                    int cc_count = 0;
                    while (true) {
                        if (header < 0) {
                            return -1;
                        }
                        int headerMarkerBits = header & 0xA0;
                        if (headerMarkerBits != 128) {
                            header = this.in.read();
                            continue;
                        }
                        int reserved = this.readFully();
                        if (reserved != 255) {
                            header = reserved;
                            continue;
                        }
                        int process_cc_data_flag = header & 0x40;
                        cc_count = header & 0x1F;
                        if (process_cc_data_flag == 0) {
                            this.in.skipNBytes(cc_count);
                            header = this.in.read();
                            continue;
                        }
                        if (cc_count != 0) break;
                        header = this.in.read();
                    }
                    this.remaining = cc_count * 2;
                }
                if ((this.remaining & 1L) != 0L) break block9;
                --this.remaining;
                int cc_valid_and_type = this.in.read();
                if (cc_valid_and_type < 0) {
                    return -1;
                }
                int cc_valid = cc_valid_and_type & 4;
                int cc_type = cc_valid_and_type & 3;
                if (cc_valid != 0 && cc_type >= 2) break;
                int b = this.in.read() | this.in.read();
                if (b < 0) {
                    return -1;
                }
                --this.remaining;
            }
            return this.in.read();
        }
        --this.remaining;
        return this.in.read();
    }

    private int readFully() throws IOException {
        int data = this.in.read();
        if (data < 0) {
            throw new EOFException();
        }
        return data;
    }
}

