/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime.codec.text.cta708;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.quicktime.codec.text.cta708.CCDataInputStream;

public class Cta708Parser {
    private static final int[] numBytes = new int[256];
    private static final int TT_SKIP = -1;
    private static final int TT_EXT1 = -2;
    private static final int TT_ETX = -3;
    private static final int TT_CR = -4;
    private static final int TT_HCR = -5;
    private static final int TT_FF = -6;
    private static final int[] codeType;

    public String parse(InputStream in) throws IOException {
        CCDataInputStream ccin = new CCDataInputStream(in, Integer.MAX_VALUE);
        StringBuilder buf = new StringBuilder();
        int b = ccin.read();
        while (b >= 0) {
            switch (codeType[b]) {
                case -1: {
                    ccin.skipNBytes(numBytes[b] - 1);
                    break;
                }
                default: {
                    buf.append((char)b);
                    int n = numBytes[b];
                    for (int i = 1; i < n; ++i) {
                        buf.append((char)ccin.read());
                    }
                }
            }
            b = ccin.read();
        }
        return buf.toString();
    }

    public void parse(ImageInputStream in) throws IOException {
        this.parse(new ImageInputStreamAdapter(in));
    }

    public String parseToStringWithOpCodes(InputStream in) throws IOException {
        in.skipNBytes(3L);
        return this.parse(in);
    }

    public String parseToStringWithOpCodes(ImageInputStream in) throws IOException {
        return this.parseToStringWithOpCodes(new ImageInputStreamAdapter(in));
    }

    static {
        Arrays.fill(numBytes, 1);
        Arrays.fill(numBytes, 16, 17, 2);
        Arrays.fill(numBytes, 17, 24, 2);
        Arrays.fill(numBytes, 24, 32, 3);
        Arrays.fill(numBytes, 128, 147, 2);
        Arrays.fill(numBytes, 151, 160, 2);
        codeType = new int[256];
        for (int i = 0; i < 256; ++i) {
            Cta708Parser.codeType[i] = i;
        }
        Cta708Parser.codeType[3] = -3;
        Cta708Parser.codeType[12] = -6;
        Cta708Parser.codeType[13] = -4;
        Cta708Parser.codeType[14] = -5;
        Cta708Parser.codeType[16] = -2;
        Cta708Parser.codeType[255] = 9834;
        Arrays.fill(codeType, 1, 3, -1);
        Arrays.fill(codeType, 4, 8, -1);
        Arrays.fill(codeType, 9, 12, -1);
        Arrays.fill(codeType, 15, 16, -1);
        Arrays.fill(codeType, 17, 24, -1);
        Arrays.fill(codeType, 25, 32, -1);
    }
}

