/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.math.Rational;
import org.monte.media.tiff.IFD;
import org.monte.media.tiff.IFDEntry;

public class TIFFInputStream
extends InputStream {
    private ByteOrder byteOrder;
    private long firstIFDOffset;
    private final ImageInputStream in;

    public TIFFInputStream(ImageInputStream in) throws IOException {
        this.in = in;
        this.readHeader();
    }

    public TIFFInputStream(ImageInputStream in, ByteOrder byteOrder, long firstIFDOffset) {
        this.in = in;
        this.byteOrder = byteOrder;
        this.firstIFDOffset = firstIFDOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder newValue) {
        this.byteOrder = newValue;
    }

    public long getFirstIFDOffset() {
        return this.firstIFDOffset;
    }

    public IFD readIFD(long offset) throws IOException {
        return this.readIFD(offset, true, false);
    }

    public IFD readIFD(long offset, boolean hasNextOffset, boolean isFirstIFD) throws IOException {
        if (offset % 1L != 0L) {
            throw new IOException("IFD does not start at word boundary");
        }
        if (offset == 0L && !isFirstIFD) {
            return null;
        }
        this.in.seek(offset);
        int numEntries = this.readSHORT();
        IFD ifd = new IFD(offset, hasNextOffset);
        for (int i = 0; i < numEntries; ++i) {
            long entryOffset = this.in.getStreamPosition();
            int tag = this.readSHORT();
            int type = this.readSHORT();
            long count = this.readLONG();
            long valueOffset = this.readSLONG();
            if (count == 0L) {
                throw new IOException("IFDEntry " + i + " of " + numEntries + " has count 0 in TIFF stream at offset 0x" + Long.toHexString(offset));
            }
            ifd.add(new IFDEntry(tag, type, count, valueOffset, entryOffset));
        }
        if (hasNextOffset) {
            ifd.setNextOffset(this.readSLONG());
            if (ifd.getNextOffset() % 1L != 0L) {
                throw new IOException("next IFD does not start at word boundary");
            }
        }
        return ifd;
    }

    public String readASCII(long offset, long length) throws IOException {
        this.in.seek(offset);
        return this.readASCII(length);
    }

    private String readASCII(long length) throws IOException {
        byte[] buf = new byte[(int)length];
        this.readFully(buf);
        if (buf[(int)length - 1] != 0) {
            throw new IOException("String does not end with NUL byte.");
        }
        return new String(buf, 0, (int)length - 1, StandardCharsets.US_ASCII);
    }

    private void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException("EOF after " + n + " bytes (needed " + len + " bytes)");
        }
    }

    public long readLONG(long offset) throws IOException {
        this.in.seek(offset);
        return this.readLONG();
    }

    public long[] readLONG(long offset, long count) throws IOException {
        this.in.seek(offset);
        long[] longs = new long[(int)count];
        int i = 0;
        while ((long)i < count) {
            longs[i] = this.readLONG();
            ++i;
        }
        return longs;
    }

    public int readSLONG(long offset) throws IOException {
        this.in.seek(offset);
        return this.readSLONG();
    }

    public int[] readSLONG(long offset, long count) throws IOException {
        this.in.seek(offset);
        int[] longs = new int[(int)count];
        int i = 0;
        while ((long)i < count) {
            longs[i] = this.readSLONG();
            ++i;
        }
        return longs;
    }

    public int[] readSHORT(long offset, long count) throws IOException {
        this.in.seek(offset);
        int[] shorts = new int[(int)count];
        int i = 0;
        while ((long)i < count) {
            shorts[i] = this.readSHORT();
            ++i;
        }
        return shorts;
    }

    public short[] readSSHORT(long offset, long count) throws IOException {
        this.in.seek(offset);
        short[] shorts = new short[(int)count];
        int i = 0;
        while ((long)i < count) {
            shorts[i] = this.readSSHORT();
            ++i;
        }
        return shorts;
    }

    public Rational readRATIONAL(long offset) throws IOException {
        this.in.seek(offset);
        long num = this.readLONG();
        long denom = this.readLONG();
        return new Rational(num, denom);
    }

    public Rational readSRATIONAL(long offset) throws IOException {
        this.in.seek(offset);
        int num = this.readSLONG();
        int denom = this.readSLONG();
        return new Rational(num, denom);
    }

    public Rational[] readRATIONAL(long offset, long count) throws IOException {
        this.in.seek(offset);
        Rational[] r = new Rational[(int)count];
        int i = 0;
        while ((long)i < count) {
            r[i] = new Rational(this.readLONG(), this.readLONG());
            ++i;
        }
        return r;
    }

    public Rational[] readSRATIONAL(long offset, long count) throws IOException {
        this.in.seek(offset);
        Rational[] r = new Rational[(int)count];
        int i = 0;
        while ((long)i < count) {
            r[i] = new Rational(this.readSLONG(), this.readSLONG());
            ++i;
        }
        return r;
    }

    private short readSSHORT() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        if (b0 == -1 || b1 == -1) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (short)(b1 << 8 | b0);
        }
        return (short)(b0 << 8 | b1);
    }

    private int readSHORT() throws IOException {
        return this.readSSHORT() & 0xFFFF;
    }

    private int readSLONG() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        if (b0 == -1 || b1 == -1 || b1 == -1 || b2 == -1) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    private long readLONG() throws IOException {
        return (long)this.readSLONG() & 0xFFFFFFFFL;
    }

    private void readHeader() throws IOException {
        this.in.seek(0L);
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        int byteOrder = this.readSHORT();
        switch (byteOrder) {
            case 18761: {
                this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 19789: {
                this.byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new IOException("Image File Header illegal byte order value 0x" + Integer.toHexString(byteOrder));
            }
        }
        int magic = this.readSHORT();
        if (magic != 42) {
            throw new IOException("Image File Header illegal magic value 0x" + Integer.toHexString(magic));
        }
        this.firstIFDOffset = this.readSLONG();
        if ((this.firstIFDOffset & 1L) == 1L) {
            throw new IOException("Image File Header IFD must be on a word boundary 0x" + Long.toHexString(this.firstIFDOffset));
        }
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public int read(long offset, byte[] b, int off, int len) throws IOException {
        this.in.seek(offset);
        return this.in.read(b, off, len);
    }
}

