/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.HashMap;
import org.monte.media.tiff.TIFFTag;

public abstract class TagSet {
    private final HashMap<Integer, TIFFTag> tagsByNumber = new HashMap();
    private final String name;

    public TagSet(String name, TIFFTag[] tags) {
        this.name = name;
        for (TIFFTag tag : tags) {
            tag.setTagSet(this);
            this.tagsByNumber.put(tag.getNumber(), tag);
        }
    }

    public TIFFTag getTag(int tagNumber) {
        TIFFTag tag = this.tagsByNumber.get(tagNumber);
        return tag == null ? new TIFFTag("unknown", tagNumber, -1, null) : tag;
    }

    public String getName() {
        return this.name;
    }
}

