/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.EnumSet;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.math.Rational;
import org.monte.media.util.Methods;

public class Buffer {
    public EnumSet<BufferFlag> flags = EnumSet.noneOf(BufferFlag.class);
    public static final int NOT_SPECIFIED = -1;
    public int track;
    public Object header;
    public int headerOffset;
    public int headerLength;
    public Object data;
    public int offset;
    public int length;
    public Rational sampleDuration;
    public Rational timeStamp;
    public Format format;
    public int sampleCount = 1;
    public long sequenceNumber;

    public void setMetaTo(Buffer that) {
        this.flags = EnumSet.copyOf(that.flags);
        this.track = that.track;
        this.sampleDuration = that.sampleDuration;
        this.timeStamp = that.timeStamp;
        this.format = that.format;
        this.sampleCount = that.sampleCount;
        this.format = that.format;
        this.sequenceNumber = that.sequenceNumber;
    }

    public void setDataTo(Buffer that) {
        this.offset = that.offset;
        this.length = that.length;
        this.data = this.copy(that.data, this.data);
        this.header = this.copy(that.header, this.header);
    }

    private Object copy(Object from, Object into) {
        if (from instanceof byte[]) {
            byte[] b = (byte[])from;
            if (!(into instanceof byte[]) || ((byte[])into).length < b.length) {
                into = new byte[b.length];
            }
            System.arraycopy(b, 0, (byte[])into, 0, b.length);
        } else if (from instanceof BufferedImage) {
            BufferedImage img = (BufferedImage)from;
            ColorModel cm = img.getColorModel();
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            WritableRaster raster = img.copyData(null);
            into = new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        } else if (from instanceof Cloneable) {
            try {
                into = Methods.invoke(from, "clone");
            }
            catch (NoSuchMethodException ex) {
                into = from;
            }
        } else {
            into = from;
        }
        return into;
    }

    public boolean isFlag(BufferFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public void setFlag(BufferFlag flag) {
        this.setFlag(flag, true);
    }

    public void clearFlag(BufferFlag flag) {
        this.setFlag(flag, false);
    }

    public void setFlag(BufferFlag flag, boolean value) {
        if (value) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
    }

    public void setFlagsTo(BufferFlag ... flags) {
        this.flags = flags.length == 0 ? EnumSet.noneOf(BufferFlag.class) : EnumSet.copyOf(Arrays.asList(flags));
    }

    public void setFlagsTo(EnumSet<BufferFlag> flags) {
        this.flags = flags == null ? EnumSet.noneOf(BufferFlag.class) : EnumSet.copyOf(flags);
    }

    public void clearFlags() {
        this.flags.clear();
    }

    public String toString() {
        return super.toString() + "{tr#:" + this.track + ",seq#:" + this.sequenceNumber + ",ts:" + String.valueOf(this.timeStamp) + ",duration:" + String.valueOf(this.sampleDuration) + ",#samples:" + this.sampleCount + ",flags:" + String.valueOf(this.flags) + ",format:" + String.valueOf(this.format) + ",data:" + String.valueOf(this.data) + ",offset:" + this.offset + ",length:" + this.length + ",header:" + String.valueOf(this.data) + ",hOffset:" + this.headerOffset + ",hLength:" + this.headerLength + "}";
    }
}

