/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.video;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.video.AbstractVideoCodec;
import org.monte.media.av.codec.video.TechSmithCodecCore;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.image.BufferedImageWithColorModel;
import org.monte.media.io.SeekableByteArrayOutputStream;

public class TechSmithCodec
extends AbstractVideoCodec {
    private TechSmithCodecCore state;
    private Object previousPixels;
    private int frameCounter;
    private ColorModel previousColorModel;
    private Object newPixels;

    public TechSmithCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})});
        this.name = "TechSmith Screen Capture";
    }

    @Override
    public Format setOutputFormat(Format f) {
        super.setOutputFormat(f);
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey));
        }
        return this.outputFormat;
    }

    @Override
    public void reset() {
        this.state = null;
        this.frameCounter = 0;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.state == null) {
            this.state = new TechSmithCodecCore();
        }
        if (in.isFlag(BufferFlag.DISCARD)) {
            out.setMetaTo(in);
            return 0;
        }
        if (this.outputFormat.get(FormatKeys.EncodingKey).equals("tscc")) {
            return this.encode(in, out);
        }
        return this.decode(in, out);
    }

    public int decode(Buffer in, Buffer out) {
        boolean isKeyFrame;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        out.length = 1;
        out.offset = 0;
        if (this.state == null) {
            this.state = new TechSmithCodecCore();
        }
        int width = this.outputFormat.get(VideoFormatKeys.WidthKey);
        int height = this.outputFormat.get(VideoFormatKeys.HeightKey);
        int inputDepth = this.inputFormat.get(VideoFormatKeys.DepthKey);
        int outputDepth = this.outputFormat.get(VideoFormatKeys.DepthKey, inputDepth);
        try {
            if (outputDepth == 8) {
                if (!(this.newPixels instanceof byte[]) || ((byte[])this.newPixels).length != width * height) {
                    this.newPixels = new byte[width * height];
                }
                isKeyFrame = this.state.decode8((byte[])in.data, in.offset, in.length, (byte[])this.newPixels, (byte[])this.newPixels, width, height, false);
            } else {
                if (!(this.newPixels instanceof int[]) || ((int[])this.newPixels).length != width * height) {
                    this.newPixels = new int[width * height];
                }
                isKeyFrame = inputDepth == 8 ? this.state.decode8((byte[])in.data, in.offset, in.length, (int[])this.newPixels, (int[])this.newPixels, width, height, false) : (inputDepth == 16 ? this.state.decode16((byte[])in.data, in.offset, in.length, (int[])this.newPixels, (int[])this.newPixels, width, height, false) : this.state.decode24((byte[])in.data, in.offset, in.length, (int[])this.newPixels, (int[])this.newPixels, width, height, false));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        BufferedImageWithColorModel img = null;
        if (out.data instanceof BufferedImageWithColorModel) {
            img = (BufferedImageWithColorModel)out.data;
        }
        switch (outputDepth) {
            case 8: {
                int[] cmap;
                int imgType = 13;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    cmap = new int[256];
                    IndexColorModel icm = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
                    img = new BufferedImageWithColorModel(width, height, imgType, icm);
                } else {
                    BufferedImageWithColorModel oldImg = img;
                    img = new BufferedImageWithColorModel(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                cmap = new int[256];
                for (int i = 0; i < 256; ++i) {
                    cmap[i] = 0xFF000000 | i | i << 8 | i << 16;
                }
                IndexColorModel icm = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
                img.setColorModel(icm);
                byte[] pixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((byte[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            case 15: {
                int imgType = 9;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    DirectColorModel cm = new DirectColorModel(15, 31744, 992, 31);
                    img = new BufferedImageWithColorModel(cm, Raster.createWritableRaster(cm.createCompatibleSampleModel(width, height), new Point(0, 0)), false);
                } else {
                    BufferedImageWithColorModel oldImg = img;
                    img = new BufferedImageWithColorModel(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                short[] pixels = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((short[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            case 16: 
            case 24: {
                int imgType = 1;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    img = new BufferedImageWithColorModel(cm, Raster.createWritableRaster(cm.createCompatibleSampleModel(width, height), new Point(0, 0)), false);
                } else {
                    BufferedImageWithColorModel oldImg = img;
                    img = new BufferedImageWithColorModel(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((int[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth:" + outputDepth);
            }
        }
        out.setFlag(BufferFlag.KEYFRAME, isKeyFrame);
        out.data = img;
        return 0;
    }

    public int encode(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        Integer keyFrameInterval = this.outputFormat.get(FormatKeys.KeyFrameIntervalKey, this.outputFormat.get(FormatKeys.FrameRateKey).intValue());
        boolean isKeyframe = this.frameCounter == 0 || keyFrameInterval == 0 || this.frameCounter % keyFrameInterval == 0;
        out.setFlag(BufferFlag.KEYFRAME, isKeyframe);
        out.clearFlag(BufferFlag.SAME_DATA);
        ++this.frameCounter;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
            out.header = image.getColorModel();
        } else {
            r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
            scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
            out.header = null;
        }
        int offset = r.x + r.y * scanlineStride;
        try {
            switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 1;
                    }
                    ColorModel newColorModel = this.getColorModel(in);
                    if (this.previousColorModel == null || !this.previousColorModel.equals(newColorModel)) {
                        out.header = newColorModel;
                        this.previousColorModel = newColorModel;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey8(tmp, (byte[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                    } else {
                        if (in.isFlag(BufferFlag.SAME_DATA)) {
                            this.state.encodeSameDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                        } else {
                            this.state.encodeDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                        }
                        out.clearFlag(BufferFlag.KEYFRAME);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (byte[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = this.getRGB15(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 1;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey16(tmp, (short[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                    } else if (in.isFlag(BufferFlag.SAME_DATA)) {
                        this.state.encodeSameDelta16(tmp, (short[])pixels, (short[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                    } else {
                        this.state.encodeDelta16(tmp, (short[])pixels, (short[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (short[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 1;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey24(tmp, (int[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME);
                    } else {
                        if (in.isFlag(BufferFlag.SAME_DATA)) {
                            this.state.encodeSameDelta24(tmp, (int[])pixels, (int[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                        } else {
                            this.state.encodeDelta24(tmp, (int[])pixels, (int[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride);
                        }
                        out.clearFlag(BufferFlag.KEYFRAME);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (int[])this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 1;
                }
            }
            out.format = this.outputFormat;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.sampleCount = 1;
            out.length = tmp.size();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 0;
        }
    }
}

